#!/usr/bin/env python

#-----------------------------------------------------------------------
# concord.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import re

#-----------------------------------------------------------------------

def process_line(line, concordance):

    line = line.lower()

    re_letters = re.compile(r'[a-z]+')
    words = re_letters.findall(line)

    for word in words:
        if word in concordance:
            concordance[word] += 1
        else:
            concordance[word] = 1

#-----------------------------------------------------------------------

def main():

    concordance = {}

    for line in sys.stdin:
        process_line(line, concordance)

    #for word in concordance:
    #    print(f'{word}: {concordance[word]}')

    for word, count in concordance.items():
        print(f'{word}: {count}')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
