#!/usr/bin/env python

#-----------------------------------------------------------------------
# circle4.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import math

#-----------------------------------------------------------------------

def read_radius():

    line = input("Enter the circle's radius:\n")
    radius = int(line)
    return radius

#-----------------------------------------------------------------------

def write_results(radius, diam, circum):

    print(f'A circle with radius {radius} has diameter {diam}')
    print(f'and circumference {circum:.2f}.')

#-----------------------------------------------------------------------

def main():

    try:
        radius = read_radius()

        diam = 2 * radius
        circum = math.pi * float(diam)

        write_results(radius, diam, circum)

    except ValueError:
        print('Error: Not an integer', file=sys.stderr)

    except EOFError:
        print('Error: Missing integer', file=sys.stderr)

    print('Thank you for running the program.')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
