/* *****************************************************************************
 *
 *  Description: Counts the number of times each String has occurred.
 *
 *  % more duckduckgoose.txt
 *  duck duck goose
 *
 *  % java-introcs FrequencyTable < duckduckgoose.txt
 *  duck 2
 *  goose 1
 *
 *  Remarks:
 *   - This is book/booksite Exercise 4.4.45
 *   - Use with any text file
 *
 **************************************************************************** */

public class FrequencyTable {
    // maintain counts of all words seen so far
    // the KEY is the word and the VALUE is the count
    private ST<_________________> st;
   
    // a no-argument constructor
    public FrequencyTable() {
        // create an empty ST
        st = null; // fix this
    }
    
    // add 1 to the frequency of this word
    public void increment(String word) {
        int count = frequencyOf(word); // get current frequency
        st.put(word, count + 1);
    }
   
    // what is the frequency of this word?
    public int frequencyOf(String word) {
        // check if word is in the symbol table
        if (st.__________(______))
            return st._____(______);          // in table? return the value
        else
            return 0;                         // if no?  return 0
            
    }
    // return string representation of frequency table
    public String toString() {
        // using StringBuilder - a mutable String that is more
        // efficient than String for constructing large Strings
        StringBuilder sb = new StringBuilder();
        
        // enhanced for loop goes through all keys in STin alphabetical order
        for (String word : st.keys()) { // word set to each key
            // get frequency of this word
            int count = ______(_____);
            // append word and its count
            sb.append(______ + " " + _____ + "\n");
        }
        return sb.toString();
    }

   
   
    // method used by client to count all words in StdIn
    public static void main(String[] args) {
        
        // build frequency table from words on standard input
        FrequencyTable freq = new FrequencyTable();
        while (!StdIn.isEmpty()) {
            String word = StdIn.readString();
            freq.increment(word);
        }
        
        // print frequency table to standard output
        StdOut.println(freq);
    }
}

