/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class TuringTapeArea
extends JPanel {
    boolean machineIsRunning = false;
    boolean tapeInit = false;
    int cellWidth = 40;
    double newLeftCellWidth = 0.0;
    double newRightCellWidth = 0.0;
    int cellHeight = 40;
    int fontSize = 20;
    int shift;
    int filler;
    int leftMostCell = 0;
    int rightMostCell = 0;
    Dimension areaSize;
    int origin = 0;
    boolean grow = false;
    boolean newLeftCell = false;
    boolean newRightCell = false;
    double animationInc;
    Tape tape;
    Color currentTextColor = Color.black;
    final int LEFT_SHIFT = 0;
    final int RIGHT_SHIFT = 1;
    final int ADD_DELAY = 10;
    final int FONT_STYLE = 1;
    final String FONT_NAME = "Monotype";
    final Color BG_COLOR = new Color(200, 200, 200);
    final Color DEFAULT_CELL_COLOR = Color.white;
    final Color CURRENT_CELL_COLOR = Color.orange;
    final Color CELL_INDEX_COLOR = new Color(0, 130, 0);
    final double beginTab = 0.0;
    final double INITIAL_OFFSET = -1.5;
    double offset = -1.5;
    public final Color DEFAULT_TEXT_COLOR = Color.black;

    public void setTape(Tape t) {
        this.tape = t;
    }

    public void resetColors() {
        this.currentTextColor = Color.black;
    }

    public void removePartialCells() {
        this.newLeftCellWidth = 0.0;
        this.newRightCellWidth = 0.0;
    }

    @Override
    public void paintComponent(Graphics g) {
        int fontScalingFactor;
        int stringHeight;
        int stringWidth;
        Rectangle2D charBounds;
        int currentPosition;
        int cellsToDraw;
        boolean startAt;
        int[] tapeEndX = new int[7];
        int[] tapeEndY = new int[7];
        int index = 0;
        FontRenderContext DEFAULT_FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);
        super.paintComponent(g);
        if (this.tape == null) {
            return;
        }
        g.setColor(this.BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int tapeLength = this.tape.getSize();
        if (this.areaSize != null && (this.areaSize.width != this.getSize().width || this.areaSize.height != this.getSize().height)) {
            this.tapeInit = false;
        }
        this.areaSize = this.getSize();
        int yAlign = this.areaSize.height / 2;
        this.cellWidth = this.getHeight() - 2;
        if (this.cellWidth > 40) {
            this.cellWidth = 40;
        }
        this.cellHeight = this.cellWidth;
        this.fontSize = this.cellWidth / 2;
        if (this.newLeftCell) {
            startAt = true;
            cellsToDraw = tapeLength - 1;
            currentPosition = 0;
        } else if (this.newRightCell) {
            startAt = false;
            cellsToDraw = tapeLength - 1;
            currentPosition = tapeLength - 2;
        } else {
            startAt = false;
            cellsToDraw = tapeLength;
            currentPosition = this.tape.getCurrentPosition();
        }
        currentPosition = this.tape.getCurrentPosition();
        if (!this.tapeInit) {
            this.filler = 0;
            while (this.cellWidth * (1 + 2 * this.filler) <= this.areaSize.width) {
                ++this.filler;
            }
            ++this.filler;
            this.leftMostCell = currentPosition - this.filler;
            this.rightMostCell = this.leftMostCell + 2 * this.filler;
            while (-this.leftMostCell < this.rightMostCell - tapeLength - 1 && 0 < this.rightMostCell - tapeLength - 1) {
                --this.leftMostCell;
                --this.rightMostCell;
            }
            while (-this.leftMostCell > this.rightMostCell - tapeLength + 1 && this.leftMostCell < 0) {
                ++this.leftMostCell;
                ++this.rightMostCell;
            }
        }
        if (this.grow) {
            if (currentPosition - 3 < this.leftMostCell) {
                while (currentPosition < this.leftMostCell + 3) {
                    --this.leftMostCell;
                    --this.rightMostCell;
                }
            } else {
                while (currentPosition > this.rightMostCell - 3) {
                    ++this.leftMostCell;
                    ++this.rightMostCell;
                }
            }
            this.grow = false;
        }
        if (this.origin != this.tape.getOrigin()) {
            ++this.leftMostCell;
            ++this.rightMostCell;
        }
        this.origin = this.tape.getOrigin();
        this.tapeInit = true;
        int drawPos = 0;
        int i = this.leftMostCell;
        while (i <= this.rightMostCell) {
            String symbol;
            if (i >= 0 && i < tapeLength) {
                symbol = this.tape.getSymbolAt(i);
            } else {
                TuringTapeArea turingTapeArea = this;
                symbol = turingTapeArea.tape.getFillSymbol();
            }
            if (i == currentPosition) {
                g.setColor(this.CURRENT_CELL_COLOR);
            } else {
                g.setColor(this.DEFAULT_CELL_COLOR);
            }
            g.fillRect((int)((this.newLeftCellWidth + (double)drawPos + this.offset) * (double)this.cellWidth), yAlign - this.cellHeight / 2, this.cellWidth, this.cellHeight);
            g.setColor(Color.black);
            g.drawRect((int)((this.newLeftCellWidth + (double)drawPos + this.offset) * (double)this.cellWidth), yAlign - this.cellHeight / 2, this.cellWidth, this.cellHeight);
            charBounds = g.getFont().getStringBounds(symbol, DEFAULT_FONT_RENDER_CONTEXT);
            stringWidth = (int)Math.ceil(charBounds.getWidth());
            stringHeight = (int)Math.ceil(charBounds.getHeight());
            fontScalingFactor = (int)Math.ceil((double)stringWidth / (double)this.cellWidth);
            g.setFont(new Font("Monotype", 1, this.fontSize / fontScalingFactor));
            charBounds = g.getFont().getStringBounds(symbol, DEFAULT_FONT_RENDER_CONTEXT);
            stringWidth = (int)Math.ceil(charBounds.getWidth());
            stringHeight = (int)Math.ceil(charBounds.getHeight());
            if (i == this.tape.getCurrentPosition()) {
                g.setColor(this.currentTextColor);
            }
            g.drawString(symbol, (int)((this.newLeftCellWidth + (double)drawPos + 0.5 + this.offset) * (double)this.cellWidth - (double)(stringWidth / 2)), yAlign + stringHeight / 4);
            g.setFont(new Font("Monotype", 0, this.fontSize / (2 * fontScalingFactor)));
            g.setColor(this.CELL_INDEX_COLOR);
            g.drawString(Integer.toString(i - this.origin), (int)((this.newLeftCellWidth + (double)drawPos + 0.3 + this.offset) * (double)this.cellWidth - (double)(stringWidth / 2)), (int)((double)yAlign + 0.45 * (double)this.cellHeight));
            ++index;
            ++i;
            ++drawPos;
        }
        g.setColor(this.DEFAULT_CELL_COLOR);
        g.fillRect((int)((this.newLeftCellWidth + (double)drawPos + this.offset) * (double)this.cellWidth), yAlign - this.cellHeight / 2, (int)(this.newRightCellWidth * (double)this.cellWidth), this.cellHeight);
        g.setColor(Color.black);
        if (this.newRightCell) {
            charBounds = g.getFont().getStringBounds(Tape.getFillSymbol(), DEFAULT_FONT_RENDER_CONTEXT);
            stringWidth = (int)Math.ceil(charBounds.getWidth());
            stringHeight = (int)Math.ceil(charBounds.getHeight());
            fontScalingFactor = (int)Math.ceil((double)stringWidth / (double)this.cellWidth);
            g.setFont(new Font("Monotype", 1, this.fontSize / fontScalingFactor));
            charBounds = g.getFont().getStringBounds(Tape.getFillSymbol(), DEFAULT_FONT_RENDER_CONTEXT);
            stringWidth = (int)Math.ceil(charBounds.getWidth());
            stringHeight = (int)Math.ceil(charBounds.getHeight());
            g.drawString(Tape.getFillSymbol(), (int)((this.newLeftCellWidth + (double)i + 0.5 + 0.0) * (double)this.cellWidth - (double)(stringWidth / 2)), yAlign + stringHeight / 4);
            g.setFont(new Font("Monotype", 0, this.fontSize / (2 * fontScalingFactor)));
            g.setColor(this.CELL_INDEX_COLOR);
            g.drawString(Integer.toString(index), (int)((this.newLeftCellWidth + (double)i + 0.3 + 0.0) * (double)this.cellWidth - (double)(stringWidth / 2)), (int)((double)yAlign + 0.45 * (double)this.cellHeight));
        }
    }
}

