/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class TuringMain
extends JFrame {
    static final int MIN_SPEED = 0;
    static final int MAX_SPEED = 100;
    static final int INIT_SPEED = 50;
    static Box mainBox = new Box(1);
    static TuringTapeArea tapeArea = new TuringTapeArea();
    static TuringMachineArea machineArea = new TuringMachineArea();
    static JComboBox tapeSelector;
    static JLabel tapeLabel;
    static JPanel inputPanel;
    static JMenuBar menuBar;
    static JMenu fileMenu;
    static JMenuItem openItem;
    static JMenuItem quitItem;
    static JMenu controlMenu;
    static JMenuItem runItem;
    static JMenuItem backItem;
    static JMenuItem forwItem;
    static JMenuItem resetItem;
    static JMenuItem jumpItem;
    static JMenu animationMenu;
    static ButtonGroup tapeGroup;
    static JRadioButtonMenuItem animOn;
    static JRadioButtonMenuItem animOff;
    static JToolBar controlBar;
    static JButton runButton;
    static JButton backButton;
    static JButton stepButton;
    static JButton resetButton;
    static ImageIcon runIcon;
    static ImageIcon pauseIcon;
    static ImageIcon backIcon;
    static ImageIcon stepIcon;
    static ImageIcon resetIcon;
    static JLabel speedLabel;
    static JSlider speedSlider;
    public static JTextArea statusBar;
    public static Timer stepTimer;
    public static Timer animationTimer;
    static TuringIOProcessor iop;
    static JFileChooser machineChooser;
    static JumpDialog jumpDialog;
    static File filename;
    static Machine machine;
    static Tape tape;
    static Tape originalTape;
    static Vector<JarEntry> machineVector;
    static Vector tapeVector;
    public static int delay;
    static boolean frozen;
    static int halted;
    static boolean componentsLoaded;
    public static boolean animationOn;
    public static boolean animationInitialized;
    static final int FADE_IN = 0;
    static final int FADE_OUT = 1;
    static final int GROW_TAPE_LEFT = 2;
    static final int GROW_TAPE_RIGHT = 3;
    static int fade;
    static int oldTapeLength;
    static String statusString;
    static JarFile jf;

    public TuringMain(String s) {
        super(s);
        this.setForeground(new Color(200, 200, 200));
        this.setBackground(new Color(200, 200, 200));
    }

    public void runProgram() {
        this.setSize(new Dimension(900, 700));
        if (!componentsLoaded) {
            try {
                jf = this.getJarFile();
                System.out.println("jf = " + jf);
                machineVector = TuringMain.getMachines();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            machineChooser = new JFileChooser();
            machineChooser.addChoosableFileFilter(new TuringFilter());
            machineChooser.setAccessory(new TuringDescription(machineChooser));
            machineChooser.setFileView(new TuringFileView());
            machineChooser.setMultiSelectionEnabled(false);
            machineChooser.setDialogTitle("Load Machine");
            machineChooser.setPreferredSize(new Dimension((int)((double)this.getWidth() * 0.9), 500));
            tapeSelector = new JComboBox();
            tapeSelector.addActionListener(new TapeSelectorListener());
            tapeSelector.setEnabled(false);
            jumpDialog = new JumpDialog((Frame)this, "Jump To Step...");
            jumpDialog.addWindowListener(new JumpWindowListener());
            this.setJMenuBar(menuBar);
            menuBar.add(fileMenu);
            fileMenu.add(openItem);
            fileMenu.add(quitItem);
            openItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            openItem.addActionListener(new GetMachinesMenuItemListener());
            quitItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            quitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    stepTimer.stop();
                    TuringMain.this.dispose();
                }
            });
            menuBar.add(controlMenu);
            controlMenu.add(runItem);
            controlMenu.add(backItem);
            controlMenu.add(forwItem);
            controlMenu.add(resetItem);
            controlMenu.add(jumpItem);
            runItem.setAccelerator(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            runItem.addActionListener(new RunButtonListener());
            backItem.setAccelerator(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            backItem.addActionListener(new BackButtonListener());
            forwItem.setAccelerator(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            forwItem.addActionListener(new StepButtonListener());
            resetItem.setAccelerator(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            resetItem.addActionListener(new ResetButtonListener());
            jumpItem.setAccelerator(KeyStroke.getKeyStroke(74, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jumpItem.addActionListener(new JumpItemListener());
            menuBar.add(animationMenu);
            tapeGroup.add(animOn);
            tapeGroup.add(animOff);
            animationMenu.add(animOn);
            animationMenu.add(animOff);
            animOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    animationOn = true;
                }
            });
            animOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    animationOn = false;
                }
            });
            animOn.setSelected(true);
            runIcon = new ImageIcon(this.getClass().getResource("Play24.gif"));
            pauseIcon = new ImageIcon(this.getClass().getResource("Pause24.gif"));
            backIcon = new ImageIcon(this.getClass().getResource("StepBack24.gif"));
            stepIcon = new ImageIcon(this.getClass().getResource("StepForward24.gif"));
            resetIcon = new ImageIcon(this.getClass().getResource("Stop24.gif"));
            runButton = new JButton(runIcon);
            runButton.addActionListener(new RunButtonListener());
            runButton.setToolTipText("Run Machine");
            backButton = new JButton(backIcon);
            backButton.addActionListener(new BackButtonListener());
            backButton.setToolTipText("Step Back");
            stepButton = new JButton(stepIcon);
            stepButton.addActionListener(new StepButtonListener());
            stepButton.setToolTipText("Step Forward");
            resetButton = new JButton(resetIcon);
            resetButton.addActionListener(new ResetButtonListener());
            resetButton.setToolTipText("Reset Machine");
            speedSlider.addChangeListener(new SpeedSliderListener());
            speedSlider.setMajorTickSpacing(20);
            speedSlider.setMinorTickSpacing(5);
            speedSlider.setPaintTicks(true);
            speedSlider.setPaintLabels(true);
            speedSlider.setToolTipText("Adjust Running Speed");
            speedSlider.setPreferredSize(new Dimension(500, 30));
            tapeSelector.setEditable(true);
            tapeSelector.setToolTipText("Select an input tape, or enter your own");
            inputPanel.setLayout(new BorderLayout());
            inputPanel.add((Component)tapeLabel, "West");
            inputPanel.add((Component)tapeSelector, "South");
            delay = (int)(Math.exp(10.0) / Math.exp((double)speedSlider.getValue() / 10.0) / 3.0);
            stepTimer = new Timer(delay, new StepTimerListener());
            stepTimer.setInitialDelay(delay);
            animationTimer = new Timer(30, new AnimationTimerListener());
            animationTimer.setInitialDelay(30);
            tapeArea.setPreferredSize(new Dimension(this.getWidth(), 50));
            machineArea.setPreferredSize(new Dimension(this.getWidth(), 700));
            machineArea.setOpaque(false);
            speedSlider.setMaximumSize(new Dimension(300, 50));
            speedSlider.setPreferredSize(new Dimension(300, 50));
            speedSlider.setForeground(new Color(200, 200, 200));
            speedSlider.setBackground(new Color(200, 200, 200));
            inputPanel.setMaximumSize(new Dimension(300, 50));
            inputPanel.setPreferredSize(new Dimension(300, 50));
            inputPanel.setForeground(new Color(200, 200, 200));
            inputPanel.setBackground(new Color(200, 200, 200));
            controlBar.setFloatable(false);
            controlBar.add(runButton);
            controlBar.add(backButton);
            controlBar.add(stepButton);
            controlBar.add(resetButton);
            controlBar.add(speedLabel);
            controlBar.add(speedSlider);
            controlBar.add(Box.createRigidArea(new Dimension(10, 50)));
            controlBar.add(inputPanel);
            controlBar.setPreferredSize(new Dimension(500, 50));
            controlBar.setForeground(new Color(200, 200, 200));
            controlBar.setBackground(new Color(200, 200, 200));
            statusBar.setEditable(false);
            statusBar.setBackground(new Color(200, 200, 200));
            JPanel statusAndControl = new JPanel();
            statusAndControl.setLayout(new BorderLayout());
            statusAndControl.setBorder(new EmptyBorder(5, 5, 5, 5));
            statusAndControl.add((Component)statusBar, "North");
            statusAndControl.add((Component)controlBar, "Center");
            statusAndControl.setMaximumSize(new Dimension(1000, 50));
            statusAndControl.setForeground(new Color(200, 200, 200));
            statusAndControl.setBackground(new Color(200, 200, 200));
            mainBox.add(machineArea);
            mainBox.add(tapeArea);
            mainBox.add(statusAndControl);
            this.getContentPane().add(mainBox);
            this.setVisible(true);
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown() {
                    TuringMain.this.repaint();
                }

                public void componentResized() {
                    TuringMain.this.repaint();
                }
            });
        }
    }

    public static void repaintMachineArea() {
        machineArea.repaint();
    }

    public static void repaintTapeArea() {
        tapeArea.repaint();
    }

    static void printStatus() {
        if (machine != null) {
            statusBar.setText("Status: " + statusString);
            for (int i = 0; i < 13 - statusString.length(); ++i) {
                statusBar.append(" ");
            }
            if (machine != null) {
                statusBar.append("Steps: " + Integer.toString(TuringMain.machine.steps));
            }
        }
    }

    static Vector<JarEntry> getMachines() throws MalformedURLException, IOException {
        Vector<JarEntry> v = new Vector<JarEntry>();
        Enumeration<JarEntry> enumeration = jf.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry je = enumeration.nextElement();
            if (!je.getName().endsWith(".tur")) continue;
            v.add(je);
        }
        return v;
    }

    JarFile getJarFile() throws IOException {
        System.out.println("getClass() = " + this.getClass());
        URL url = this.getClass().getResource("turing.jpg");
        System.out.println("URL of turing.jpg = " + url);
        JarURLConnection juc = (JarURLConnection)url.openConnection();
        System.out.println("JarURLConnection = " + juc);
        System.out.println("jar file = " + juc.getJarFile());
        JarFile jf = juc.getJarFile();
        if (jf == null) {
            try {
                jf = TuringMain.getJarFileByReflection(juc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jf;
    }

    private static JarFile getJarFileByReflection(JarURLConnection jarUrlConnection) throws Exception {
        Field jarFileField;
        Class<?> jnlpConnectionClass = Class.forName("com.sun.jnlp.JNLPCachedJarURLConnection");
        try {
            jarFileField = jnlpConnectionClass.getDeclaredField("jarFile");
        }
        catch (Throwable t) {
            jarFileField = jnlpConnectionClass.getDeclaredField("_jarFile");
        }
        jarUrlConnection.connect();
        jarFileField.setAccessible(true);
        return (JarFile)jarFileField.get(jarUrlConnection);
    }

    File getFilesDirectory() {
        File f = new File(jf.getName());
        String s = f.getParent();
        f = new File(s = s + File.separator + "tur");
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        if (f.isDirectory()) {
            for (int i = 0; i < machineVector.size(); ++i) {
                if (!machineVector.get(i).toString().endsWith(".tur")) continue;
                try {
                    File newFile = new File(f + File.separator + machineVector.get(i).getName());
                    JarEntry je = machineVector.get(i);
                    if (filename == null) {
                        filename = newFile;
                    }
                    if (newFile.lastModified() >= je.getTime()) continue;
                    newFile.createNewFile();
                    iop.copyFile(this.getClass().getResource(je.getName()), newFile);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            return null;
        }
        return f;
    }

    static void setPaused() {
        runButton.setIcon(runIcon);
        runButton.setToolTipText("Run Machine");
        frozen = true;
        stepTimer.stop();
        TuringMain.tapeArea.machineIsRunning = false;
        halted = 0;
        statusString = "Paused";
        TuringMain.printStatus();
    }

    static void setHalted() {
        runButton.setIcon(runIcon);
        runButton.setToolTipText("Run Machine");
        frozen = true;
        stepTimer.stop();
    }

    static void setReady() {
        runButton.setIcon(runIcon);
        runButton.setToolTipText("Run Machine");
        frozen = true;
        stepTimer.stop();
        halted = 0;
        statusString = "Ready";
        TuringMain.printStatus();
    }

    static void setRunning() {
        runButton.setIcon(pauseIcon);
        runButton.setToolTipText("Pause Machine");
        frozen = false;
        halted = 0;
        statusString = "Running";
        stepTimer.start();
    }

    void doStep(int n) {
        if (machine != null && halted == 0 && !animationTimer.isRunning()) {
            animationInitialized = false;
            if (animationOn) {
                animationTimer.start();
            } else {
                for (int i = 0; i < n; ++i) {
                    machine.stepForward();
                    halted = machine.shiftAndGetHaltStatus();
                    machine.updateMachine();
                    if (halted == 0) continue;
                    TuringMain.setHalted();
                    switch (halted) {
                        case 2: {
                            statusString = "Accepted";
                            break;
                        }
                        case 3: {
                            statusString = "Rejected";
                            break;
                        }
                        default: {
                            statusString = "Halted";
                            break;
                        }
                    }
                    break;
                }
                tapeArea.repaint();
                machineArea.repaint();
                TuringMain.printStatus();
            }
        }
    }

    static {
        tapeLabel = new JLabel("Input:  ");
        inputPanel = new JPanel();
        menuBar = new JMenuBar();
        fileMenu = new JMenu("File");
        openItem = new JMenuItem("Load Machine...   ");
        quitItem = new JMenuItem("Quit");
        controlMenu = new JMenu("Controls");
        runItem = new JMenuItem("Run/Pause");
        backItem = new JMenuItem("Step Back");
        forwItem = new JMenuItem("Step Forward");
        resetItem = new JMenuItem("Reset");
        jumpItem = new JMenuItem("Jump To Step...   ");
        animationMenu = new JMenu("Animation");
        tapeGroup = new ButtonGroup();
        animOn = new JRadioButtonMenuItem("Animation On");
        animOff = new JRadioButtonMenuItem("Animation Off");
        controlBar = new JToolBar(0);
        speedLabel = new JLabel("  Speed:");
        speedSlider = new JSlider(0, 0, 100, 50);
        statusBar = new JTextArea();
        iop = new TuringIOProcessor();
        originalTape = new Tape("");
        frozen = true;
        halted = 0;
        componentsLoaded = false;
        animationOn = true;
        animationInitialized = false;
        fade = 1;
        statusString = "Ready";
    }

    class JumpWindowListener
    extends WindowAdapter {
        JumpWindowListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (jumpDialog.isValid()) {
                stepTimer.stop();
                animationTimer.stop();
                tapeArea.resetColors();
                tapeArea.removePartialCells();
                machineArea.resetColors();
                tape = new Tape(originalTape);
                tapeArea.setTape(tape);
                TuringMain.tapeArea.tapeInit = false;
                machine.setTape(tape);
                machine.resetMachine();
                int j = jumpDialog.getJump();
                boolean a = animationOn;
                animationOn = false;
                if (j == -1) {
                    j = 200000;
                }
                TuringMain.this.doStep(j);
                animationOn = a;
            }
        }
    }

    class TuringDescription
    extends JPanel
    implements PropertyChangeListener {
        JLabel label = new JLabel("  Description:");
        JTextArea jta;
        JScrollPane jsp;

        public TuringDescription(JFileChooser fc) {
            this.setPreferredSize(new Dimension(300, 200));
            this.setLayout(new BorderLayout());
            this.jta = new JTextArea();
            this.jsp = new JScrollPane(this.jta);
            fc.addPropertyChangeListener(this);
            this.jta.setLineWrap(true);
            this.jta.setWrapStyleWord(true);
            this.jta.setBackground(fc.getBackground());
            this.add((Component)this.label, "North");
            this.add(Box.createRigidArea(new Dimension(10, 10)), "West");
            this.add((Component)this.jsp, "Center");
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            File f;
            TuringIOProcessor iop = new TuringIOProcessor();
            if (e.getPropertyName().equals("SelectedFileChangedProperty") && (f = (File)e.getNewValue()) != null) {
                this.jta.setText(iop.getMachineDescription(f));
                this.jta.moveCaretPosition(0);
            }
        }
    }

    class TuringFilter
    extends FileFilter {
        TuringFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".tur");
        }

        @Override
        public String getDescription() {
            return "TUR files";
        }
    }

    public class TuringFileView
    extends FileView {
        @Override
        public String getTypeDescription(File f) {
            return null;
        }

        @Override
        public Icon getIcon(File f) {
            return null;
        }

        @Override
        public String getName(File f) {
            try {
                if (f.getName().endsWith(".tur")) {
                    TuringIOProcessor iop = new TuringIOProcessor();
                    return iop.getMachineName(f);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public String getDescription(File f) {
            return null;
        }

        @Override
        public Boolean isTraversable(File f) {
            return null;
        }
    }

    class AnimationTimerListener
    implements ActionListener {
        int tapeRedGoal;
        int tapeGreenGoal;
        int tapeBlueGoal;
        int machineRedGoal;
        int machineGreenGoal;
        int machineBlueGoal;
        int edgeRedGoal;
        int edgeGreenGoal;
        int edgeBlueGoal;
        int tapeRedInc;
        int tapeGreenInc;
        int tapeBlueInc;
        int machineRedInc;
        int machineGreenInc;
        int machineBlueInc;
        int edgeRedInc;
        int edgeGreenInc;
        int edgeBlueInc;
        double growInc;
        Color newTapeColor;
        Color newMachineColor;
        Color newEdgeColor;

        AnimationTimerListener() {
        }

        public void animationInit() {
            double colorInc;
            this.growInc = 5.0 / (double)stepTimer.getDelay();
            if (this.growInc < 0.03) {
                this.growInc = 0.03;
            }
            if ((colorInc = !machine.getNextEdge().getOldSymbol().equals(machine.getNextEdge().getNewSymbol()) || !machine.getNextEdge().getOldState().equals(machine.getNextEdge().getNewState()) ? 15.0 / (double)delay : 60.0 / (double)delay) < 0.1) {
                colorInc = 0.1;
            }
            if (fade == 1) {
                this.tapeRedGoal = TuringMain.tapeArea.CURRENT_CELL_COLOR.getRed();
                this.tapeGreenGoal = TuringMain.tapeArea.CURRENT_CELL_COLOR.getGreen();
                this.tapeBlueGoal = TuringMain.tapeArea.CURRENT_CELL_COLOR.getBlue();
                this.machineRedGoal = TuringMain.machineArea.DEFAULT_VERTEX_COLOR.getRed();
                this.machineGreenGoal = TuringMain.machineArea.DEFAULT_VERTEX_COLOR.getGreen();
                this.machineBlueGoal = TuringMain.machineArea.DEFAULT_VERTEX_COLOR.getBlue();
                this.edgeRedGoal = TuringMachineArea.ACTIVE_EDGE_COLOR.getRed();
                this.edgeGreenGoal = TuringMachineArea.ACTIVE_EDGE_COLOR.getGreen();
                this.edgeBlueGoal = TuringMachineArea.ACTIVE_EDGE_COLOR.getBlue();
                this.tapeRedInc = (int)((double)(this.tapeRedGoal - TuringMain.tapeArea.DEFAULT_TEXT_COLOR.getRed()) * colorInc);
                this.tapeGreenInc = (int)((double)(this.tapeGreenGoal - TuringMain.tapeArea.DEFAULT_TEXT_COLOR.getGreen()) * colorInc);
                this.tapeBlueInc = (int)((double)(this.tapeBlueGoal - TuringMain.tapeArea.DEFAULT_TEXT_COLOR.getBlue()) * colorInc);
                this.machineRedInc = (int)((double)(this.machineRedGoal - TuringMain.machineArea.CURRENT_VERTEX_COLOR.getRed()) * colorInc);
                this.machineGreenInc = (int)((double)(this.machineGreenGoal - TuringMain.machineArea.CURRENT_VERTEX_COLOR.getGreen()) * colorInc);
                this.machineBlueInc = (int)((double)(this.machineBlueGoal - TuringMain.machineArea.CURRENT_VERTEX_COLOR.getBlue()) * colorInc);
                this.edgeRedInc = (int)((double)(this.edgeRedGoal - TuringMain.machineArea.BG_COLOR.getRed()) * colorInc);
                this.edgeGreenInc = (int)((double)(this.edgeGreenGoal - TuringMain.machineArea.BG_COLOR.getGreen()) * colorInc);
                this.edgeBlueInc = (int)((double)(this.edgeBlueGoal - TuringMain.machineArea.BG_COLOR.getBlue()) * colorInc);
                this.newTapeColor = TuringMain.tapeArea.DEFAULT_TEXT_COLOR;
                this.newMachineColor = TuringMain.machineArea.CURRENT_VERTEX_COLOR;
                this.newEdgeColor = TuringMain.machineArea.BG_COLOR;
                animationInitialized = true;
            } else if (fade == 0) {
                this.tapeRedGoal = TuringMain.tapeArea.DEFAULT_TEXT_COLOR.getRed();
                this.tapeGreenGoal = TuringMain.tapeArea.DEFAULT_TEXT_COLOR.getGreen();
                this.tapeBlueGoal = TuringMain.tapeArea.DEFAULT_TEXT_COLOR.getBlue();
                this.machineRedGoal = TuringMain.machineArea.CURRENT_VERTEX_COLOR.getRed();
                this.machineGreenGoal = TuringMain.machineArea.CURRENT_VERTEX_COLOR.getGreen();
                this.machineBlueGoal = TuringMain.machineArea.CURRENT_VERTEX_COLOR.getBlue();
                this.edgeRedGoal = TuringMain.machineArea.BG_COLOR.getRed();
                this.edgeGreenGoal = TuringMain.machineArea.BG_COLOR.getGreen();
                this.edgeBlueGoal = TuringMain.machineArea.BG_COLOR.getBlue();
                this.tapeRedInc = -((int)((double)(this.tapeRedGoal - TuringMain.tapeArea.CURRENT_CELL_COLOR.getRed()) * colorInc));
                this.tapeGreenInc = -((int)((double)(this.tapeGreenGoal - TuringMain.tapeArea.CURRENT_CELL_COLOR.getGreen()) * colorInc));
                this.tapeBlueInc = -((int)((double)(this.tapeBlueGoal - TuringMain.tapeArea.CURRENT_CELL_COLOR.getBlue()) * colorInc));
                this.machineRedInc = -((int)((double)(this.machineRedGoal - TuringMain.machineArea.DEFAULT_VERTEX_COLOR.getRed()) * colorInc));
                this.machineGreenInc = -((int)((double)(this.machineGreenGoal - TuringMain.machineArea.DEFAULT_VERTEX_COLOR.getGreen()) * colorInc));
                this.machineBlueInc = -((int)((double)(this.machineBlueGoal - TuringMain.machineArea.DEFAULT_VERTEX_COLOR.getBlue()) * colorInc));
                this.edgeRedInc = -((int)((double)(this.edgeRedGoal - TuringMachineArea.ACTIVE_EDGE_COLOR.getRed()) * colorInc));
                this.edgeGreenInc = -((int)((double)(this.edgeGreenGoal - TuringMachineArea.ACTIVE_EDGE_COLOR.getGreen()) * colorInc));
                this.edgeBlueInc = -((int)((double)(this.edgeBlueGoal - TuringMachineArea.ACTIVE_EDGE_COLOR.getBlue()) * colorInc));
                this.newTapeColor = TuringMain.tapeArea.CURRENT_CELL_COLOR;
                this.newMachineColor = TuringMain.machineArea.DEFAULT_VERTEX_COLOR;
                this.newEdgeColor = TuringMachineArea.ACTIVE_EDGE_COLOR;
                animationInitialized = true;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!animationInitialized) {
                this.animationInit();
            }
            if (fade == 2) {
                TuringMain.tapeArea.offset += this.growInc;
                if (TuringMain.tapeArea.offset > TuringMain.tapeArea.INITIAL_OFFSET + 1.0) {
                    this.finishAddLeft();
                }
            } else if (fade == 3) {
                TuringMain.tapeArea.offset -= this.growInc;
                if (TuringMain.tapeArea.offset < TuringMain.tapeArea.INITIAL_OFFSET - 1.0) {
                    this.finishAddRight();
                }
            } else if (fade == 1) {
                if (0 > this.tapeRedGoal - this.newTapeColor.getRed() ^ 0 > this.tapeRedGoal - (this.newTapeColor.getRed() + this.tapeRedInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.tapeGreenGoal - this.newTapeColor.getGreen() ^ 0 > this.tapeGreenGoal - (this.newTapeColor.getGreen() + this.tapeGreenInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.tapeBlueGoal - this.newTapeColor.getBlue() ^ 0 > this.tapeBlueGoal - (this.newTapeColor.getBlue() + this.tapeBlueInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.machineRedGoal - this.newMachineColor.getRed() ^ 0 > this.machineRedGoal - (this.newMachineColor.getRed() + this.machineRedInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.machineGreenGoal - this.newMachineColor.getGreen() ^ 0 > this.machineGreenGoal - (this.newMachineColor.getGreen() + this.machineGreenInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.machineBlueGoal - this.newMachineColor.getBlue() ^ 0 > this.machineBlueGoal - (this.newMachineColor.getBlue() + this.machineBlueInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.edgeRedGoal - this.newEdgeColor.getRed() ^ 0 > this.edgeRedGoal - (this.newEdgeColor.getRed() + this.edgeRedInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.edgeGreenGoal - this.newEdgeColor.getGreen() ^ 0 > this.edgeGreenGoal - (this.newEdgeColor.getGreen() + this.edgeGreenInc)) {
                    this.finishFadeOut();
                    return;
                }
                if (0 > this.edgeBlueGoal - this.newEdgeColor.getBlue() ^ 0 > this.edgeBlueGoal - (this.newEdgeColor.getBlue() + this.edgeBlueInc)) {
                    this.finishFadeOut();
                    return;
                }
                this.newTapeColor = new Color(this.newTapeColor.getRed() + this.tapeRedInc, this.newTapeColor.getGreen() + this.tapeGreenInc, this.newTapeColor.getBlue() + this.tapeBlueInc);
                this.newMachineColor = new Color(this.newMachineColor.getRed() + this.machineRedInc, this.newMachineColor.getGreen() + this.machineGreenInc, this.newMachineColor.getBlue() + this.machineBlueInc);
                this.newEdgeColor = new Color(this.newEdgeColor.getRed() + this.edgeRedInc, this.newEdgeColor.getGreen() + this.edgeGreenInc, this.newEdgeColor.getBlue() + this.edgeBlueInc);
                if (!machine.getNextEdge().getOldSymbol().equals(machine.getNextEdge().getNewSymbol())) {
                    TuringMain.tapeArea.currentTextColor = this.newTapeColor;
                }
                if (!machine.getNextEdge().getOldState().equals(machine.getNextEdge().getNewState())) {
                    TuringMain.machineArea.currentVertexColor = this.newMachineColor;
                }
                TuringMain.machineArea.nextEdgeColor = this.newEdgeColor;
            } else {
                if (0 > this.tapeRedGoal - this.newTapeColor.getRed() ^ 0 > this.tapeRedGoal - (this.newTapeColor.getRed() - this.tapeRedInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.tapeGreenGoal - this.newTapeColor.getGreen() ^ 0 > this.tapeGreenGoal - (this.newTapeColor.getGreen() - this.tapeGreenInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.tapeBlueGoal - this.newTapeColor.getBlue() ^ 0 > this.tapeBlueGoal - (this.newTapeColor.getBlue() - this.tapeBlueInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.machineRedGoal - this.newMachineColor.getRed() ^ 0 > this.machineRedGoal - (this.newMachineColor.getRed() - this.machineRedInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.machineGreenGoal - this.newMachineColor.getGreen() ^ 0 > this.machineGreenGoal - (this.newMachineColor.getGreen() - this.machineGreenInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.machineBlueGoal - this.newMachineColor.getBlue() ^ 0 > this.machineBlueGoal - (this.newMachineColor.getBlue() - this.machineBlueInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.edgeRedGoal - this.newEdgeColor.getRed() ^ 0 > this.edgeRedGoal - (this.newEdgeColor.getRed() - this.edgeRedInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.edgeGreenGoal - this.newEdgeColor.getGreen() ^ 0 > this.edgeGreenGoal - (this.newEdgeColor.getGreen() - this.edgeGreenInc)) {
                    this.finishFadeIn();
                    return;
                }
                if (0 > this.edgeBlueGoal - this.newEdgeColor.getBlue() ^ 0 > this.edgeBlueGoal - (this.newEdgeColor.getBlue() - this.edgeBlueInc)) {
                    this.finishFadeIn();
                    return;
                }
                this.newTapeColor = new Color(this.newTapeColor.getRed() - this.tapeRedInc, this.newTapeColor.getGreen() - this.tapeGreenInc, this.newTapeColor.getBlue() - this.tapeBlueInc);
                this.newMachineColor = new Color(this.newMachineColor.getRed() - this.machineRedInc, this.newMachineColor.getGreen() - this.machineGreenInc, this.newMachineColor.getBlue() - this.machineBlueInc);
                this.newEdgeColor = new Color(this.newEdgeColor.getRed() - this.edgeRedInc, this.newEdgeColor.getGreen() - this.edgeGreenInc, this.newEdgeColor.getBlue() - this.edgeBlueInc);
                if (!machine.getNextEdge().getOldSymbol().equals(machine.getNextEdge().getNewSymbol())) {
                    TuringMain.tapeArea.currentTextColor = this.newTapeColor;
                }
                if (!machine.getNextEdge().getOldState().equals(machine.getNextEdge().getNewState())) {
                    TuringMain.machineArea.currentVertexColor = this.newMachineColor;
                }
                TuringMain.machineArea.nextEdgeColor = this.newEdgeColor;
            }
            tapeArea.repaint();
            machineArea.repaint();
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        void finishAddLeft() {
            TuringMain.tapeArea.offset = TuringMain.tapeArea.INITIAL_OFFSET;
            TuringMain.tapeArea.newLeftCell = false;
            tapeArea.repaint();
            TuringMain.tapeArea.newLeftCellWidth = 0.0;
            machine.updateMachine();
            animationTimer.stop();
            fade = 1;
            TuringMain.tapeArea.grow = true;
        }

        void finishAddRight() {
            TuringMain.tapeArea.offset = TuringMain.tapeArea.INITIAL_OFFSET;
            TuringMain.tapeArea.newRightCell = false;
            tapeArea.repaint();
            TuringMain.tapeArea.newRightCellWidth = 0.0;
            machine.updateMachine();
            animationTimer.stop();
            fade = 1;
            TuringMain.tapeArea.grow = true;
        }

        void finishFadeOut() {
            if (!machine.getNextEdge().getOldSymbol().equals(machine.getNextEdge().getNewSymbol())) {
                TuringMain.tapeArea.currentTextColor = TuringMain.tapeArea.CURRENT_CELL_COLOR;
            }
            if (!machine.getNextEdge().getOldState().equals(machine.getNextEdge().getNewState())) {
                TuringMain.machineArea.currentVertexColor = TuringMain.machineArea.DEFAULT_VERTEX_COLOR;
            }
            TuringMain.machineArea.nextEdgeColor = TuringMachineArea.ACTIVE_EDGE_COLOR;
            tapeArea.repaint();
            machineArea.repaint();
            animationTimer.stop();
            fade = 0;
            animationInitialized = false;
            machine.stepForward();
            if (animationOn) {
                animationTimer.start();
            }
        }

        void finishFadeIn() {
            TuringMain.machineArea.nextEdgeColor = this.newEdgeColor;
            TuringMain.tapeArea.currentTextColor = TuringMain.tapeArea.DEFAULT_TEXT_COLOR;
            TuringMain.machineArea.currentVertexColor = TuringMain.machineArea.CURRENT_VERTEX_COLOR;
            TuringMain.machineArea.nextEdgeColor = TuringMain.machineArea.BG_COLOR;
            animationInitialized = false;
            fade = 1;
            halted = machine.shiftAndGetHaltStatus();
            machine.updateMachine();
            if (halted != 0) {
                TuringMain.setHalted();
                switch (halted) {
                    case 2: {
                        statusString = "Accepted";
                        break;
                    }
                    case 3: {
                        statusString = "Rejected";
                        break;
                    }
                    default: {
                        statusString = "Halted";
                    }
                }
            }
            if (tape.getCurrentPosition() - 3 < TuringMain.tapeArea.leftMostCell) {
                fade = 2;
            } else if (tape.getCurrentPosition() + 3 > TuringMain.tapeArea.rightMostCell) {
                fade = 3;
            } else {
                animationTimer.stop();
            }
            oldTapeLength = tape.getSize();
            tapeArea.repaint();
            machineArea.repaint();
            TuringMain.printStatus();
        }
    }

    class SpeedSliderListener
    implements ChangeListener {
        SpeedSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int fps = speedSlider.getValue();
            if (fps == 0) {
                stepTimer.stop();
            } else {
                delay = (int)(Math.exp(10.0) / Math.exp((double)speedSlider.getValue() / 10.0) / 3.0);
                stepTimer.setInitialDelay(delay);
                stepTimer.setDelay(delay);
                if (!frozen) {
                    stepTimer.start();
                }
            }
        }
    }

    class JumpItemListener
    implements ActionListener {
        JumpItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TuringMain.setPaused();
            jumpDialog.setVisible(true);
        }
    }

    class ResetButtonListener
    implements ActionListener {
        ResetButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            stepTimer.stop();
            animationTimer.stop();
            tapeArea.resetColors();
            tapeArea.removePartialCells();
            TuringMain.tapeArea.tapeInit = false;
            machineArea.resetColors();
            tape = new Tape(originalTape);
            oldTapeLength = tape.getSize();
            fade = 1;
            tapeArea.setTape(tape);
            machine.setTape(tape);
            machine.resetMachine();
            TuringMain.setReady();
            tapeArea.repaint();
        }
    }

    class StepTimerListener
    implements ActionListener {
        StepTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TuringMain.this.doStep(1);
        }
    }

    class StepButtonListener
    implements ActionListener {
        StepButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (halted == 0) {
                TuringMain.setPaused();
            }
            if (!animationTimer.isRunning()) {
                TuringMain.this.doStep(1);
            }
        }
    }

    class BackButtonListener
    implements ActionListener {
        BackButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (machine != null && !animationTimer.isRunning() && machine.stepBack()) {
                oldTapeLength = tape.getSize();
                TuringMain.setPaused();
                TuringMain.repaintTapeArea();
                TuringMain.repaintMachineArea();
            }
        }
    }

    class RunButtonListener
    implements ActionListener {
        RunButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (machine != null) {
                if (halted != 0) {
                    resetButton.doClick();
                }
                if (frozen) {
                    TuringMain.setRunning();
                } else {
                    TuringMain.setPaused();
                }
            }
        }
    }

    class TapeSelectorListener
    implements ActionListener {
        TapeSelectorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean match = false;
            String newString = (String)tapeSelector.getSelectedItem();
            if (newString == null) {
                tapeSelector.setSelectedIndex(0);
                newString = (String)tapeSelector.getItemAt(0);
            }
            DefaultComboBoxModel model = (DefaultComboBoxModel)tapeSelector.getModel();
            if (!newString.equals(originalTape)) {
                originalTape = new Tape(newString);
                tape = new Tape(originalTape);
                machine.setTape(tape);
                tapeArea.setTape(tape);
                oldTapeLength = tape.getSize();
                tapeArea.repaint();
                machine.resetMachine();
                TuringMain.setReady();
                int len = tapeSelector.getItemCount();
                for (int i = 0; i < len; ++i) {
                    String s = (String)model.getElementAt(i);
                    if (!newString.equals(s)) continue;
                    match = true;
                }
                resetButton.doClick();
                if (!match) {
                    model.insertElementAt(newString, 0);
                }
            }
        }
    }

    class GetMachinesMenuItemListener
    implements ActionListener {
        GetMachinesMenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TuringMain.setPaused();
            File filesdir = TuringMain.this.getFilesDirectory();
            machineChooser.setFileFilter(new TuringFilter());
            machineChooser.setCurrentDirectory(filesdir);
            int accept = machineChooser.showOpenDialog(TuringMain.this);
            if (accept == 0) {
                filename = machineChooser.getSelectedFile();
                try {
                    machine = iop.getMachine(filename);
                    if (machine != null) {
                        tapeVector = iop.getTapes();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return;
                }
                if (machine != null) {
                    machineArea.setMachine(machine);
                    TuringMain.repaintMachineArea();
                    tapeSelector.setModel(new DefaultComboBoxModel(tapeVector));
                    tapeSelector.setSelectedIndex(0);
                    tapeSelector.setEnabled(true);
                    statusString = "Ready";
                    TuringMain.printStatus();
                    TuringMain.this.setTitle("Turing Machine:  " + filename.getName());
                    controlBar.requestFocus();
                }
            }
        }
    }
}

