/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JPanel;

public class TuringMachineArea
extends JPanel {
    boolean needToInitialize = true;
    static int vertexRadius;
    int fontSize;
    int areaWidth;
    int areaHeight;
    int arrowHeight;
    int currentEdgeWidth;
    int numVertices;
    int numEdges;
    Machine machine;
    static TuringEdge nextEdge;
    Vector<EdgeGraphicsData> edgeDataVector;
    final int MAX_VERTEX_RADIUS = 30;
    final int FONT_STYLE = 0;
    final String FONT_NAME = "Monotype";
    final Color BG_COLOR = new Color(200, 200, 200);
    public static final Color DEFAULT_EDGE_COLOR;
    public static final Color ACTIVE_EDGE_COLOR;
    public final Color DEFAULT_VERTEX_COLOR = Color.white;
    public final Color CURRENT_VERTEX_COLOR = ACTIVE_EDGE_COLOR;
    public final Color VERTEX_LABEL_COLOR = new Color(0, 130, 0);
    final Color VERTEX_BORDER_COLOR = Color.black;
    final Color ACCEPT_BORDER_COLOR = Color.black;
    final Color REJECT_BORDER_COLOR = Color.black;
    final Color DEFAULT_TEXT_COLOR = Color.black;
    final int ARROW_HEIGHT = 60;
    final double ARROW_ANGLE = Math.toRadians(30.0);
    final FontRenderContext DEFAULT_FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);
    public Color nextEdgeColor = this.BG_COLOR;
    public Color currentVertexColor = this.CURRENT_VERTEX_COLOR;

    public TuringMachineArea() {
        this.addComponentListener(new ResizeListener());
    }

    public void setMachine(Machine m) {
        this.machine = m;
        this.needToInitialize = true;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void resetColors() {
        this.nextEdgeColor = this.BG_COLOR;
        this.currentVertexColor = this.CURRENT_VERTEX_COLOR;
    }

    void initialize(Graphics g) {
        this.areaWidth = this.getWidth();
        this.areaHeight = this.getHeight();
        this.numVertices = this.machine.vertices.size();
        this.numEdges = this.machine.edges.size();
        vertexRadius = this.areaWidth > this.areaHeight ? (int)((double)this.areaHeight / Math.sqrt((double)this.numVertices * 60.0)) : (int)((double)this.areaWidth / Math.sqrt((double)this.numVertices * 60.0));
        if (vertexRadius > 30) {
            vertexRadius = 30;
        }
        this.fontSize = (int)((double)vertexRadius / 1.5);
        g.setFont(new Font("Monotype", 0, this.fontSize));
        this.arrowHeight = (int)((double)vertexRadius / 2.5);
        this.edgeDataVector = new Vector();
        for (int i = 0; i < this.numEdges; ++i) {
            TuringVertex v2;
            int[] arrowx = new int[3];
            int[] arrowy = new int[3];
            TuringEdge edge = this.machine.edges.get(i);
            TuringVertex v1 = this.findVertex(edge.getOldState());
            if (v1 == (v2 = this.findVertex(edge.getNewState()))) {
                if (edge.getOldSymbol().equals(edge.getNewSymbol())) continue;
                double startAngle = Math.toRadians(edge.getCurve());
                int xpos1 = (int)(v1.getXpos() * (double)this.areaWidth);
                int ypos1 = (int)(v1.getYpos() * (double)this.areaHeight);
                int cornerx = (int)((double)xpos1 + (double)vertexRadius * Math.cos(startAngle) - (double)vertexRadius);
                int cornery = (int)((double)ypos1 - (double)vertexRadius * Math.sin(startAngle) - (double)vertexRadius);
                arrowx[0] = (int)((double)xpos1 + (double)vertexRadius * Math.cos(startAngle - 1.0471975511965976));
                arrowy[0] = (int)((double)ypos1 - (double)vertexRadius * Math.sin(startAngle - 1.0471975511965976));
                arrowx[1] = (int)((double)arrowx[0] + (double)this.arrowHeight * Math.cos(startAngle - 0.5235987755982988 - this.ARROW_ANGLE));
                arrowx[2] = (int)((double)arrowx[0] + (double)this.arrowHeight * Math.cos(startAngle - 0.5235987755982988 + this.ARROW_ANGLE));
                arrowy[1] = (int)((double)arrowy[0] - (double)this.arrowHeight * Math.sin(startAngle - 0.5235987755982988 - this.ARROW_ANGLE));
                arrowy[2] = (int)((double)arrowy[0] - (double)this.arrowHeight * Math.sin(startAngle - 0.5235987755982988 + this.ARROW_ANGLE));
                String transitionString = edge.getOldSymbol() + " : " + edge.getNewSymbol();
                Rectangle2D charBounds = g.getFont().getStringBounds(transitionString, this.DEFAULT_FONT_RENDER_CONTEXT);
                int stringWidth = (int)Math.ceil(charBounds.getWidth());
                int stringHeight = (int)Math.ceil(charBounds.getHeight());
                int stringx = (int)((double)xpos1 + (double)vertexRadius * 2.0 * Math.cos(startAngle));
                int stringy = (int)((double)ypos1 - (double)vertexRadius * 2.0 * Math.sin(startAngle));
                this.edgeDataVector.add(new EdgeGraphicsData(cornerx, cornery, vertexRadius * 2, edge, new Arrowhead(arrowx, arrowy), new Transition(stringx -= (int)((double)stringWidth * 0.5), stringy += (int)((double)stringHeight * 0.25), stringWidth, stringHeight, transitionString)));
                continue;
            }
            int xpos1 = (int)(v1.getXpos() * (double)this.areaWidth);
            int ypos1 = (int)(v1.getYpos() * (double)this.areaHeight);
            int xpos2 = (int)(v2.getXpos() * (double)this.areaWidth);
            int ypos2 = (int)(v2.getYpos() * (double)this.areaHeight);
            double curve = edge.getCurve();
            int w = (int)(0.5 * Math.sqrt((xpos1 - xpos2) * (xpos1 - xpos2) + (ypos1 - ypos2) * (ypos1 - ypos2)));
            int h = (int)((double)w * curve);
            double theta = xpos2 == xpos1 ? (ypos2 > ypos1 ? -1.5707963267948966 : 1.5707963267948966) : -Math.atan((double)(ypos2 - ypos1) / (double)(xpos2 - xpos1));
            if (xpos1 > xpos2) {
                theta -= Math.PI;
            }
            if (h == 0) {
                arrowx[0] = (int)((double)xpos2 - (double)vertexRadius * Math.cos(theta));
                arrowy[0] = (int)((double)ypos2 + (double)vertexRadius * Math.sin(theta));
                arrowx[1] = (int)((double)arrowx[0] - (double)this.arrowHeight * Math.cos(theta - this.ARROW_ANGLE));
                arrowx[2] = (int)((double)arrowx[0] - (double)this.arrowHeight * Math.cos(theta + this.ARROW_ANGLE));
                arrowy[1] = (int)((double)arrowy[0] + (double)this.arrowHeight * Math.sin(theta - this.ARROW_ANGLE));
                arrowy[2] = (int)((double)arrowy[0] + (double)this.arrowHeight * Math.sin(theta + this.ARROW_ANGLE));
                String transitionString = edge.getOldSymbol() + " : " + edge.getNewSymbol();
                Rectangle2D charBounds = g.getFont().getStringBounds(transitionString, this.DEFAULT_FONT_RENDER_CONTEXT);
                int stringWidth = (int)Math.ceil(charBounds.getWidth());
                int stringHeight = (int)Math.ceil(charBounds.getHeight());
                int stringx = (int)((double)xpos1 + (double)w * Math.cos(theta));
                int stringy = (int)((double)ypos1 - (double)w * Math.sin(theta));
                this.edgeDataVector.add(new EdgeGraphicsData(xpos1, ypos1, xpos2, ypos2, edge, new Arrowhead(arrowx, arrowy), new Transition(stringx -= (int)((double)stringWidth * 0.5 * (Math.abs(Math.cos(theta)) + Math.abs(Math.sin(theta)))), stringy += (int)((double)stringHeight * 0.25), stringWidth, stringHeight, transitionString)));
                continue;
            }
            int r = -((w * w + h * h) / (2 * h));
            double arcAngle = 2.0 * Math.asin((double)w / (double)r);
            double sideAngle = (Math.PI - arcAngle) / 2.0;
            double startAngle = sideAngle + theta;
            if (arcAngle > 0.0) {
                startAngle += Math.PI;
            }
            int centerx = (int)((double)xpos1 - (double)Math.abs(r) * Math.cos(startAngle));
            int centery = (int)((double)ypos1 + (double)Math.abs(r) * Math.sin(startAngle));
            int cornerx = centerx - Math.abs(r);
            int cornery = centery - Math.abs(r);
            double phi = arcAngle / 2.0 * (1.0 - (double)vertexRadius / (2.0 * (double)w));
            arrowx[0] = (int)((double)xpos2 - (double)vertexRadius * Math.cos(theta + phi));
            arrowy[0] = (int)((double)ypos2 + (double)vertexRadius * Math.sin(theta + phi));
            arrowx[1] = (int)((double)arrowx[0] - (double)this.arrowHeight * Math.cos(theta - this.ARROW_ANGLE + phi));
            arrowx[2] = (int)((double)arrowx[0] - (double)this.arrowHeight * Math.cos(theta + this.ARROW_ANGLE + phi));
            arrowy[1] = (int)((double)arrowy[0] + (double)this.arrowHeight * Math.sin(theta - this.ARROW_ANGLE + phi));
            arrowy[2] = (int)((double)arrowy[0] + (double)this.arrowHeight * Math.sin(theta + this.ARROW_ANGLE + phi));
            String transitionString = edge.getOldSymbol() + " : " + edge.getNewSymbol();
            Rectangle2D charBounds = g.getFont().getStringBounds(transitionString, this.DEFAULT_FONT_RENDER_CONTEXT);
            int stringWidth = (int)Math.ceil(charBounds.getWidth());
            int stringHeight = (int)Math.ceil(charBounds.getHeight());
            double alpha = theta + Math.atan(curve);
            int stringx = (int)((double)xpos1 + (double)w * Math.cos(theta) - (double)h * Math.sin(theta));
            int stringy = (int)((double)ypos1 - (double)w * Math.sin(theta) - (double)h * Math.cos(theta));
            this.edgeDataVector.add(new EdgeGraphicsData(cornerx, cornery, Math.abs(r), (int)Math.toDegrees(startAngle), (int)Math.toDegrees(arcAngle), edge, new Arrowhead(arrowx, arrowy), new Transition(stringx -= (int)((double)stringWidth * 0.5 * (Math.abs(Math.cos(alpha)) + Math.abs(Math.sin(alpha)))), stringy += (int)((double)stringHeight * 0.25), stringWidth, stringHeight, transitionString)));
        }
        this.needToInitialize = false;
    }

    @Override
    public void paintComponent(Graphics gr) {
        EdgeGraphicsData egd;
        int i = 0;
        Graphics2D g = (Graphics2D)gr;
        if (this.machine == null) {
            return;
        }
        if (this.needToInitialize) {
            this.initialize(g);
        }
        g.setColor(this.BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.fontSize = (int)((double)vertexRadius / 1.5);
        g.setFont(new Font("Monotype", 0, this.fontSize));
        nextEdge = this.machine.getNextEdge();
        for (i = 0; i < this.numEdges; ++i) {
            egd = this.edgeDataVector.get(i);
            egd.drawHighlight(g);
        }
        for (i = 0; i < this.numEdges; ++i) {
            egd = this.edgeDataVector.get(i);
            egd.drawEdge(g);
        }
        this.fontSize = vertexRadius;
        for (i = 0; i < this.numVertices; ++i) {
            g.setFont(new Font("Monotype", 0, this.fontSize));
            this.drawVertex(this.machine.vertices.get(i), g);
        }
    }

    private TuringVertex findVertex(String name) {
        int vsize = this.machine.vertices.size();
        for (int i = 0; i < vsize; ++i) {
            TuringVertex v = this.machine.vertices.get(i);
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    private void drawVertex(TuringVertex ver, Graphics2D g) {
        int xpos = (int)(ver.getXpos() * (double)this.areaWidth) - vertexRadius;
        int ypos = (int)(ver.getYpos() * (double)this.areaHeight) - vertexRadius;
        int textXpos = xpos + vertexRadius * 5 / 8;
        int textYpos = ypos + vertexRadius * 5 / 4;
        int borderWidth = 1;
        if (ver.getHaltStatus() == 3) {
            g.setColor(this.ACCEPT_BORDER_COLOR);
        } else if (ver.getHaltStatus() == 4) {
            g.setColor(this.REJECT_BORDER_COLOR);
        } else {
            g.setColor(this.VERTEX_BORDER_COLOR);
        }
        g.fillOval(xpos, ypos, vertexRadius * 2, vertexRadius * 2);
        if (ver == this.machine.getCurrentVertex()) {
            g.setColor(this.currentVertexColor);
        } else {
            g.setColor(this.DEFAULT_VERTEX_COLOR);
        }
        g.fillOval(xpos + borderWidth, ypos + borderWidth, (vertexRadius - borderWidth) * 2, (vertexRadius - borderWidth) * 2);
        g.setColor(this.DEFAULT_TEXT_COLOR);
        switch (ver.getDirection()) {
            case 1: {
                g.drawString("L", textXpos, textYpos);
                break;
            }
            case 2: {
                g.drawString("R", textXpos, textYpos);
                break;
            }
            case 3: {
                g.drawString("Y", textXpos, textYpos);
                break;
            }
            case 4: {
                g.drawString("N", textXpos, textYpos);
                break;
            }
            default: {
                g.drawString("H", textXpos, textYpos);
            }
        }
        g.setFont(new Font("Monotype", 0, this.fontSize / 2));
        g.setColor(this.VERTEX_LABEL_COLOR);
        textXpos = xpos + vertexRadius * 7 / 8;
        textYpos = ypos + vertexRadius * 16 / 9;
        if (ver.getName().length() > 1) {
            textXpos = xpos + vertexRadius * 6 / 8;
        }
        g.drawString(ver.getName(), textXpos, textYpos);
    }

    static {
        DEFAULT_EDGE_COLOR = Color.black;
        ACTIVE_EDGE_COLOR = Color.orange;
    }

    private class Transition {
        int stringx;
        int stringy;
        int stringWidth;
        int stringHeight;
        String transition;

        Transition(int a, int b, int c, int d, String s) {
            this.stringx = a;
            this.stringy = b;
            this.stringWidth = c;
            this.stringHeight = d;
            this.transition = s;
        }

        void drawTransition(Graphics g, boolean current) {
            if (current) {
                g.setColor(TuringMachineArea.this.nextEdgeColor);
            } else {
                g.setColor(TuringMachineArea.this.BG_COLOR);
            }
            g.fillRoundRect(this.stringx - 5, this.stringy - (int)((double)this.stringHeight * 0.75) - 5, this.stringWidth + 10, this.stringHeight + 10, (int)((double)vertexRadius * 1.5), (int)((double)vertexRadius * 1.5));
            g.setColor(DEFAULT_EDGE_COLOR);
            g.drawString(this.transition, this.stringx, this.stringy);
        }
    }

    private class Arrowhead {
        int[] arrowx;
        int[] arrowy;

        Arrowhead(int[] x, int[] y) {
            this.arrowx = x;
            this.arrowy = y;
        }

        void drawArrowhead(Graphics2D g) {
            g.setColor(DEFAULT_EDGE_COLOR);
            g.fillPolygon(this.arrowx, this.arrowy, 3);
        }
    }

    private class EdgeGraphicsData {
        static final int STRAIGHT_LINE = 0;
        static final int CURVED_LINE = 1;
        static final int CIRCLE = 2;
        boolean current = false;
        int xpos1 = 0;
        int ypos1 = 0;
        int xpos2 = 0;
        int ypos2 = 0;
        int cornerx = 0;
        int cornery = 0;
        int r = 0;
        int startAngle = 0;
        int arcAngle = 0;
        int curvature;
        TuringEdge edge;
        Arrowhead arrowhead;
        Transition transition;

        public EdgeGraphicsData(int a, int b, int c, int d, TuringEdge e, Arrowhead f, Transition g) {
            this.xpos1 = a;
            this.ypos1 = b;
            this.xpos2 = c;
            this.ypos2 = d;
            this.edge = e;
            this.arrowhead = f;
            this.transition = g;
            this.curvature = 0;
        }

        public EdgeGraphicsData(int a, int b, int c, int d, int e, TuringEdge f, Arrowhead g, Transition h) {
            this.cornerx = a;
            this.cornery = b;
            this.r = c;
            this.startAngle = d;
            this.arcAngle = e;
            this.edge = f;
            this.arrowhead = g;
            this.transition = h;
            this.curvature = 1;
        }

        public EdgeGraphicsData(int a, int b, int c, TuringEdge d, Arrowhead e, Transition f) {
            this.cornerx = a;
            this.cornery = b;
            this.r = c;
            this.edge = d;
            this.arrowhead = e;
            this.transition = f;
            this.curvature = 2;
        }

        public void drawHighlight(Graphics2D g) {
            g.setColor(TuringMachineArea.this.nextEdgeColor);
            g.setStroke(new BasicStroke(vertexRadius / 2));
            if (this.edge == nextEdge) {
                if (this.curvature == 2) {
                    g.drawOval(this.cornerx, this.cornery, this.r, this.r);
                } else if (this.curvature == 1) {
                    g.drawArc(this.cornerx, this.cornery, this.r * 2, this.r * 2, this.startAngle, this.arcAngle);
                } else {
                    g.drawLine(this.xpos1, this.ypos1, this.xpos2, this.ypos2);
                }
                this.current = true;
            } else {
                this.current = false;
            }
        }

        public void drawEdge(Graphics2D g) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(DEFAULT_EDGE_COLOR);
            if (this.curvature == 2) {
                g.drawOval(this.cornerx, this.cornery, this.r, this.r);
            } else if (this.curvature == 1) {
                g.drawArc(this.cornerx, this.cornery, this.r * 2, this.r * 2, this.startAngle, this.arcAngle);
            } else {
                g.drawLine(this.xpos1, this.ypos1, this.xpos2, this.ypos2);
            }
            this.arrowhead.drawArrowhead(g);
            this.transition.drawTransition(g, this.current);
        }
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TuringMachineArea.this.needToInitialize = true;
        }

        @Override
        public void componentShown(ComponentEvent e) {
            TuringMachineArea.this.needToInitialize = true;
        }
    }
}

