/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class TuringIOProcessor {
    BufferedReader fin;
    FileOutputStream fout;
    int line;
    Vector<String> tapes = new Vector();
    Tape defaultTape;

    public Vector getTapes() {
        if (this.tapes.size() == 0) {
            this.tapes.add("[" + Tape.getFillSymbol() + "]");
        }
        return this.tapes;
    }

    public void copyFile(URL url, File file) throws IOException {
        try {
            this.fin = new BufferedReader(new InputStreamReader(url.openStream()));
            this.fout = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        while (true) {
            int c;
            if ((c = this.fin.read()) == -1) {
                this.fout.close();
                return;
            }
            this.fout.write(c);
        }
    }

    public String getMachineName(File f) throws IOException {
        String s;
        try {
            this.fin = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        do {
            if ((s = this.fin.readLine()) != null) continue;
            return f.getName();
        } while (!s.startsWith("title"));
        return this.fin.readLine();
    }

    public String getMachineDescription(File f) {
        String s = null;
        String desc = new String();
        if (f.isDirectory()) {
            return null;
        }
        try {
            this.fin = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        do {
            try {
                s = this.fin.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (s != null) continue;
            return desc;
        } while (!s.startsWith("description"));
        while (true) {
            try {
                s = this.fin.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (s == null || s.startsWith("vertices") || s.startsWith("fill symbol")) break;
            desc = new String(desc + " " + s.trim());
        }
        return desc;
    }

    public Machine getMachine(File file) throws IOException {
        String s;
        boolean fillSymbolChanged = false;
        Vector<TuringVertex> vertices = new Vector<TuringVertex>();
        Vector<TuringEdge> edges = new Vector<TuringEdge>();
        this.tapes = new Vector();
        try {
            this.fin = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        this.line = 0;
        fillSymbolChanged = false;
        do {
            if ((s = this.fin.readLine()) == null) {
                TuringMain.statusBar.setText("Error: File is not proper format.");
                return null;
            }
            if (s.startsWith("fill symbol")) {
                ++this.line;
                fillSymbolChanged = true;
                Tape.setFillSymbol(this.fin.readLine().trim());
            }
            ++this.line;
        } while (!s.toLowerCase().startsWith("vertices"));
        if (!fillSymbolChanged) {
            Tape.setFillSymbol("#");
        }
        if ((s = this.fin.readLine()) == null) {
            return null;
        }
        StringTokenizer stok = new StringTokenizer(s);
        do {
            double ypos;
            double xpos;
            int hs;
            if (s.startsWith("//") || stok.countTokens() == 0) {
                s = this.fin.readLine();
                if (s == null) {
                    return null;
                }
                stok = new StringTokenizer(s);
                ++this.line;
                continue;
            }
            if (stok.countTokens() != 4) {
                TuringMain.statusBar.setText("Error in line " + this.line + ": Wrong number of parameters.");
                return null;
            }
            String name = new String(stok.nextToken());
            s = stok.nextToken().toUpperCase();
            if (s.equals("L")) {
                hs = 1;
            } else if (s.equals("R")) {
                hs = 2;
            } else if (s.equals("H")) {
                hs = 0;
            } else if (s.equals("Y")) {
                hs = 3;
            } else if (s.equals("N")) {
                hs = 4;
            } else {
                TuringMain.statusBar.setText("Error in line " + this.line + ": invalid direction - halt status");
                return null;
            }
            s = stok.nextToken();
            try {
                xpos = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                TuringMain.statusBar.setText("Error in line " + this.line + ": invalid x-coordinate");
                return null;
            }
            s = stok.nextToken();
            try {
                ypos = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                TuringMain.statusBar.setText("Error in line " + this.line + ": invalid y-coordinate");
                return null;
            }
            TuringVertex ver = new TuringVertex(name, hs, xpos, ypos);
            vertices.add(ver);
            s = this.fin.readLine();
            if (s == null) {
                return null;
            }
            stok = new StringTokenizer(s);
            ++this.line;
        } while (!s.toLowerCase().startsWith("edges"));
        s = this.fin.readLine();
        if (s == null) {
            return null;
        }
        stok = new StringTokenizer(s);
        do {
            double curve;
            if (s.startsWith("//") || stok.countTokens() == 0) {
                s = this.fin.readLine();
                if (s == null) {
                    if (edges.size() != 0) break;
                    return null;
                }
                stok = new StringTokenizer(s);
                ++this.line;
                continue;
            }
            if (stok.countTokens() != 5 && stok.countTokens() != 4) {
                TuringMain.statusBar.setText("Error in line " + this.line + ": wrong number of parameters");
                return null;
            }
            String ot = stok.nextToken();
            String nt = stok.nextToken();
            String oy = stok.nextToken();
            String ny = stok.nextToken();
            if (stok.countTokens() == 0) {
                curve = 0.0;
            } else {
                s = stok.nextToken();
                curve = Double.parseDouble(s);
            }
            if (!ot.equals(nt) || !oy.equals(ny)) {
                Enumeration e = edges.elements();
                while (e.hasMoreElements()) {
                    TuringEdge edge = (TuringEdge)e.nextElement();
                    if (!edge.getOldState().equals(ot) || !edge.getOldSymbol().equals(oy)) continue;
                    String err = "Error in this edge: " + s + ": it makes a nondeterministic Turing Machine";
                    TuringMain.statusBar.setText(err);
                    System.out.println(err);
                    JOptionPane.showMessageDialog(TuringMain.statusBar, err);
                }
                edges.add(new TuringEdge(ot, nt, oy, ny, curve));
            } else {
                String err = "This edge rejected: " + ot + " " + nt + " " + oy + " " + ny + ": and not needed";
                TuringMain.statusBar.setText(err);
                System.out.println(err);
                JOptionPane.showMessageDialog(TuringMain.statusBar, err);
            }
            s = this.fin.readLine();
            if (s == null) {
                if (edges.size() != 0) break;
                return null;
            }
            stok = new StringTokenizer(s);
            ++this.line;
        } while (!s.toLowerCase().startsWith("tapes"));
        if ((s = this.fin.readLine()) == null) {
            this.defaultTape = new Tape("[" + Tape.getFillSymbol() + "]");
            return new Machine(vertices, edges, this.defaultTape);
        }
        stok = new StringTokenizer(s);
        while (true) {
            ++this.line;
            if (s.startsWith("//") || stok.countTokens() == 0) {
                s = this.fin.readLine();
                if (s == null) break;
                stok = new StringTokenizer(s);
                continue;
            }
            this.tapes.add(s);
            s = this.fin.readLine();
            if (s == null) break;
            stok = new StringTokenizer(s);
        }
        this.defaultTape = this.tapes.size() == 0 ? new Tape("[" + Tape.getFillSymbol() + "]") : new Tape(this.tapes.get(0));
        return new Machine(vertices, edges, this.defaultTape);
    }
}

