/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.StringTokenizer;

public class Tape {
    private static String FILL_SYMBOL = "#";
    private static int TRAILING_EDGE = 0;
    private int position = 0;
    private LinkedList<String> tape;
    private int origin = TRAILING_EDGE;

    public Tape(String s) {
        int i;
        StringTokenizer stok = new StringTokenizer(s);
        this.tape = new LinkedList();
        for (i = 0; i < TRAILING_EDGE; ++i) {
            this.tape.add(FILL_SYMBOL);
        }
        i = TRAILING_EDGE;
        while (stok.hasMoreTokens()) {
            String symbol = stok.nextToken();
            if (symbol.startsWith("[") && symbol.endsWith("]")) {
                this.position = i;
                this.tape.add(symbol.substring(1, symbol.length() - 1));
            } else {
                this.tape.add(symbol);
            }
            ++i;
        }
        int len = i;
        while (i < len + TRAILING_EDGE) {
            this.tape.add(FILL_SYMBOL);
            ++i;
        }
    }

    public Tape(Tape t) {
        this.position = t.position;
        this.tape = new LinkedList();
        for (String s : t.tape) {
            this.tape.add(s);
        }
    }

    public int getCurrentPosition() {
        return this.position;
    }

    public void setCurrentPosition(int i) {
        this.position = i;
    }

    public String getCurrentSymbol() {
        return this.tape.get(this.position);
    }

    public String getSymbolAt(int i) {
        return this.tape.get(i);
    }

    public int getSize() {
        return this.tape.size();
    }

    public static String getFillSymbol() {
        return FILL_SYMBOL;
    }

    public static void setFillSymbol(String s) {
        FILL_SYMBOL = s;
    }

    public void deleteCell() {
        this.tape.remove(this.position);
        if (this.position != 0) {
            --this.position;
        } else {
            --this.origin;
        }
    }

    public void shiftLeft() {
        if (this.position == 0) {
            this.addSymbolFirst(FILL_SYMBOL);
        } else {
            --this.position;
        }
    }

    public void addSymbolFirst(String s) {
        ++this.origin;
        this.tape.addFirst(s);
    }

    public void shiftRight() {
        if (this.position == this.tape.size() - 1) {
            this.addSymbolLast(FILL_SYMBOL);
        }
        ++this.position;
    }

    public void addSymbolLast(String s) {
        this.tape.addLast(s);
    }

    public void writeSymbol(String symbol) {
        if (!this.tape.get(this.position).equals(symbol)) {
            this.tape.remove(this.position);
            this.tape.add(this.position, symbol);
        }
    }

    public int getOrigin() {
        return this.origin;
    }
}

