/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.Vector;

public class Machine {
    final int HISTORY_MAX_SIZE = 1000;
    public static final int NOT_HALTED = 0;
    public static final int HALTED = 1;
    public static final int ACCEPT = 2;
    public static final int REJECT = 3;
    public Vector<TuringVertex> vertices;
    public Vector<TuringEdge> edges;
    public int steps;
    private String currentSymbol = null;
    private TuringVertex currentVertex = null;
    private TuringEdge lastEdge = null;
    private TuringEdge nextEdge = null;
    private TuringIOProcessor iop = new TuringIOProcessor();
    private Tape tape;
    private LinkedList<TuringEdge> history;

    public Machine(Vector<TuringVertex> v, Vector<TuringEdge> e, Tape t) {
        this.vertices = v;
        this.edges = e;
        this.tape = t;
        this.currentVertex = this.vertices.get(0);
        this.currentSymbol = this.tape.getCurrentSymbol();
        this.nextEdge = this.findEdge(this.currentVertex, t.getCurrentSymbol());
        this.history = new LinkedList();
        this.steps = 0;
    }

    public TuringVertex getCurrentVertex() {
        return this.currentVertex;
    }

    public TuringEdge getNextEdge() {
        if (this.nextEdge == null) {
            return new TuringEdge(this.currentVertex.getName(), this.currentVertex.getName(), this.currentSymbol, this.currentSymbol, 0.0);
        }
        return this.nextEdge;
    }

    public void setTape(Tape t) {
        this.tape = t;
    }

    private TuringVertex findVertex(String name) {
        int vsize = this.vertices.size();
        for (int i = 0; i < vsize; ++i) {
            TuringVertex v = this.vertices.get(i);
            if (!name.equals(v.getName())) continue;
            return v;
        }
        System.err.println("Error: " + name + " is not a state.");
        return null;
    }

    private TuringEdge findEdge(TuringVertex v, String symbol) {
        int esize = this.edges.size();
        for (int i = 0; i < esize; ++i) {
            TuringEdge ed = this.edges.get(i);
            if (!v.getName().equals(ed.getOldState()) || !symbol.equals(ed.getOldSymbol())) continue;
            return ed;
        }
        return null;
    }

    public void resetMachine() {
        this.currentVertex = this.vertices.get(0);
        this.lastEdge = null;
        this.currentSymbol = this.tape.getCurrentSymbol();
        this.nextEdge = this.findEdge(this.currentVertex, this.currentSymbol);
        this.history = new LinkedList();
        TuringMain.repaintMachineArea();
        TuringMain.repaintTapeArea();
        this.steps = 0;
    }

    public void stepForward() {
        String state = new String(this.currentVertex.getName());
        ++this.steps;
        this.currentSymbol = this.tape.getCurrentSymbol();
        this.lastEdge = this.nextEdge;
        if (this.nextEdge != null) {
            state = this.nextEdge.getNewState();
            this.tape.writeSymbol(this.nextEdge.getNewSymbol());
            this.history.addLast(this.nextEdge);
        } else {
            this.history.addLast(new TuringEdge(this.currentVertex.getName(), this.currentVertex.getName(), this.currentSymbol, this.currentSymbol, this.currentVertex.getDirection()));
            boolean bl = false;
        }
        if (this.history.size() > 1000) {
            this.history.removeFirst();
        }
        this.currentVertex = this.findVertex(state);
    }

    public int shiftAndGetHaltStatus() {
        if (this.currentVertex.getDirection() == 2) {
            this.tape.shiftRight();
        } else if (this.currentVertex.getDirection() == 1) {
            this.tape.shiftLeft();
        } else {
            this.nextEdge = null;
            switch (this.currentVertex.getHaltStatus()) {
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
            }
            return 1;
        }
        return 0;
    }

    public void updateMachine() {
        this.currentSymbol = this.tape.getCurrentSymbol();
        this.nextEdge = this.findEdge(this.currentVertex, this.currentSymbol);
    }

    /*
     * Unable to fully structure code
     */
    public boolean stepBack() {
        block6: {
            --this.steps;
            if (this.steps < 0) {
                this.steps = 0;
            }
            if (this.history.size() <= 0) break block6;
            ed = this.history.removeLast();
            if (this.tape.getCurrentPosition() != 0 && this.tape.getCurrentPosition() != this.tape.getSize() - 1) ** GOTO lbl-1000
            v0 = this;
            if (this.tape.getCurrentSymbol().equals(v0.tape.getFillSymbol()) && this.tape.getSize() > TuringMain.originalTape.getSize()) {
                this.tape.deleteCell();
            } else if (this.currentVertex.getDirection() == 2) {
                this.tape.shiftLeft();
            } else if (this.currentVertex.getDirection() == 1) {
                this.tape.shiftRight();
            }
            this.tape.writeSymbol(ed.getOldSymbol());
            this.currentVertex = this.findVertex(ed.getOldState());
            this.nextEdge = this.lastEdge;
            this.lastEdge = this.history.size() > 0 ? this.history.getLast() : null;
            return true;
        }
        return false;
    }
}

