/* *****************************************************************************
 *
 *  Description: Counts the number of times each String has occurred.
 *
 *  % more duckduckgoose.txt
 *  duck duck goose
 *
 *  % java-introcs FrequencyTable < duckduckgoose.txt
 *  duck 2
 *  goose 1
 *
 *  Remarks:
 *   - This is book/booksite Exercise 4.4.45
 *   - Use with any text file
 *
 **************************************************************************** */

public class FrequencyTable {
    // maintain counts of all words seen so far
    // the key is the word and the value is the count
    private ST<_________________> st;
   
    // a no-argument constructor
    public FrequencyTable() {
        st = null; // fix this
    }

    // return string representation of frequency table
    public String toString() {
        // using StringBuilder - a mutable String that is more
        // efficient than String for constructing large Strings
        StringBuilder sb = new StringBuilder();
        
        // foreach loop goes through all keys in alphabetical order
        for (String word : st.keys()) {
            
            // EACH word and its frequency, separated by a space
            sb.append(______ + " " + st.______(______) + "\n");
        }
        return sb.toString();
    }
   
    
    // add 1 to the frequency of this word
    public void increment(String word) {
        int count = frequencyOf(word); // get the word's current frequency
        st.put(____, ____);            // now save the new frequence in the ST
    }
   
    // what is the frequency of this word?
    public int frequencyOf(String word) {
        if (!st.__________(word)) return 0;    // if word is not in ST
        else return st._____(______);          // get word's count
    }
   
    // method used by client to count all words in StdIn
    public static void main(String[] args) {
        
        // build frequency table from words on standard input
        FrequencyTable freq = new FrequencyTable();
        while (!StdIn.isEmpty()) {
            String word = StdIn.readString();
            freq.increment(word);
        }
        
        // print frequency table to standard output
        StdOut.println(freq);
    }
}

