/* *****************************************************************************
 * Description: This class is implemented to be immutable: once the
 * client program initializes a Vector, it cannot change any of its
 * fields (n or data[i]) either directly or indirectly. Immutability
 * is a very desirable feature of a data type.
 *
 * Output:
 * % java-introcs Vector
 * x        = ( 1.0, 2.0, 3.0, 4.0 )
 * y        = ( 5.0, 2.0, 4.0, 1.0 )
 * z        = ( 0.0, 0.0, 0.0, 0.0 ) - zero vector of length 4
 * x + y    = ( 6.0, 4.0, 7.0, 5.0 )
 * x - y    = ( -4.0, 0.0, -1.0, 3.0 )
 * 10x      = ( 10.0, 20.0, 30.0, 40.0 )
 * <x, y>   = 25.0
 * |x|      = 5.477225575051661
 *
 * Remarks:
 * - See booksite for an implementation of a vector of real numbers:
 *   https://www.cs.princeton.edu/introcs/34nbody/Vector.java
 * - Vector is also the name of an unrelated Java library class.
 **************************************************************************** */

public class Vector {
    private int n;           // length of the vector
    private double[] data;   // array of vector's components


    // create a vector from the given array
    public Vector(double[] value) {
        n = value.length;

        // We need a defensive copy so client can't alter our copy of data[]
        // This isn't it!
        double[] data = value;

    }


    // create the zero Vector of length n
    public Vector(int n) {
        // complete this
    }


    // return the length of the vector
    public int length() {
        return 0; // fix this
    }     


    // this + that: add this Vector to Vector that and return sum
    public Vector plus(Vector that) {
        // check if vectors are the same length
        if (this.length() != that.length()) {
            throw new RuntimeException("lengths of two vectors are not equal"); 
        }

        // create vector of the same length with all values 0
        Vector sum = new Vector(this.n);
        
        // compute sum = x + y
        for (int i = 0; i < this.n; i++) {
            sum.data[i] = this.data[i] + that.data[i];
        }

        // return the sum
        return sum;
    }

    // this - that: subtract that Vector from this Vector and return difference
    public Vector subtract(Vector that) {
        // check if vectors are the same length

        // create vector of the same length with all values 0
        
        // compute difference = x - y
        
        // return the difference
        return null;
    }

    // create and return a new Vector multiplying each element by factor
    public Vector times(double factor) {
        // create vector of the same length with all values 0
        Vector result = new Vector(n);
        for (int i = 0; i < n; i++) {
            // your code here
        }
        return result;
    }


    // return the inner product of this Vector and that Vector 
    public double dot(Vector that) {
        // check if vectors are the same length

        double sum = 0.0;
        for (int i = 0; i < n; i++) {
            // your code goes here
        }
            
        return sum;
    }

    // return the Euclidean norm of this Vector
    public double magnitude() {
        double result = 0.0;

        // fix this below - recall magnitude is square root of dot product
        result = Math.sqrt(0.0);  
        
        return result;
    }

    // return a string representation of the vector
    public String toString() {
        String result = "(";
        for (int i = 0; i < n; i++) {
            result = result + data[i];  // append a value
            if (i < n - 1) 
                result = result + ", "; // need a comma except for last element
        }
        return result + ")";
    }

    // some additional methods....

    // return the corresponding coordinate
    public double cartesian(int i) {
        return data[i];
    }

    // return the corresponding unit vector
    public Vector direction() {
        return this.times(1.0 / this.magnitude());
        // return times(1.0 / magnitude()); is equivalent
    }


    // test client
    public static void main(String[] args) {
        // is it really immutable?
        System.out.println("Immutability test: ");
        double[] a = {3.0, 4.0};
        Vector v = new Vector(a);
        System.out.println("v = " + v); // should be (3.0, 4.0)
        a[0] = 0;
        System.out.println("v = " + v); // should still be (3.0, 4.0)!!

        // other tests
        double[] xdata = { 1.0, 2.0, 3.0, 4.0 };
        double[] ydata = { 5.0, 2.0, 4.0, 1.0 };

        Vector x = new Vector(xdata);
        Vector y = new Vector(ydata);
        Vector z = new Vector(xdata.length);

        // Print the vectors and their length
        StdOut.println("x        = " + x + ": " + x.length());
        StdOut.println("y        = " + y + ": " + y.length());
        StdOut.println("z        = " + z + ": " + z.length());

        // Plus and subtract
        StdOut.println("x + y    = " + x.plus(y));
        StdOut.println("x - y    = " + x.subtract(y));

        // Multiplication of a vector x by a constant k
        StdOut.println("10x      = " + x.times(10.0));

        // Dot product
        StdOut.println("<x, y>   = " + x.dot(y));

        // Magnitude
        StdOut.println("|x|      = " + x.magnitude());

    }
}
