/* *****************************************************************************
 *
 * Description: Uses parallel arrays to store the position, velocity,
 *              and size of multiple balls at a time
 **************************************************************************** */

public class Parallel {
    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);

        // initialize standard drawing
        StdDraw.setXscale(-1.0, 1.0);
        StdDraw.setYscale(-1.0, 1.0);
        StdDraw.enableDoubleBuffering();

        // parallel arrays for all balls
        double[] rx = new double[n];
        double[] ry = new double[n];
        double[] vx = new double[n];
        double[] vy = new double[n];
        double[] radius = new double[n];

        // initial values, random velocity and size for all balls
        for (int i = 0; i < n; i++) {
            rx[i] = 0.0;
            ry[i] = 0.0;
            vx[i] = 0.015 - Math.random() * 0.03;
            vy[i] = 0.015 - Math.random() * 0.03;
            radius[i] = 0.025 + Math.random() * 0.05;
        }

        // main animation loop
        while (true) {
            // move all balls
            for (int i = 0; i < n; i++) {
                // bounce off wall according to law of elastic collision
                if (Math.abs(rx[i] + vx[i]) > 1.0 - radius[i])
                    vx[i] = -vx[i];
                if (Math.abs(ry[i] + vy[i]) > 1.0 - radius[i])
                    vy[i] = -vy[i];

                // update position
                rx[i] = rx[i] + vx[i];
                ry[i] = ry[i] + vy[i];
            }

            // clear the background
            StdDraw.clear(StdDraw.GRAY);

            // draw all balls on the screen
            StdDraw.setPenColor(StdDraw.BLACK);
            for (int i = 0; i < n; i++) {
                StdDraw.filledCircle(rx[i], ry[i], radius[i]);
            }

            // display and pause for 20 ms
            StdDraw.show();
            StdDraw.pause(20);
        }
    }
}
