/* **********************************************************************
 *
 * Various examples using the String API:
 *
 * https://introcs.cs.princeton.edu/java/11cheatsheet/#String
 *
 * Based on the lyric line from Old Nassau:
 *
 *     In praise of Old Nassau, we sing,
 *
 * **********************************************************************/


public class StringAlong {
    // Conduct experiments using String
    public static void main(String[] args) {

        String lyric = "In praise of Old Nassau, we sing,"; // a lyric from Old Nassau

        // Print the length of the lyric
        StdOut.printf("Length of lyric *%s* is: %d\n\n", lyric, lyric.____());

        // Print the last character of the lyric
        StdOut.printf("Last character of lyric *%s* is: %c\n\n",
                      lyric, lyric.charAt(_____));

        // Print the substring "Old Nassau"
        StdOut.printf("Print substring *Old Nassau* is: %s\n\n",
                      lyric.____(__, ___));

        // Use concat to concatenate this lyric to first lyric
        // Separate with a newline
        // Hurrah! Hurrah! Hurrah!
        String newLine = "\n";
        String lyricNext = "Hurrah! Hurrah! Hurrah!";
        String newLyric = lyric.concat(____).concat(___);
        StdOut.printf("Print two lyric lines:\n%s\n\n", ____);

        // Review this code below.  What do you think the output will be? 
        //   Then remove the multi-line comment, compile and execute.
        
        /*
        // Check .equals vs ==
        StdOut.println("Using the .equals method");
        String lyricCopy = new String(lyric);
        if (lyric.equals(lyricCopy))
            StdOut.println("The variables lyric and lyricCopy have the same Strings");
        else
            StdOut.println("The variables lyric and lyricCopy have different Strings");
        StdOut.println();
        StdOut.println("Using the == comparison operator");
        StdOut.println();
        String lyricAlias = lyric;
        if (lyric == lyricAlias)
            StdOut.println("The variables lyric and the lyricAlias are aliases to the same String");
        else
            StdOut.println("The variables lyric and lyricAlias are not aliases to the same String");
        StdOut.println();
        if (lyric == lyricCopy)
            StdOut.println("The variables lyric and lyricCopy are aliases to the same String");
        else
            StdOut.println("The variables lyric and lyricCopy are not aliases to the same String");
        StdOut.println();
        */

    }
}
