// A version of Palindrome using dynamic programming.
// Takes as a command-line argument n -
// the number of levels - and prints a palindrome
public class PalindromeMemo {
    // static variable is "global" to class - initially null
    private static String[] memo;

    // computes the palindrome
    public static String palindrome(int n) {
        // NOTE - the default values for a new array of Strings 
        // is the value null
        // NOTE - allocate memo in this function, not main
        memo = new String[n + 1]; // initialize the static variable
                                  // initial values of String[] are null
        return palindromeR(n);    // compute palindrome of n
    }

    // helper method - computes a palindrome using memoization
    private static String palindromeR(int n) {
        // base cases
        if (n == 0)
            memo[n] = ____  // store result of memo[0]

        else if (n == 1)
            memo[n] = ____  // store result of memo[1]

        // check if memo[n] has been computed previously or not
        else if (memo[n] == null)  // memo[] not computed previously
            memo[n] =              // so we need to compute memo[n]
                  palindromeR(n - __)
                + palindromeR(n - __)
                + palindromeR(n - __);

        // return the value of memo[n]
        return ____;
    }

    // main method takes a single command-line argument n
    // and prints the palindrome
    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        System.out.println(palindrome(n));
    }
}
