/* *****************************************************************************
 *  Description:  Computes and prints the first n Fibonacci numbers using
 *                dynamic programming (memoization).
 *
 *                F(n) = F(n-1) + F(n-2) for n >= 2, with F(0) = 0 and F(1) = 1
 *
 *  *****************************************************************************/
public class FibonacciMemo {
    // static variable is "global" to class
    private static long[] memo;

    // computes fibonacci
    public static long fib(int n) {
        // initialize memo to all 0s - not yet known
        memo = new long[n+1];  
        return fibR(n);        // compute fibonacci of n
    }

    // private recursive helper method
    private static long fibR(int n) {
        
        // first check if f(n) has already been calculated
        // if so, just return the value
        if (memo[n] != 0) return memo[n];

        // base cases
        if      (n == 0) memo[0] = 0;
        else if (n == 1) memo[1] = 1;
        // otherwise cacluate / save value
        else memo[n] = fibR(n-1) + fibR(n-2);

        return memo[n]; // return stored value
    }

    // main method - takes a single command-line argument n
    public static void main(String[] args) {
        int n = Integer.parseInt(args[0]);
        StdOut.println(fib(n));
    }
}
