/********************************************************************************
 *  Checks that main() is the last declared method.
 *  (Written by ChatGPT, fixing key misunderstanding of AST tree by Kevin Wayne.)
 ********************************************************************************/
package edu.princeton.cs.lift.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * A Checkstyle check that detects use of the diamond form ("<>") in generic type instantiations.
 */
public class NoDiamondCheck extends AbstractCheck {

    private static final String MSG_KEY = "diamond.disallowed";

    @Override
    public int[] getDefaultTokens() {
        // We care about new expressions like: new ArrayList<>()
        return new int[] { TokenTypes.LITERAL_NEW };
    }

    @Override
    public int[] getAcceptableTokens() {
        return getDefaultTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        // LITERAL_NEW has a child TYPE_ARGUMENTS
        DetailAST typeArgsAst = ast.findFirstToken(TokenTypes.TYPE_ARGUMENTS);
        if (typeArgsAst != null) {
            // Diamond operator has nothing between < and >: firstChild is '<', lastChild is '>'
            if ((typeArgsAst.getChildCount() == 2)
                    && (typeArgsAst.getFirstChild().getType() == TokenTypes.GENERIC_START)
                    && (typeArgsAst.getLastChild().getType() == TokenTypes.GENERIC_END)) {
                log(typeArgsAst, MSG_KEY);
            }
        }
    }
}
