/* ************************************************************************************
 * Library of static methods that performs various geometric transforms on polygons.
 *
 * The API expects the angles to be in degrees, but Java's
 * trigonometric functions take the arguments in radians. Use
 * Math.toRadians() to convert from degrees to radians. 
 * 
 * The transformation methods scale(), translate(), and rotate()
 * mutate the array arguments. The function copy() does not mutate the
 * array argument. 
 * 
 * The array arguments passed to scale(), translate(), and rotate()
 * are not null, are the same length, and do not contain the values
 * NaN, Double.POSITIVE_INFINITY, or Double.NEGATIVE_INFINITY.  
 * 
 * The array passed to copy() is not null.
 *
 * The values for the parameters alpha, theta, dx, and dy are not
 * NaN, Double.POSITIVE_INFINITY, or Double.NEGATIVE_INFINITY.
 *
 * ************************************************************************************/
public class Transform2D {

    // Scales the polygon by the factor alpha:
    // x[i] = x[i] * alpha
    // y[i] = y[i] * alpha
    public static void scale(double[] x, double[] y, double alpha)

    // Translates the polygon by (dx, dy):
    // x[i] = x[i] + dx
    // y[i] = y[i] + dy
    public static void translate(double[] x, double[] y, double dx, double dy)

    // Rotates the polygon theta degrees counterclockwise, about the origin.
    // x[i] = x[i] * cos(theta) - y[i] * sin(theta)
    // y[i] = y[i] * cos(theta) + x[i] * sin(theta)
    // Hint: convert degrees to radians using Math.toRadians
    // See: https://introcs.cs.princeton.edu/java/11cheatsheet/#Math
    public static void rotate(double[] x, double[] y, double theta)

    // Returns a new array object that is an exact copy of the given array.
    // The given array is not mutated.
    private static double[] copy(double[] array)

    // Tests each of the API methods by directly calling them.
    public static void main(String[] args)

}
