// REFERENCE IMPLEMENTATION
// ===== EXAM PART 1 =====
// Immutable class representing a word and its path in a word puzzle.
public class WordPath {
    // EXAM: Instance variables go here.
    private String word; // actual word
    private int[] x;    // x coords
    private int[] y;    // y coords

    // Constructor that gets a word and its path as arguments.
    public WordPath(String word, int[] pathCols, int[] pathRows) {
        // EXAM: Your code goes here.
        // check for exceptions first
        if ((word.length() < 3)
            || word.length() != pathCols.length
            || word.length() != pathRows.length)
            throw new IllegalArgumentException("invald args");
        
        // initialize all instance variables
        this.word = word;
        int n = pathCols.length;
        // create defensive copies of each array
        x = new int[n];
        y = new int[n];
        for (int i = 0; i < n; i++) {
            x[i] = pathCols[i];
            y[i] = pathRows[i];
        }
    }

    // Constructor that reads a word and path from a file.
    public WordPath(String filename) {
        // EXAM: Your code goes here.
        In file = new In(filename); // open the file
        word = file.readString();   // get the word and its length
        int n = word.length();      // need the number of words
        x = new int[n];             // create the arrays
        y = new int[n];
        for (int i = 0; i < n; i++)  // read the x coordinates
            x[i] = file.readInt();
        for (int i = 0; i < n; i++)  // read the y coordinates
            y[i] = file.readInt();
    }


    // Return the word.   
    public String getWord() {
        // EXAM: Your code goes here.
        return word;
    }
    
    // Return the length.   
    public int getLength() {
        // EXAM: Your code goes here.
        return word.length();
    }
    
    // Return the character at the given index in the word.   
    public char charAt(int index) {
        // EXAM: Your code goes here.
        return word.charAt(index);
    }
    
    // Return the column at the given index in the path.   
    public int colAt(int index) {
        // EXAM: Your code goes here.
        return x[index];
    }
    
    // Return the row at the given index in the path.   
    public int rowAt(int index) {
        // EXAM: Your code goes here.
        return y[index];
    }

    // Return a string representation of the word and its path.
    // For example: "CHORD: C(0,0) H(1,0) O(2,0) R(1,1) D(0,1)"
    public String toString() {
        // EXAM: Your code goes here.
        String s = word + ": "; // first the word 
        // loop over the characters
        for (int i = 0; i < word.length(); i++) {
            s = s + word.substring(i, i+1) + "(" +
                x[i] + "," + y[i] + ") ";
                                               
        }
        /*        // alternative version:
        for (int i = 0; i < word.length(); i++) {
            s = s + charAt(i) + "(" + colAt(i) + 
                "," + rowAt(i) + ") ";
            
                }*/
        
        // return the string
        return s;
    }

    // Test client. Tests all public methods in class.
    public static void main(String[] args) {
        // EXAM: Your code goes here.
        String testWord = "CHORD";
        int[] wordCols = {0, 1, 2, 1, 0};
        int[] wordRows = {0, 0, 0, 1, 1};

        // test 1 - a single word
        WordPath wp1 = new WordPath(testWord, wordCols, wordRows);
        StdOut.println(wp1);
        StdOut.println(wp1.charAt(0));
        StdOut.println(wp1.charAt(3));
        StdOut.println(wp1.colAt(4));
        StdOut.println(wp1.rowAt(4));
        StdOut.println(wp1.getLength());
        StdOut.println(wp1.getWord());

        // test 2 - read from a file, using command-line
        // argument for filename
        WordPath wp2 = new WordPath(args[0]);
        StdOut.println(wp2);
        StdOut.println(wp2.charAt(0));
        StdOut.println(wp2.charAt(3));
        StdOut.println(wp2.colAt(4));
        StdOut.println(wp2.rowAt(4));
        
    }

}
