// REFERENCE IMPLEMENTATION
// ===== EXAM PART 3 =====

public class TigerWords {

    // Draw circles on a word path.
    public static void drawCirclesOnPath(WordPath word) {
        // EXAM: Your code goes here.
        int n = word.getLength();             // get number of chars in word
        for (int i = 0; i < n; i++) {         // loop over each char in word
            int col = word.colAt(i);          // get the char's location
            int row = word.rowAt(i);
            StdBoard.drawCircle(col, row);    // now draw the circle
        }
    }

    // Draw letters of a word path.
    public static void drawLettersOnPath(WordPath word) {
        // EXAM: Your code goes here.
        int n = word.getLength();             // get number of chars in word  
        for (int i = 0; i < n; i++) {         // loop over each char in word
            int col = word.colAt(i);          // get the char's location
            int row = word.rowAt(i);
            char letter = word.charAt(i);
            StdBoard.drawLetter(col, row, letter); // now draw the letter
        }
    }

    // Draw lines connecting adjacent letters on a word path.
    public static void drawLinesOnPath(WordPath word) {
        // EXAM: Your code goes here.
        int n = word.getLength();             // get number of chars in word  
        // loop starts at 1, since drawing n-1 lines
        for (int i = 1; i < n; i++) {
            int col0 = word.colAt(i - 1);     // get the previous location
            int row0 = word.rowAt(i - 1);
            int col1 = word.colAt(i);         // get the current locaion
            int row1 = word.rowAt(i);
            StdBoard.drawLine(col0, row0, col1, row1); // draw the line
        }
    }

    // Check if two word paths overlap.
    // They intersect if a letter from one word path is in the
    // same position as a letter from the other word path.
    public static boolean pathsOverlap(WordPath w0, WordPath w1) {
        // EXAM: replace this with your code
        // get lengths of each word
        int n0 = w0.getLength(); 
        int n1 = w1.getLength();
        // outer loop over first word chars
        for (int i = 0; i < n0; i++) {
            // get the ith coordinate of the char of first word
            int col0 = w0.colAt(i);
            int row0 = w0.rowAt(i);
            // inner loop over second word chars
            for (int j = 0; j < n1; j++) {
                // get the jth coordinate of the char of second word
                int col1 = w1.colAt(j);
                int row1 = w1.rowAt(j);
                // check for same values
                if (col0 == col1 && row0 == row1) {
                    return true;  // found an intersection!
                }
            }
        }
        return false; // no intersection!
    }


    // ===== TESTING -- DO NOT EDIT BELOW HERE =====

    // Tests the pathsOverlap method above.
    // Check all pairs of words in the puzzle to see if any pair overlaps.
    // If so print message with the two overlapping words and return true.
    // This method provided. [DO NOT EDIT]
    public static boolean testPathsOverlap(Puzzle puzzle) {
        int nWords = puzzle.getNumWordPaths();
        for (int i = 0; i < nWords; i++) {
            WordPath w0 = puzzle.wordPathAt(i);
            for (int j = i + 1; j < nWords; j++) {
                WordPath w1 = puzzle.wordPathAt(j);
                if (pathsOverlap(w0, w1)) {
                    StdOut.println("Overlap between two word paths:");
                    StdOut.println(w0);
                    StdOut.println(w1);
                    return true;
                }
            }
        }
        return false;
    }

    // Main method provided. [DO NOT EDIT]
    public static void main(String[] args) {
        // Read command line arguments.
        String filename = args[0];
        int numWordsToCircle = Integer.parseInt(args[1]);

        // Read a puzzle from a file.
        Puzzle puzzle = new Puzzle(filename);

        // Check for overlapping paths.
        boolean overlap = testPathsOverlap(puzzle);
        if (overlap) return; // quit

        // Get puzzle dimensions
        int cols = puzzle.getCols();
        int rows = puzzle.getRows();

        // STUDENT: // Set up drawing for the puzzle board
        // Fancy version not supplied to student...
        if (args.length > 2) {
            StdBoard.initialize("make-figure");
        }
        // END_STUDENT
        StdBoard.setupBoard(cols, rows);

        int nWords = puzzle.getNumWordPaths();
        for (int i = 0; i < nWords; i++) {
            WordPath word = puzzle.wordPathAt(i);
            if (i < numWordsToCircle) {
                drawCirclesOnPath(word);
                drawLinesOnPath(word);
            }
            drawLettersOnPath(word);
        }

        // STUDENT: StdBoard.showBoard();
        // Fancy version not supplied to student...
        if (args.length > 3) {
            StdBoard.drawCaption(args[3]);
        }
        if (args.length > 2) {
            StdBoard.savePic(args[2]);
        }
        else {
            StdBoard.showBoard();
        }
        // END_STUDENT
    }

}
