// ===== EXAM PART 3 =====

public class TigerWords {

    // Draw circles on a word path.
    public static void drawCirclesOnPath(WordPath word) {
        // EXAM: Your code goes here.
    }

    // Draw letters of a word path.
    public static void drawLettersOnPath(WordPath word) {
        // EXAM: Your code goes here.
    }

    // Draw lines connecting adjacent letters on a word path.
    public static void drawLinesOnPath(WordPath word) {
        // EXAM: Your code goes here.
    }

    // Check if two word paths overlap.
    // They intersect if a letter from one word path is in the
    // same position as a letter from the other word path.
    public static boolean pathsOverlap(WordPath w0, WordPath w1) {
        return false; // EXAM: replace this with your code
    }


    // ===== TESTING -- DO NOT EDIT BELOW HERE =====

    // Tests the pathsOverlap method above.
    // Check all pairs of words in the puzzle to see if any pair overlaps.
    // If so print message with the two overlapping words and return true.
    // This method provided. [DO NOT EDIT]
    public static boolean testPathsOverlap(Puzzle puzzle) {
        int n = puzzle.getNumWordPaths();
        for (int i = 0; i < n; i++) {
            WordPath w0 = puzzle.wordPathAt(i);
            for (int j = i + 1; j < n; j++) {
                WordPath w1 = puzzle.wordPathAt(j);
                if (pathsOverlap(w0, w1)) {
                    StdOut.println("Overlap between two word paths:");
                    StdOut.println(w0);
                    StdOut.println(w1);
                    return true;
                }
            }
        }
        return false;
    }

    // Main method provided. [DO NOT EDIT]
    public static void main(String[] args) {
        // Read command line arguments.
        String filename = args[0];
        int numWordsToCircle = Integer.parseInt(args[1]);

        // Read a puzzle from a file.
        Puzzle puzzle = new Puzzle(filename);

        // Check for overlapping paths.
        boolean overlap = testPathsOverlap(puzzle);
        if (overlap) return; // quit

        // Get puzzle dimensions
        int cols = puzzle.getCols();
        int rows = puzzle.getRows();

        // Set up drawing for the puzzle board
        StdBoard.setupBoard(cols, rows);

        int n = puzzle.getNumWordPaths();
        for (int i = 0; i < n; i++) {
            WordPath word = puzzle.wordPathAt(i);
            if (i < numWordsToCircle) {
                drawCirclesOnPath(word);
                drawLinesOnPath(word);
            }
            drawLettersOnPath(word);
        }

        StdBoard.showBoard();
    }

}