/*
 Reference solution COS 126 Programming Exam 2
*/

public class ParkingMeter { 
    private static final int MINUTES_PER_HOUR = 60; // minutes in an hour
    private static final int MAX = 300; // maximum number of minutes == 5 hours

    private int time;                   // the time remaining in minutes
    private int rate;                   // cents per hour

    // create a new parking meter at specified time
    public ParkingMeter(int rate, int time) {
        if (rate <= 0 || rate > 99) 
            throw new IllegalArgumentException("rate must be between 1 and 99");
        if (time < 0 || time > MAX) 
            throw new IllegalArgumentException("inital time between 0 and 300");
        this.time = time;
        this.rate = rate;
    }

    // add money
    public int insert(int cents) {
        if (cents <= 0)
            throw new IllegalArgumentException("cents must by > 0");
        int delta = (int) (Math.floor((double) cents / rate * MINUTES_PER_HOUR));

        int oldTime = time; // save original time
        int maxTime = MAX;
        if (oldTime + delta > maxTime) {
            time = maxTime;
            delta = maxTime - oldTime;
        }
        else 
            time = oldTime + delta;
        return delta;
    }
    // could use if-else statements to prepend leadings zeros
    public String toString() {
        return String.format("%02d:%02d $.%02d",
                             getHours(), getMinutes(), rate);
    }

    // return the hour
    private int getHours() {
        return time / MINUTES_PER_HOUR;
    }

    // return the minutes
    private int getMinutes() {
        return time % MINUTES_PER_HOUR;
    }

    public boolean lessTime(ParkingMeter that) {
        return this.time < that.time;
    }

    // Decrements the parking meter by one (1)                                                                      // minute and returns the remaining minutes. 
    public int tic() {
        time--;
        if (time == -1) time = 0;
        return time;
    }


    public static void main(String[] args) {
        int rateInCents = Integer.parseInt(args[0]);
        int initialTime = Integer.parseInt(args[1]);
        int cents = Integer.parseInt(args[2]);

        ParkingMeter pm1 = new ParkingMeter(rateInCents, initialTime);
        StdOut.println(pm1);

        StdOut.printf("Insert %02d cents\n", cents);
        StdOut.printf("Adding %02d minutes\n", pm1.insert(cents));
        StdOut.println(pm1);
        StdOut.printf("Tic returns %02d minutes\n", pm1.tic());
        StdOut.println(pm1);

    }
}
