/********************************************************************************
 *  Checks that main() is the last declared method.
 *  (Written by ChatGPT with a bit of prompting to fix bugs by Kevin Wayne.)
 ********************************************************************************/
package edu.princeton.cs.lift.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.ArrayList;
import java.util.List;

public class MainMethodIsLastCheck extends AbstractCheck {

    private static final String MSG_KEY = "main.method.not.last";

    @Override
    public int[] getDefaultTokens() {
        return new int[] { TokenTypes.CLASS_DEF };
    }

    @Override
    public int[] getAcceptableTokens() {
        return getDefaultTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST classDef) {
        DetailAST objBlock = classDef.findFirstToken(TokenTypes.OBJBLOCK);

        if (objBlock == null) {
            return;
        }

        List<DetailAST> methods = new ArrayList<>();
        DetailAST child = objBlock.getFirstChild();

        while (child != null) {
            if (child.getType() == TokenTypes.METHOD_DEF) {
                methods.add(child);
            }
            child = child.getNextSibling();
        }

        if (methods.isEmpty()) {
            return;
        }

        int mainIndex = -1;
        for (int i = 0; i < methods.size(); i++) {
            if (Utilities.isMainMethod(methods.get(i))) {
                mainIndex = i;
                break;
            }
        }

        if (mainIndex != -1 && mainIndex != methods.size() - 1) {
            log(methods.get(mainIndex).getLineNo(), MSG_KEY);
        }
    }

    @Override
    public boolean isCommentNodesRequired() {
        return false;
    }
}
