/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.lang;

import edu.princeton.toy.lang.TWord;

public class TWordBuffer
implements Cloneable {
    private static Object idLock = new Object();
    private static int idCtr = 0;
    private int id;
    private TWord[] array;
    private int size = 0;

    public TWordBuffer() {
        this(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TWordBuffer(int capacity) {
        this.array = new TWord[capacity];
        Object object = idLock;
        synchronized (object) {
            this.id = idCtr++;
        }
    }

    public synchronized Object clone() {
        TWordBuffer clone = new TWordBuffer(this.size);
        clone.add(this);
        return clone;
    }

    public synchronized void clear() {
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TWordBuffer buffer) {
        TWordBuffer secondBuffer;
        TWordBuffer firstBuffer;
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (this.id > buffer.id) {
            firstBuffer = this;
            secondBuffer = buffer;
        } else {
            firstBuffer = buffer;
            secondBuffer = this;
        }
        TWordBuffer tWordBuffer = firstBuffer;
        synchronized (tWordBuffer) {
            TWordBuffer tWordBuffer2 = secondBuffer;
            synchronized (tWordBuffer2) {
                this.add(buffer.array, 0, buffer.size);
            }
        }
    }

    public synchronized void add(TWord[] array) {
        this.add(array, 0, array.length);
    }

    public synchronized void add(TWord[] array, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        TWord[] thisArray = this.array;
        if (this.size + length > thisArray.length) {
            this.expandArray(3 * (this.size + length) / 2);
            thisArray = this.array;
        }
        for (int ctr = 0; ctr < length; ++ctr) {
            thisArray[this.size + ctr] = array[offset + ctr];
        }
        this.size += length;
    }

    public synchronized void add(TWord word) {
        if (word == null) {
            throw new NullPointerException();
        }
        if (this.array.length == this.size) {
            this.expandArray();
        }
        this.array[this.size] = word;
        ++this.size;
    }

    public synchronized TWord pop() {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        TWord word = this.array[0];
        for (int ctr = 1; ctr < this.size; ++ctr) {
            this.array[ctr - 1] = this.array[ctr];
        }
        --this.size;
        return word;
    }

    public TWord getWord(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public int getSize() {
        return this.size;
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TWordBuffer) {
            TWordBuffer buffer = (TWordBuffer)obj;
            int size = buffer.size;
            if (buffer.size != this.size) {
                return false;
            }
            TWord[] bufferArray = buffer.array;
            TWord[] thisArray = this.array;
            for (int ctr = 0; ctr < size; ++ctr) {
                if (bufferArray[ctr] == thisArray[ctr]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void expandArray() {
        this.expandArray(2 * this.array.length + 1);
    }

    private void expandArray(int minimumCapacity) {
        int size = this.size;
        TWord[] oldArray = this.array;
        this.array = new TWord[Math.max(minimumCapacity, size)];
        TWord[] newArray = this.array;
        for (int ctr = 0; ctr < size; ++ctr) {
            newArray[ctr] = oldArray[ctr];
        }
    }
}

