/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.lang;

import edu.princeton.toy.lang.TException;
import edu.princeton.toy.lang.TExceptionHandler;
import edu.princeton.toy.lang.TExceptionType;
import edu.princeton.toy.lang.TWord;
import edu.princeton.toy.lang.TWordBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TVirtualMachine {
    public static final int MEM_COUNT = 256;
    public static final int REGISTER_COUNT = 16;
    public static final TWord PC_START = TWord.getWord((short)16);
    public static final short PC_START_VALUE = PC_START.getValue();
    private List changeListeners = new ArrayList();
    private TWord programCtr;
    private TWord[] mem = new TWord[256];
    private TWord[] registers = new TWord[16];
    private TWordBuffer unconsumedStdin = new TWordBuffer();
    private TWordBuffer consumedStdin = new TWordBuffer();
    private TWordBuffer stdout = new TWordBuffer();
    private StringBuffer stderr = new StringBuffer();
    private TExceptionHandler exceptionHandler = TExceptionHandler.PRUDISH_EXCEPTION_HANDLER;
    private boolean needsInput = false;
    private boolean done = false;
    private Runner runner = new Runner();

    public TVirtualMachine() {
        this.reset();
    }

    public void finalize() throws Throwable {
        this.runner.interrupted = true;
        super.finalize();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.changeListeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.changeListeners.remove(listener);
    }

    public boolean hasEncounteredError() {
        return this.stderr.length() > 0;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean needsInput() {
        return this.needsInput;
    }

    public boolean getDistinguishUninitialized() {
        for (int ctr = 0; ctr < TExceptionType.TYPES.length; ++ctr) {
            TExceptionType type = TExceptionType.TYPES[ctr];
            if (type.getFamily() != 0 || this.exceptionHandler.getWillThrow(type)) continue;
            return false;
        }
        return true;
    }

    public TExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(TExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.exceptionHandler = exceptionHandler;
    }

    public TWord getProgramCtr() {
        return this.programCtr;
    }

    public synchronized void setProgramCtr(TWord programCtr) {
        if (programCtr == this.programCtr) {
            return;
        }
        this.programCtr = programCtr;
        this.done = false;
        this.fireStateChanged();
    }

    public TWord getRegister(int index) {
        return this.registers[index];
    }

    public synchronized void setRegister(int index, TWord word) {
        if (word == null) {
            throw new NullPointerException();
        }
        if (this.registers[index] == word) {
            return;
        }
        this.registers[index] = word;
        this.fireStateChanged();
    }

    public TWord getCurrentInstruction() {
        return this.mem[this.programCtr.getValue() & 0xFF];
    }

    public void getMem(TWord[] array) {
        if (array.length < 256) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int ctr = 0; ctr < 256; ++ctr) {
            array[ctr] = this.mem[ctr];
        }
    }

    public TWord getMem(int index) {
        return this.mem[index];
    }

    public synchronized void setMem(int index, TWord word) {
        if (word == null) {
            throw new NullPointerException();
        }
        if (this.mem[index] == word) {
            return;
        }
        this.mem[index] = word;
        this.fireStateChanged();
    }

    public synchronized void initMem(TWord[] words) {
        if (words.length != 256) {
            throw new IllegalArgumentException();
        }
        for (int ctr = 0; ctr < 256; ++ctr) {
            if (words[ctr] == null) {
                throw new NullPointerException();
            }
            this.mem[ctr] = words[ctr];
        }
        this.fireStateChanged();
    }

    public TWordBuffer getConsumedStdin() {
        return (TWordBuffer)this.consumedStdin.clone();
    }

    public TWordBuffer getConsumedStdin(TWordBuffer buffer) {
        buffer.clear();
        buffer.add(this.consumedStdin);
        return buffer;
    }

    public TWordBuffer getUnconsumedStdin() {
        return (TWordBuffer)this.unconsumedStdin.clone();
    }

    public TWordBuffer getUnconsumedStdin(TWordBuffer buffer) {
        buffer.clear();
        buffer.add(this.unconsumedStdin);
        return buffer;
    }

    public synchronized void setStdin(TWordBuffer unconsumedStdin) {
        this.consumedStdin.clear();
        this.setStdin(this.consumedStdin, unconsumedStdin);
    }

    public synchronized void setStdin(TWordBuffer consumedStdin, TWordBuffer unconsumedStdin) {
        if (consumedStdin != null && consumedStdin != this.consumedStdin) {
            this.consumedStdin.clear();
            this.consumedStdin.add(consumedStdin);
        }
        if (unconsumedStdin != null && unconsumedStdin != this.unconsumedStdin) {
            this.unconsumedStdin.clear();
            this.unconsumedStdin.add(unconsumedStdin);
        }
        if (this.needsInput && unconsumedStdin.getSize() > 0) {
            this.needsInput = false;
        }
        this.fireStateChanged();
    }

    public TWordBuffer getStdout() {
        return (TWordBuffer)this.stdout.clone();
    }

    public TWordBuffer getStdout(TWordBuffer buffer) {
        buffer.clear();
        buffer.add(this.stdout);
        return buffer;
    }

    public String getStderr() {
        return this.stderr.toString();
    }

    public String getMemDump() {
        StringBuffer buffer = new StringBuffer();
        boolean printedPreviousLine = false;
        for (int ctr = 0; ctr < 256; ctr = (int)((short)(ctr + 1))) {
            if (this.mem[ctr].isInitialized()) {
                buffer.append(TWord.HEX_PAIRS[ctr]);
                buffer.append(": ");
                buffer.append(this.mem[ctr].toHexString(false));
                buffer.append('\n');
                printedPreviousLine = true;
                continue;
            }
            if (!printedPreviousLine) continue;
            buffer.append('\n');
            printedPreviousLine = false;
        }
        int length = buffer.length();
        if (!printedPreviousLine && length > 0) {
            buffer.setLength(length - 1);
        }
        return buffer.toString();
    }

    public String getCoreDump() {
        return this.getCoreDump(this.getDistinguishUninitialized());
    }

    public String getCoreDump(boolean distinguishUninitialized) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("// State:\n");
        buffer.append("PC: ");
        buffer.append(this.programCtr);
        buffer.append('\n');
        buffer.append("IR: ");
        TWord ir = this.mem[this.programCtr.getValue() & 0xFF];
        buffer.append(ir.toHexString(distinguishUninitialized));
        buffer.append(" (");
        buffer.append(ir.toPseudoCodeString(distinguishUninitialized));
        buffer.append(")\n\n");
        buffer.append("// Registers:\n");
        for (int ctr = 0; ctr < 16; ctr = (int)((short)(ctr + 1))) {
            buffer.append("R[");
            buffer.append(TWord.HEX_DIGITS[ctr]);
            buffer.append("]: ");
            buffer.append(this.registers[ctr].toString(distinguishUninitialized));
            buffer.append('\n');
        }
        buffer.append('\n');
        boolean printedPreviousLine = true;
        buffer.append("// Memory:\n");
        for (short ctr = 0; ctr < 256; ctr = (short)((short)(ctr + 1))) {
            if (this.mem[ctr].isInitialized()) {
                buffer.append("M[");
                buffer.append(TWord.HEX_PAIRS[ctr]);
                buffer.append("]: ");
                if (ctr < PC_START_VALUE) {
                    buffer.append(this.mem[ctr].toString(false));
                    buffer.append('\n');
                } else {
                    buffer.append(this.mem[ctr].toHexString(false));
                    buffer.append(" (");
                    buffer.append(this.mem[ctr].toPseudoCodeString(false));
                    buffer.append(")\n");
                }
                printedPreviousLine = true;
                continue;
            }
            if (!printedPreviousLine) continue;
            buffer.append("...\n");
            printedPreviousLine = false;
        }
        return buffer.toString();
    }

    public synchronized void reset() {
        int ctr;
        this.programCtr = PC_START;
        for (ctr = 0; ctr < 256; ++ctr) {
            this.mem[ctr] = TWord.UNINITIALIZED_VALUE;
        }
        this.registers[0] = TWord.ZERO;
        for (ctr = 1; ctr < 16; ++ctr) {
            this.registers[ctr] = TWord.UNINITIALIZED_VALUE;
        }
        this.unconsumedStdin.clear();
        this.consumedStdin.clear();
        this.stdout.clear();
        this.stderr.setLength(0);
        this.needsInput = false;
        this.done = false;
        this.fireStateChanged();
    }

    protected void fireStateChanged() {
        if (!this.changeListeners.isEmpty()) {
            ChangeEvent e = new ChangeEvent(this);
            Object[] array = this.changeListeners.toArray();
            for (int ctr = 0; ctr < array.length; ++ctr) {
                ((ChangeListener)array[ctr]).stateChanged(e);
            }
        }
    }

    public void interrupt() {
        this.runner.interrupted = true;
    }

    public boolean isRunning() {
        return this.runner.isRunning;
    }

    public synchronized int step() {
        if (this.done || this.needsInput) {
            return 0;
        }
        if (!this.runner.isRunning) {
            this.stepImpl();
            this.fireStateChanged();
            if (this.needsInput) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public synchronized boolean run(ExecutionController controller) {
        if (controller == null) {
            throw new NullPointerException();
        }
        if (this.done || this.needsInput || this.runner.isRunning) {
            return false;
        }
        this.runner.start(controller);
        this.fireStateChanged();
        return true;
    }

    private void stepImpl() {
        TWord oldProgramCtr = this.programCtr.initializedValue();
        try {
            TWord currentInstruction = this.mem[this.programCtr.getValue() & 0xFF];
            if (!currentInstruction.isInitialized()) {
                this.exceptionHandler.raise(TExceptionType.COMMAND_UNINITIALIZED);
            }
            byte op = currentInstruction.getOp();
            byte d = currentInstruction.getD();
            byte s = currentInstruction.getS();
            byte t = currentInstruction.getT();
            short imm = currentInstruction.getImm();
            this.programCtr = TWord.add(this.programCtr, TWord.ONE, null);
            if (imm == 255 && op == 8 || (this.registers[t].getValue() & 0xFF) == 255 && op == 10) {
                if (this.unconsumedStdin.getSize() > 0) {
                    this.mem[255] = this.unconsumedStdin.pop();
                    this.consumedStdin.add(this.mem[255]);
                } else {
                    this.needsInput = true;
                    this.programCtr = oldProgramCtr;
                    return;
                }
            }
            switch (op) {
                case 0: {
                    this.programCtr = oldProgramCtr;
                    this.done = true;
                    break;
                }
                case 1: {
                    if (d == 0 && (s != 0 || t != 0)) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.add(this.registers[s], this.registers[t], this.exceptionHandler);
                    break;
                }
                case 2: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.subtract(this.registers[s], this.registers[t], this.exceptionHandler);
                    break;
                }
                case 3: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.and(this.registers[s], this.registers[t], this.exceptionHandler);
                    break;
                }
                case 4: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.xor(this.registers[s], this.registers[t], this.exceptionHandler);
                    break;
                }
                case 5: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.leftShift(this.registers[s], this.registers[t], this.exceptionHandler);
                    break;
                }
                case 6: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.rightShift(this.registers[s], this.registers[t], this.exceptionHandler);
                    break;
                }
                case 7: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = TWord.getWord(imm);
                    break;
                }
                case 8: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    if (!this.mem[imm].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.MEMORY_UNINITIALIZED);
                    }
                    this.registers[d] = this.mem[imm].initializedValue();
                    break;
                }
                case 9: {
                    if (!this.registers[d].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    this.mem[imm] = this.registers[d].initializedValue();
                    break;
                }
                case 10: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    if (!this.registers[t].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    if (this.registers[t].getValue() < 0 || this.registers[t].getValue() > 256) {
                        this.exceptionHandler.raise(TExceptionType.MEM_OUT_OF_BOUNDS);
                    }
                    if (!this.mem[this.registers[t].getValue() & 0xFF].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.MEMORY_UNINITIALIZED);
                    }
                    this.registers[d] = this.mem[this.registers[t].getValue() & 0xFF].initializedValue();
                    break;
                }
                case 11: {
                    if (!this.registers[t].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    if (this.registers[t].getValue() < 0 || this.registers[t].getValue() >= 256) {
                        this.exceptionHandler.raise(TExceptionType.MEM_OUT_OF_BOUNDS);
                    }
                    if (!this.registers[d].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    this.mem[this.registers[t].getValue() & 0xFF] = this.registers[d].initializedValue();
                    break;
                }
                case 12: {
                    if (!this.registers[d].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    if (this.registers[d].getValue() != 0) break;
                    this.programCtr = TWord.getWord(imm);
                    break;
                }
                case 13: {
                    if (!this.registers[d].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    if (this.registers[d].getValue() <= 0) break;
                    this.programCtr = TWord.getWord(imm);
                    break;
                }
                case 14: {
                    if (!this.registers[d].isInitialized()) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
                    }
                    this.programCtr = this.registers[d].initializedValue();
                    break;
                }
                case 15: {
                    if (d == 0) {
                        this.exceptionHandler.raise(TExceptionType.REGISTER_OUT_OF_BOUNDS);
                    }
                    this.registers[d] = this.programCtr.initializedValue();
                    this.programCtr = TWord.getWord(imm);
                }
            }
            if (imm == 255 && op == 9 || (this.registers[t].getValue() & 0xFF) == 255 && op == 11) {
                this.stdout.add(this.mem[255]);
            }
            this.registers[0] = TWord.ZERO;
            if (this.programCtr.getValue() <= 0 || this.programCtr.getValue() > 256) {
                this.exceptionHandler.raise(TExceptionType.PC_OUT_OF_BOUNDS);
                this.programCtr = TWord.getWord((short)(this.programCtr.getValue() & 0xFF));
            }
        }
        catch (TException e) {
            this.programCtr = oldProgramCtr;
            this.stderr.append("A runtime error has occurred at address ");
            this.stderr.append(TWord.HEX_PAIRS[this.programCtr.getValue() & 0xFF]);
            this.stderr.append(":\n");
            this.stderr.append(e.getType().getDescription());
            this.done = true;
        }
    }

    protected class Runner
    implements Runnable {
        protected boolean isRunning = false;
        protected boolean interrupted;
        private ExecutionController controller;
        private Thread thread;

        protected Runner() {
        }

        public void start(ExecutionController controller) {
            this.isRunning = true;
            this.thread = new Thread(this);
            this.controller = controller;
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TVirtualMachine tVirtualMachine = TVirtualMachine.this;
            synchronized (tVirtualMachine) {
                this.interrupted = false;
                TVirtualMachine virtualMachine = TVirtualMachine.this;
                ExecutionController controller = this.controller;
                boolean willStop = TVirtualMachine.this.done || TVirtualMachine.this.needsInput || this.interrupted;
                int n = controller.statusUpdate(virtualMachine, 0, 0, willStop);
                long startTime = System.currentTimeMillis();
                while (n > 0 && !willStop) {
                    int ctr;
                    int clockPeriod = controller.getClockPeriod();
                    for (ctr = 0; !(ctr >= n || TVirtualMachine.this.done || TVirtualMachine.this.needsInput || this.interrupted); ++ctr) {
                        TVirtualMachine.this.stepImpl();
                    }
                    if (ctr > 0 && TVirtualMachine.this.needsInput) {
                        --ctr;
                    }
                    try {
                        long stopSleepTime = startTime + (long)(ctr * clockPeriod);
                        int remainingTime = Math.max(100, (int)(stopSleepTime - System.currentTimeMillis()));
                        while (remainingTime > 10 && !this.interrupted) {
                            Thread.sleep(Math.min(100, remainingTime));
                            remainingTime = (int)(stopSleepTime - System.currentTimeMillis());
                        }
                    }
                    catch (InterruptedException e) {
                        this.interrupted = true;
                        e.printStackTrace();
                    }
                    long endTime = System.currentTimeMillis();
                    TVirtualMachine.this.fireStateChanged();
                    willStop = TVirtualMachine.this.done || TVirtualMachine.this.needsInput || this.interrupted;
                    n = controller.statusUpdate(virtualMachine, ctr, (int)(endTime - startTime), willStop);
                    startTime = endTime;
                }
                if (n < 0) {
                    new IllegalArgumentException().printStackTrace();
                }
                this.isRunning = false;
                TVirtualMachine.this.fireStateChanged();
                this.thread = null;
            }
        }
    }

    public static interface ExecutionController {
        public int statusUpdate(TVirtualMachine var1, int var2, int var3, boolean var4);

        public int getClockPeriod();
    }
}

