/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.choosers;

import edu.princeton.swing.PList;
import edu.princeton.swing.text.HighlightStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TStyleChooserPane
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String CLASS_STRING = TStyleChooserPane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final String CHANGE_COMMAND = CLASS_STRING + "#changeCommand";
    private static final Border BLACK_BORDER = LineBorder.createBlackLineBorder();
    private static final Border ETCHED_BORDER = new EtchedBorder();
    private PList styleList;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JButton changeButton;
    private JCheckBox boldCheckbox;
    private JCheckBox italicCheckbox;
    private HighlightStyle[] styles;
    private Color[] colors;
    private boolean[] bold;
    private boolean[] italic;
    private String[] styleNames;

    public TStyleChooserPane(String[] styleNames) {
        super(new GridBagLayout());
        int length = styleNames.length;
        this.styleNames = new String[length];
        this.styles = new HighlightStyle[length];
        this.colors = new Color[length];
        this.bold = new boolean[length];
        this.italic = new boolean[length];
        for (int ctr = 0; ctr < length; ++ctr) {
            this.styleNames[ctr] = styleNames[ctr];
        }
        JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.setBorder(ETCHED_BORDER);
        this.styleList = new PList(this.styleNames);
        this.styleList.setSelectionMode(0);
        this.styleList.setSelectedIndex(0);
        this.styleList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.styleList, 22, 30);
        Dimension preferredSize = scrollPane.getPreferredSize();
        preferredSize.width = 150;
        scrollPane.setPreferredSize(preferredSize);
        innerPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 5, 0.0, 2.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.previewLabel = new JLabel("Current color");
        innerPanel.add((Component)this.previewLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.previewPanel = new JPanel();
        this.previewPanel.setPreferredSize(new Dimension(100, 100));
        this.previewPanel.setBorder(BLACK_BORDER);
        innerPanel.add((Component)this.previewPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 15, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.changeButton = new JButton("Change...");
        this.changeButton.setActionCommand(CHANGE_COMMAND);
        this.changeButton.addActionListener(this);
        innerPanel.add((Component)this.changeButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 11, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.boldCheckbox = new JCheckBox("Bold");
        this.boldCheckbox.setActionCommand(UPDATE_COMMAND);
        this.boldCheckbox.addActionListener(this);
        innerPanel.add((Component)this.boldCheckbox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.italicCheckbox = new JCheckBox("Italic");
        this.italicCheckbox.setActionCommand(UPDATE_COMMAND);
        this.italicCheckbox.addActionListener(this);
        innerPanel.add((Component)this.italicCheckbox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)innerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(50, 25, 50, 25), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
    }

    public HighlightStyle getStyle(int index) {
        if (this.styles[index] == null) {
            this.styles[index] = new HighlightStyle(this.colors[index], this.bold[index], this.italic[index]);
        }
        return this.styles[index];
    }

    public void setStyle(HighlightStyle style, int index) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.styles[index] = style;
        this.colors[index] = style.getColor();
        this.bold[index] = style.isBold();
        this.italic[index] = style.isItalic();
        if (this.styleList.getSelectedIndex() == index) {
            this.doCommand(UPDATE_COMMAND, null);
        }
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            int index = this.styleList.getSelectedIndex();
            if (index == -1) {
                index = 0;
                this.styleList.setSelectedIndex(0);
            }
            this.previewPanel.setBackground(this.colors[index]);
            this.boldCheckbox.getModel().setSelected(this.bold[index]);
            this.italicCheckbox.getModel().setSelected(this.italic[index]);
            return true;
        }
        if (command == CHANGE_COMMAND) {
            Container comp;
            int index = this.styleList.getSelectedIndex();
            if (index == -1) {
                index = 0;
                this.styleList.setSelectedIndex(0);
            }
            for (comp = this; comp != null && !(comp instanceof Window); comp = comp.getParent()) {
            }
            Color selection = JColorChooser.showDialog(comp, "Color selection for " + this.styleNames[index], this.colors[index]);
            if (selection != null && !this.colors[index].equals(selection)) {
                this.colors[index] = selection;
                this.styles[index] = null;
            }
            this.doCommand(UPDATE_COMMAND, null);
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.styleList.getSelectedIndex();
        if (index != -1) {
            if (this.bold[index] != this.boldCheckbox.getModel().isSelected()) {
                this.bold[index] = !this.bold[index];
                this.styles[index] = null;
            }
            if (this.italic[index] != this.italicCheckbox.getModel().isSelected()) {
                this.italic[index] = !this.italic[index];
                this.styles[index] = null;
            }
        }
        this.doCommand(e.getActionCommand(), null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.doCommand(UPDATE_COMMAND, null);
    }
}

