/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.choosers;

import edu.princeton.swing.PTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TPerformanceChooserPane
extends JPanel
implements ChangeListener {
    private static final String CLASS_STRING = TPerformanceChooserPane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    private int[] clockPeriods;
    private int[] refreshRates;
    private JSlider clockPeriodSlider;
    private JSlider refreshRateSlider;
    private PTextField clockPeriodTextField;
    private PTextField refreshRateTextField;

    public TPerformanceChooserPane(int[] clockPeriods, int[] refreshRates) {
        super(new GridBagLayout());
        int ctr;
        this.clockPeriods = new int[clockPeriods.length];
        this.refreshRates = new int[refreshRates.length];
        for (ctr = 0; ctr < clockPeriods.length; ++ctr) {
            this.clockPeriods[ctr] = clockPeriods[ctr];
        }
        Arrays.sort(this.clockPeriods);
        for (ctr = 0; ctr < refreshRates.length; ++ctr) {
            this.refreshRates[ctr] = refreshRates[ctr];
        }
        Arrays.sort(this.refreshRates);
        this.add((Component)new JLabel("Target Clock Period"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.clockPeriodTextField = new PTextField(12);
        this.clockPeriodTextField.setEditable(false);
        this.clockPeriodTextField.setBackground(null);
        this.clockPeriodTextField.setDisabledTextColor(Color.black);
        this.add((Component)this.clockPeriodTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.clockPeriodSlider = new JSlider(0, 0, clockPeriods.length - 1, 7);
        this.clockPeriodSlider.setMinorTickSpacing(1);
        this.clockPeriodSlider.setMajorTickSpacing(10);
        this.clockPeriodSlider.setPaintTicks(true);
        this.clockPeriodSlider.setPaintTrack(true);
        this.clockPeriodSlider.setSnapToTicks(true);
        this.clockPeriodSlider.addChangeListener(this);
        this.add((Component)this.clockPeriodSlider, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Refresh Rate"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.refreshRateTextField = new PTextField(12);
        this.refreshRateTextField.setEditable(false);
        this.refreshRateTextField.setBackground(null);
        this.refreshRateTextField.setDisabledTextColor(Color.black);
        this.add((Component)this.refreshRateTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.refreshRateSlider = new JSlider(0, 0, refreshRates.length - 1, 7);
        this.refreshRateSlider.setMinorTickSpacing(1);
        this.refreshRateSlider.setMajorTickSpacing(10);
        this.refreshRateSlider.setPaintTicks(true);
        this.refreshRateSlider.setPaintTrack(true);
        this.refreshRateSlider.setSnapToTicks(true);
        this.refreshRateSlider.addChangeListener(this);
        this.add((Component)this.refreshRateSlider, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("* spr = steps per refresh"), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 16, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public int getClockPeriod() {
        return this.clockPeriods[this.clockPeriodSlider.getValue()];
    }

    public void setClockPeriod(int clockPeriod) {
        int index;
        for (index = 0; index < this.clockPeriods.length && this.clockPeriods[index] < clockPeriod; ++index) {
        }
        if (index == 0) {
            this.clockPeriodSlider.setValue(0);
        } else if (index < this.clockPeriods.length) {
            if (this.clockPeriods[index] - clockPeriod < clockPeriod - this.clockPeriods[index - 1]) {
                this.clockPeriodSlider.setValue(index);
            } else {
                this.clockPeriodSlider.setValue(index - 1);
            }
        } else {
            this.clockPeriodSlider.setValue(this.clockPeriods.length - 1);
        }
    }

    public int getRefreshRate() {
        return this.refreshRates[this.refreshRateSlider.getValue()];
    }

    public void setRefreshRate(int refreshRate) {
        int index;
        for (index = 0; index < this.refreshRates.length && this.refreshRates[index] < refreshRate; ++index) {
        }
        if (index == 0) {
            this.refreshRateSlider.setValue(0);
        } else if (index < this.refreshRates.length) {
            if (this.refreshRates[index] - refreshRate < refreshRate - this.refreshRates[index - 1]) {
                this.refreshRateSlider.setValue(index);
            } else {
                this.refreshRateSlider.setValue(index - 1);
            }
        } else {
            this.refreshRateSlider.setValue(this.refreshRates.length - 1);
        }
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            this.clockPeriodTextField.setText(this.clockPeriods[this.clockPeriodSlider.getValue()] + " ms");
            this.refreshRateTextField.setText(this.refreshRates[this.refreshRateSlider.getValue()] + " spr*");
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.doCommand(UPDATE_COMMAND, null);
    }
}

