/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.choosers;

import edu.princeton.swing.PList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TFontChooserPane
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String CLASS_STRING;
    public static final String UPDATE_COMMAND;
    public static final String[] FONT_FAMILIES;
    public static final String[] FONT_STYLES;
    public static final int[] FONT_STYLE_MASKS;
    public static final int[] FONT_SIZES;
    private JComboBox areaComboBox;
    private PList fontList;
    private PList styleList;
    private PList sizeList;
    private JLabel previewLabel;
    private int areaCount;
    private String[] fontAreas;
    private int[] familyIndices;
    private int[] styleIndices;
    private int[] sizeIndices;
    private Font[] fonts;
    private boolean ignoreUpdate;

    public TFontChooserPane(String[] fontAreas) {
        super(new GridBagLayout());
        int areaCount = fontAreas.length;
        this.fontAreas = new String[areaCount];
        for (int ctr = 0; ctr < areaCount; ++ctr) {
            if (fontAreas[ctr] == null) {
                throw new NullPointerException();
            }
            this.fontAreas[ctr] = fontAreas[ctr];
        }
        this.areaCount = areaCount;
        this.familyIndices = new int[areaCount];
        this.styleIndices = new int[areaCount];
        this.sizeIndices = new int[areaCount];
        this.fonts = new Font[areaCount];
        this.ignoreUpdate = false;
        this.add((Component)new JLabel("Area"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.areaComboBox = new JComboBox<String>(this.fontAreas);
        this.areaComboBox.addActionListener(this);
        this.add((Component)this.areaComboBox, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Font"), new GridBagConstraints(0, 1, 2, 1, 2.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Style"), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Size"), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.fontList = new PList(FONT_FAMILIES);
        this.fontList.setSelectionMode(0);
        this.fontList.setSelectedIndex(0);
        this.fontList.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.fontList, 22, 30), new GridBagConstraints(0, 2, 2, 2, 2.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.styleList = new PList(FONT_STYLES);
        this.styleList.setSelectionMode(0);
        this.styleList.setSelectedIndex(0);
        this.styleList.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.styleList, 22, 30), new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        Object[] objectArray = new Integer[FONT_SIZES.length];
        for (int ctr = 0; ctr < objectArray.length; ++ctr) {
            objectArray[ctr] = new Integer(FONT_SIZES[ctr]);
        }
        this.sizeList = new PList(objectArray);
        this.sizeList.setSelectionMode(0);
        this.sizeList.setSelectedIndex(0);
        this.sizeList.addListSelectionListener(this);
        this.add((Component)new JScrollPane(this.sizeList, 22, 30), new GridBagConstraints(3, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.previewLabel = new JLabel("AaBb YyZz 123", 0);
        this.previewLabel.setMinimumSize(new Dimension(140, 100));
        this.previewLabel.setPreferredSize(new Dimension(140, 100));
        this.previewLabel.setBorder(new EtchedBorder());
        this.add((Component)this.previewLabel, new GridBagConstraints(2, 3, 2, 1, 2.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
    }

    public Font getFont(int areaIndex) {
        return this.fonts[areaIndex];
    }

    public void setFont(Font font, int areaIndex) {
        this.setFont(font.getFamily(), font.isBold(), font.isItalic(), font.getSize(), areaIndex);
    }

    public synchronized void setFont(String family, boolean bold, boolean italic, int size, int areaIndex) {
        if (areaIndex < 0 || areaIndex >= this.areaCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = -1;
        if (family != null) {
            for (int ctr = 0; ctr < FONT_FAMILIES.length && index == -1; ++ctr) {
                if (!FONT_FAMILIES[ctr].equalsIgnoreCase(family)) continue;
                index = ctr;
            }
        }
        this.familyIndices[areaIndex] = index == -1 ? 0 : index;
        this.styleIndices[areaIndex] = (bold ? 1 : 0) | (italic ? 2 : 0);
        for (index = 0; index < FONT_SIZES.length && FONT_SIZES[index] < size; ++index) {
        }
        this.sizeIndices[areaIndex] = index == FONT_SIZES.length ? FONT_SIZES.length - 1 : (index == 0 ? 0 : (FONT_SIZES[index] - size <= size - FONT_SIZES[index - 1] ? index : index - 1));
        if (this.areaComboBox.getSelectedIndex() == areaIndex) {
            this.doCommand(UPDATE_COMMAND, null);
            this.fontList.ensureIndexIsVisible(this.familyIndices[areaIndex]);
            this.styleList.ensureIndexIsVisible(this.styleIndices[areaIndex]);
            this.sizeList.ensureIndexIsVisible(this.sizeIndices[areaIndex]);
        } else {
            this.fonts[areaIndex] = new Font(FONT_FAMILIES[this.familyIndices[areaIndex]], FONT_STYLE_MASKS[this.styleIndices[areaIndex]], FONT_SIZES[this.sizeIndices[areaIndex]]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            this.ignoreUpdate = true;
            try {
                int areaIndex = this.areaComboBox.getSelectedIndex();
                if (areaIndex == -1) {
                    areaIndex = 0;
                    this.areaComboBox.setSelectedIndex(0);
                }
                this.fontList.setSelectedIndex(this.familyIndices[areaIndex]);
                this.styleList.setSelectedIndex(this.styleIndices[areaIndex]);
                this.sizeList.setSelectedIndex(this.sizeIndices[areaIndex]);
                this.fonts[areaIndex] = new Font(FONT_FAMILIES[this.familyIndices[areaIndex]], FONT_STYLE_MASKS[this.styleIndices[areaIndex]], FONT_SIZES[this.sizeIndices[areaIndex]]);
                this.previewLabel.setFont(this.fonts[areaIndex]);
            }
            finally {
                this.ignoreUpdate = false;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignoreUpdate) {
            return;
        }
        int areaIndex = this.areaComboBox.getSelectedIndex();
        this.doCommand(UPDATE_COMMAND, null);
        if (areaIndex != -1) {
            this.fontList.ensureIndexIsVisible(this.familyIndices[areaIndex]);
            this.styleList.ensureIndexIsVisible(this.styleIndices[areaIndex]);
            this.sizeList.ensureIndexIsVisible(this.sizeIndices[areaIndex]);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.ignoreUpdate) {
            return;
        }
        int areaIndex = this.areaComboBox.getSelectedIndex();
        if (areaIndex != -1) {
            int index = this.fontList.getSelectedIndex();
            if (index != -1) {
                this.familyIndices[areaIndex] = index;
            }
            if ((index = this.styleList.getSelectedIndex()) != -1) {
                this.styleIndices[areaIndex] = index;
            }
            if ((index = this.sizeList.getSelectedIndex()) != -1) {
                this.sizeIndices[areaIndex] = index;
            }
        }
        this.doCommand(UPDATE_COMMAND, null);
    }

    static {
        int ctr;
        CLASS_STRING = TFontChooserPane.class.toString();
        UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
        FONT_FAMILIES = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        FONT_STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
        FONT_STYLE_MASKS = new int[]{0, 1, 2, 3};
        FONT_SIZES = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
        int index = -1;
        for (ctr = 0; ctr < FONT_FAMILIES.length && index == -1; ++ctr) {
            if (!"Default".equals(FONT_FAMILIES[ctr])) continue;
            index = ctr;
        }
        if (index != -1) {
            for (ctr = index; ctr > 0; --ctr) {
                TFontChooserPane.FONT_FAMILIES[ctr] = FONT_FAMILIES[ctr - 1];
            }
            TFontChooserPane.FONT_FAMILIES[0] = "Default";
        }
    }
}

