/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.choosers;

import edu.princeton.swing.PTree;
import edu.princeton.swing.PTristateCheckBox;
import edu.princeton.swing.TristateButtonModel;
import edu.princeton.toy.lang.TExceptionType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TExceptionChooserPane
extends JPanel
implements ChangeListener,
TreeSelectionListener {
    private static final String CLASS_STRING = TExceptionChooserPane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    private static final String rootLabel = "All Toy Exceptional Conditions";
    private static final int[][] familyMemberIndices = new int[TExceptionType.FAMILIES.length][];
    private static final Border UNFOCUSED_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = new LineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1);
    private static final Color SELECTION_FOREGROUND = UIManager.getColor("Tree.selectionForeground");
    private static final Color SELECTION_BACKGROUND = UIManager.getColor("Tree.selectionBackground");
    private boolean ignoreUpdate;
    private TristateButtonModel rootModel;
    private TristateButtonModel[] familyModels = new TristateButtonModel[TExceptionType.FAMILIES.length];
    private TristateButtonModel[] typeModels = new TristateButtonModel[TExceptionType.TYPES.length];
    private PTree exceptionTree;
    private JTextArea descriptionTextArea;

    public TExceptionChooserPane() {
        super(new GridBagLayout());
        int ctr;
        this.add((Component)new JLabel("Throwable Exceptions"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        CheckBoxCell cell = new CheckBoxCell(rootLabel);
        this.rootModel = cell.getModel();
        this.rootModel.addChangeListener(this);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(cell, true);
        for (ctr = 0; ctr < TExceptionType.FAMILIES.length; ++ctr) {
            cell = new CheckBoxCell(TExceptionType.FAMILIES[ctr]);
            this.familyModels[ctr] = cell.getModel();
            this.familyModels[ctr].addChangeListener(this);
            DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(cell, true);
            int[] memberIndices = familyMemberIndices[ctr];
            for (int ctr2 = 0; ctr2 < memberIndices.length; ++ctr2) {
                int index = memberIndices[ctr2];
                cell = new CheckBoxCell(TExceptionType.TYPES[index].getName());
                this.typeModels[index] = cell.getModel();
                this.typeModels[index].addChangeListener(this);
                familyNode.add(new DefaultMutableTreeNode(cell, false));
            }
            root.add(familyNode);
        }
        this.exceptionTree = new PTree(new DefaultTreeModel(root, true));
        this.exceptionTree.setShowsRootHandles(true);
        this.exceptionTree.putClientProperty("PTree.lineStyle", "Angled");
        this.exceptionTree.getSelectionModel().setSelectionMode(1);
        this.exceptionTree.addTreeSelectionListener(this);
        this.exceptionTree.setCellRenderer(new CheckBoxCellRenderer());
        this.exceptionTree.setCellEditor(new CheckBoxCellEditor());
        this.exceptionTree.setEditable(true);
        for (ctr = 0; ctr < this.exceptionTree.getRowCount(); ++ctr) {
            this.exceptionTree.expandRow(ctr);
        }
        this.add((Component)new JScrollPane(this.exceptionTree, 22, 30), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Description"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.descriptionTextArea = new JTextArea(4, 30);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setBackground(null);
        this.descriptionTextArea.setDisabledTextColor(Color.black);
        this.descriptionTextArea.setMinimumSize(new Dimension(100, 70));
        this.descriptionTextArea.setPreferredSize(new Dimension(100, 70));
        this.descriptionTextArea.setMargin(new Insets(2, 2, 2, 2));
        this.descriptionTextArea.setBorder(new EtchedBorder());
        this.add((Component)this.descriptionTextArea, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public boolean getWillThrow(int index) {
        return this.typeModels[index].isSelected();
    }

    public void setWillThrow(int index, boolean willThrow) {
        this.typeModels[index].setSelected(willThrow);
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            try {
                int ctr;
                this.ignoreUpdate = true;
                if (extraInfo == this.rootModel) {
                    int ctr2;
                    if (this.rootModel.isTristate()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean selected = this.rootModel.isSelected();
                    for (ctr2 = 0; ctr2 < TExceptionType.FAMILIES.length; ctr2 += 1) {
                        this.familyModels[ctr2].setSelected(selected);
                    }
                    for (ctr2 = 0; ctr2 < TExceptionType.TYPES.length; ctr2 += 1) {
                        this.typeModels[ctr2].setSelected(selected);
                    }
                    this.exceptionTree.repaint();
                    ctr2 = 1;
                    return ctr2 != 0;
                }
                for (ctr = 0; ctr < TExceptionType.FAMILIES.length; ++ctr) {
                    boolean ctr2;
                    if (this.familyModels[ctr] != extraInfo) continue;
                    if (this.familyModels[ctr].isTristate()) {
                        boolean ctr3 = false;
                        return ctr3;
                    }
                    boolean selected = this.familyModels[ctr].isSelected();
                    int[] memberIndices = familyMemberIndices[ctr];
                    for (int ctr22 = 0; ctr22 < memberIndices.length; ++ctr22) {
                        this.typeModels[memberIndices[ctr22]].setSelected(selected);
                    }
                    boolean tristate = false;
                    for (ctr2 = false; ctr2 < TExceptionType.FAMILIES.length && !tristate; ctr2 += 1) {
                        if (!this.familyModels[ctr2].isTristate() && this.familyModels[ctr2].isSelected() == selected) continue;
                        tristate = true;
                    }
                    if (tristate) {
                        this.rootModel.setTristate(true);
                    } else {
                        this.rootModel.setSelected(selected);
                    }
                    this.exceptionTree.repaint();
                    ctr2 = true;
                    return ctr2;
                }
                for (ctr = 0; ctr < TExceptionType.TYPES.length; ++ctr) {
                    int ctr2;
                    if (this.typeModels[ctr] != extraInfo) continue;
                    if (this.typeModels[ctr].isTristate()) {
                        throw new IllegalStateException();
                    }
                    boolean selected = this.typeModels[ctr].isSelected();
                    boolean tristate = false;
                    int family = TExceptionType.TYPES[ctr].getFamily();
                    int[] memberIndices = familyMemberIndices[family];
                    for (ctr2 = 0; ctr2 < memberIndices.length && !tristate; ++ctr2) {
                        if (this.typeModels[memberIndices[ctr2]].isSelected() == selected) continue;
                        tristate = true;
                    }
                    if (tristate) {
                        this.familyModels[family].setTristate(true);
                    } else {
                        this.familyModels[family].setSelected(selected);
                    }
                    for (ctr2 = 0; ctr2 < TExceptionType.FAMILIES.length && !tristate; ++ctr2) {
                        if (!this.familyModels[ctr2].isTristate() && this.familyModels[ctr2].isSelected() == selected) continue;
                        tristate = true;
                    }
                    if (tristate) {
                        this.rootModel.setTristate(true);
                    } else {
                        this.rootModel.setSelected(selected);
                    }
                    this.exceptionTree.repaint();
                    boolean bl = true;
                    return bl;
                }
                throw new IllegalArgumentException("Unknown source: " + extraInfo);
            }
            finally {
                this.ignoreUpdate = false;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.ignoreUpdate) {
            return;
        }
        this.doCommand(UPDATE_COMMAND, e.getSource());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        int ctr;
        TreePath path = e.getPath();
        if (path == null) {
            this.descriptionTextArea.setText("");
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        CheckBoxCell cell = (CheckBoxCell)node.getUserObject();
        TristateButtonModel model = cell.getModel();
        if (model == this.rootModel) {
            this.descriptionTextArea.setText("");
            return;
        }
        for (ctr = 0; ctr < TExceptionType.FAMILIES.length; ++ctr) {
            if (this.familyModels[ctr] != model) continue;
            this.descriptionTextArea.setText("");
            return;
        }
        for (ctr = 0; ctr < TExceptionType.TYPES.length; ++ctr) {
            if (this.typeModels[ctr] != model) continue;
            this.descriptionTextArea.setText(TExceptionType.TYPES[ctr].getDescription());
            return;
        }
        throw new IllegalArgumentException("Unknown cell: " + cell);
    }

    static {
        for (int ctr = 0; ctr < TExceptionType.FAMILIES.length; ++ctr) {
            int ctr2;
            int memberCount = 0;
            for (ctr2 = 0; ctr2 < TExceptionType.TYPES.length; ++ctr2) {
                if (TExceptionType.TYPES[ctr2].getFamily() != ctr) continue;
                ++memberCount;
            }
            TExceptionChooserPane.familyMemberIndices[ctr] = new int[memberCount];
            memberCount = 0;
            for (ctr2 = 0; ctr2 < TExceptionType.TYPES.length; ++ctr2) {
                if (TExceptionType.TYPES[ctr2].getFamily() != ctr) continue;
                TExceptionChooserPane.familyMemberIndices[ctr][memberCount] = ctr2;
                ++memberCount;
            }
        }
    }

    protected class CheckBoxCellRenderer
    implements TreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            CheckBoxCell cell = (CheckBoxCell)node.getUserObject();
            cell.setForeground(tree.getForeground());
            cell.setBackground(tree.getBackground());
            cell.setFont(tree.getFont());
            cell.setSelectedInTree(selected);
            cell.setFocusedInTree(hasFocus);
            return cell;
        }
    }

    protected class CheckBoxCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private CheckBoxCell currentCell;

        @Override
        public Object getCellEditorValue() {
            return this.currentCell;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            CheckBoxCell cell = (CheckBoxCell)node.getUserObject();
            cell.setForeground(tree.getForeground());
            cell.setBackground(tree.getBackground());
            cell.setFont(tree.getFont());
            cell.setSelectedInTree(true);
            cell.setFocusedInTree(true);
            return cell;
        }
    }

    protected class CheckBoxCell
    extends JPanel {
        private String text;
        private TristateButtonModel model;
        private JPanel labelPanel;

        public CheckBoxCell(String text) {
            super(new GridBagLayout());
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
            PTristateCheckBox checkBox = new PTristateCheckBox();
            checkBox.setForeground(null);
            checkBox.setBackground(null);
            checkBox.setFont(null);
            this.model = (TristateButtonModel)checkBox.getModel();
            this.add((Component)checkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.labelPanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(text);
            label.setForeground(null);
            label.setBackground(null);
            label.setFont(null);
            this.labelPanel.add((Component)label, "Center");
            this.add((Component)this.labelPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setSelectedInTree(false);
            this.setFocusedInTree(false);
        }

        public TristateButtonModel getModel() {
            return this.model;
        }

        public void setSelectedInTree(boolean selectedInTree) {
            if (selectedInTree) {
                this.labelPanel.setForeground(SELECTION_FOREGROUND);
                this.labelPanel.setBackground(SELECTION_BACKGROUND);
            } else {
                this.labelPanel.setForeground(null);
                this.labelPanel.setBackground(null);
            }
        }

        public void setFocusedInTree(boolean focusedInTree) {
            if (focusedInTree) {
                this.labelPanel.setBorder(FOCUSED_BORDER);
            } else {
                this.labelPanel.setBorder(UNFOCUSED_BORDER);
            }
        }

        @Override
        public String toString() {
            return this.text;
        }
    }
}

