/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.choosers;

import edu.princeton.swing.PList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TColorChooserPane
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String CLASS_STRING = TColorChooserPane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final String CHANGE_COMMAND = CLASS_STRING + "#changeCommand";
    private static final Border BLACK_BORDER = LineBorder.createBlackLineBorder();
    private static final Border ETCHED_BORDER = new EtchedBorder();
    private PList colorList;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JButton changeButton;
    private JCheckBox disabledCheckbox;
    private Color[] colors;
    private boolean[] disabled;
    private String[] colorNames;
    private String[] disabledDescriptions;

    public TColorChooserPane(String[] colorNames, String[] disabledDescriptions) {
        super(new GridBagLayout());
        int length = colorNames.length;
        if (length != disabledDescriptions.length) {
            throw new IllegalArgumentException();
        }
        this.colorNames = new String[length];
        this.disabledDescriptions = new String[length];
        this.colors = new Color[length];
        this.disabled = new boolean[length];
        for (int ctr = 0; ctr < length; ++ctr) {
            this.colorNames[ctr] = colorNames[ctr];
            this.disabledDescriptions[ctr] = disabledDescriptions[ctr];
        }
        JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.setBorder(ETCHED_BORDER);
        this.colorList = new PList(this.colorNames);
        this.colorList.setSelectionMode(0);
        this.colorList.setSelectedIndex(0);
        this.colorList.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.colorList, 22, 30);
        Dimension preferredSize = scrollPane.getPreferredSize();
        preferredSize.width = 150;
        scrollPane.setPreferredSize(preferredSize);
        innerPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 4, 0.0, 2.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.previewLabel = new JLabel("Current color");
        innerPanel.add((Component)this.previewLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.previewPanel = new JPanel();
        this.previewPanel.setPreferredSize(new Dimension(100, 100));
        innerPanel.add((Component)this.previewPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 15, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.changeButton = new JButton("Change...");
        this.changeButton.setActionCommand(CHANGE_COMMAND);
        this.changeButton.addActionListener(this);
        innerPanel.add((Component)this.changeButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 11, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.disabledCheckbox = new JCheckBox();
        this.disabledCheckbox.setActionCommand(UPDATE_COMMAND);
        this.disabledCheckbox.addActionListener(this);
        innerPanel.add((Component)this.disabledCheckbox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)innerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(50, 25, 50, 25), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
    }

    public Color getColor(int index) {
        return this.colors[index];
    }

    public void setColor(Color color, int index) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.colors[index] = color;
        if (this.colorList.getSelectedIndex() == index) {
            this.doCommand(UPDATE_COMMAND, null);
        }
    }

    public boolean isDisabled(int index) {
        return this.disabled[index];
    }

    public void setDisabled(boolean disabled, int index) {
        this.disabled[index] = disabled;
        if (this.colorList.getSelectedIndex() == index) {
            this.doCommand(UPDATE_COMMAND, null);
        }
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            int index = this.colorList.getSelectedIndex();
            if (index == -1) {
                index = 0;
                this.colorList.setSelectedIndex(0);
            }
            this.disabledCheckbox.setText(this.disabledDescriptions[index]);
            if (this.disabled[index]) {
                this.previewLabel.setEnabled(false);
                this.previewPanel.setBorder(ETCHED_BORDER);
                this.previewPanel.setBackground(null);
                this.changeButton.setEnabled(false);
                this.disabledCheckbox.getModel().setSelected(true);
            } else {
                this.previewLabel.setEnabled(true);
                this.previewPanel.setBorder(BLACK_BORDER);
                this.previewPanel.setBackground(this.colors[index]);
                this.changeButton.setEnabled(true);
                this.disabledCheckbox.getModel().setSelected(false);
            }
            return true;
        }
        if (command == CHANGE_COMMAND) {
            Container comp;
            int index = this.colorList.getSelectedIndex();
            if (index == -1) {
                index = 0;
                this.colorList.setSelectedIndex(0);
            }
            for (comp = this; comp != null && !(comp instanceof Window); comp = comp.getParent()) {
            }
            Color selection = JColorChooser.showDialog(comp, "Color selection for " + this.colorNames[index], this.colors[index]);
            if (selection != null) {
                this.colors[index] = selection;
            }
            this.doCommand(UPDATE_COMMAND, null);
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.colorList.getSelectedIndex();
        if (index != -1) {
            this.disabled[index] = this.disabledCheckbox.getModel().isSelected();
        }
        this.doCommand(e.getActionCommand(), null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.doCommand(UPDATE_COMMAND, null);
    }
}

