/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.choosers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TAutoCompleteChooserPane
extends JPanel {
    private static final String CLASS_STRING = TAutoCompleteChooserPane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    private ButtonModel[] buttonModels;
    private ButtonGroup group;

    public TAutoCompleteChooserPane(String[] autoCompleterNames) {
        super(new GridBagLayout());
        int length = autoCompleterNames.length;
        this.buttonModels = new ButtonModel[length];
        this.group = new ButtonGroup();
        this.add((Component)new JLabel("Available AutoCompleters"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 0, new Insets(2, 2, 2, 2), 0, 0));
        for (int ctr = 0; ctr < length; ++ctr) {
            if (autoCompleterNames[ctr] == null) {
                throw new NullPointerException();
            }
            JRadioButton radioButton = new JRadioButton(autoCompleterNames[ctr], null, ctr == 0);
            this.buttonModels[ctr] = radioButton.getModel();
            this.group.add(radioButton);
            this.add((Component)radioButton, new GridBagConstraints(0, ctr + 1, 1, 1, 0.0, ctr == length - 1 ? 1.0 : 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
    }

    public int getAutoCompleterId() {
        for (int ctr = 0; ctr < this.buttonModels.length; ++ctr) {
            if (!this.buttonModels[ctr].isSelected()) continue;
            return ctr;
        }
        return 0;
    }

    public void setAutoCompleterId(int autoCompleterId) {
        this.buttonModels[autoCompleterId].setSelected(true);
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            return true;
        }
        throw new IllegalArgumentException();
    }
}

