/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PHyperlink;
import edu.princeton.swing.PList;
import edu.princeton.swing.PTextArea;
import edu.princeton.toy.TOptionsFrame;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWordBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TStdoutPane
extends JPanel {
    private static final String CLASS_STRING = TStdoutPane.class.toString();
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final String CHANGE_HANDLER_COMMAND = CLASS_STRING + "#changeHandlerCommand";
    private JPanel stderrPanel;
    private PTextArea stderrTextArea;
    private ListModel listModel;
    private TWordBuffer oldStdout;
    private TWordBuffer newStdout;
    private PHyperlink saveAsLink;
    private TVirtualMachine virtualMachine;
    private Listener listener;
    private Runner runner;

    public TStdoutPane(TVirtualMachine virtualMachine, Action saveStdoutAction) {
        super(new GridBagLayout(), true);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        this.oldStdout = new TWordBuffer();
        this.newStdout = new TWordBuffer();
        this.runner = new Runner();
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        this.stderrPanel = new JPanel(new GridBagLayout());
        this.stderrPanel.add((Component)new JLabel("Stderr"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 2), 0, 0));
        PHyperlink hyperlink = new PHyperlink("Change Settings...", null, 3);
        hyperlink.setActionCommand(CHANGE_HANDLER_COMMAND);
        hyperlink.addActionListener(this.listener);
        this.stderrPanel.add((Component)hyperlink, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 2, 2, 0), 0, 0));
        this.stderrTextArea = new PTextArea();
        this.stderrTextArea.setFont(null);
        this.stderrTextArea.setLineWrap(true);
        this.stderrTextArea.setWrapStyleWord(true);
        this.stderrTextArea.setEditable(false);
        this.stderrTextArea.addMouseListener(this.listener);
        JScrollPane scrollPane = new JScrollPane(this.stderrTextArea, 22, 31);
        scrollPane.setFont(null);
        scrollPane.getViewport().setFont(null);
        scrollPane.setMinimumSize(new Dimension(100, 100));
        this.stderrPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.stderrPanel.setFont(null);
        this.stderrPanel.setVisible(false);
        this.add((Component)this.stderrPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Stdout"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.saveAsLink = new PHyperlink(saveStdoutAction, 3);
        this.saveAsLink.setText("Save As...");
        this.add((Component)this.saveAsLink, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.listModel = new ListModel();
        PList list = new PList((javax.swing.ListModel)this.listModel);
        list.setFont(null);
        scrollPane = new JScrollPane(list, 22, 30);
        scrollPane.setFont(null);
        scrollPane.getViewport().setFont(null);
        this.add((Component)scrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, null);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == UPDATE_COMMAND) {
            this.virtualMachine.getStdout(this.newStdout);
            if (!this.newStdout.equals(this.oldStdout)) {
                this.listModel.setData(this.newStdout);
            }
            TWordBuffer temp = this.oldStdout;
            this.oldStdout = this.newStdout;
            this.newStdout = temp;
            boolean hasEncounteredError = this.virtualMachine.hasEncounteredError();
            if (this.stderrPanel.isVisible() != hasEncounteredError) {
                if (hasEncounteredError) {
                    this.stderrTextArea.setText(this.virtualMachine.getStderr());
                    this.stderrPanel.setVisible(true);
                    this.revalidate();
                    this.runner.start();
                } else {
                    this.stderrPanel.setVisible(false);
                    this.stderrTextArea.setText("");
                    this.revalidate();
                }
            }
            return true;
        }
        if (command == CHANGE_HANDLER_COMMAND) {
            TOptionsFrame.show(TOptionsFrame.EXECUTION_EXCEPTION_NODE);
            return true;
        }
        throw new IllegalArgumentException();
    }

    protected static class ListModel
    extends AbstractListModel {
        private String[] data = new String[100];
        private int size;

        @Override
        public Object getElementAt(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.data[index];
        }

        @Override
        public int getSize() {
            return this.size;
        }

        protected void setData(TWordBuffer buffer) {
            int newSize;
            int oldSize = this.size;
            this.size = newSize = buffer.getSize();
            if (this.data.length < newSize) {
                this.data = new String[newSize * 2];
            }
            for (int ctr = 0; ctr < newSize; ++ctr) {
                this.data[ctr] = buffer.getWord(ctr).toString(false);
            }
            if (oldSize < newSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
                if (oldSize > 0) {
                    this.fireContentsChanged(this, 0, oldSize - 1);
                }
            } else if (oldSize == newSize) {
                if (newSize > 0) {
                    this.fireContentsChanged(this, 0, newSize - 1);
                }
            } else {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
                if (newSize > 0) {
                    this.fireContentsChanged(this, 0, newSize - 1);
                }
            }
        }
    }

    protected class Runner
    implements Runnable {
        int count;
        Thread runningThread;

        protected Runner() {
        }

        protected synchronized void start() {
            if (this.runningThread == null) {
                this.count = 0;
                this.runningThread = new Thread(this);
                this.runningThread.start();
            } else {
                this.count = 0;
            }
        }

        protected synchronized void stop() {
            this.count = 0x7FFFFFFE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Thread.currentThread() != this.runningThread) {
                throw new IllegalStateException();
            }
            boolean done = false;
            boolean colorBackground = false;
            Color originalBackground = TStdoutPane.this.stderrTextArea.getBackground();
            Runner runner = this;
            synchronized (runner) {
                if (this.count >= 3) {
                    done = true;
                    TStdoutPane.this.stderrTextArea.setBackground(originalBackground);
                    TStdoutPane.this.stderrTextArea.repaint();
                    this.runningThread = null;
                }
            }
            while (!done) {
                boolean bl = colorBackground = !colorBackground;
                if (colorBackground) {
                    TStdoutPane.this.stderrTextArea.setBackground(TStdoutPane.this.stderrTextArea.getSelectionColor());
                } else {
                    TStdoutPane.this.stderrTextArea.setBackground(originalBackground);
                }
                TStdoutPane.this.stderrTextArea.repaint();
                try {
                    Thread.sleep(300L);
                    if (colorBackground) {
                        ++this.count;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.count = 0x7FFFFFFE;
                }
                runner = this;
                synchronized (runner) {
                    if (this.count >= 3) {
                        done = true;
                        TStdoutPane.this.stderrTextArea.setBackground(originalBackground);
                        TStdoutPane.this.stderrTextArea.repaint();
                        this.runningThread = null;
                    }
                }
            }
        }
    }

    protected class Listener
    implements ActionListener,
    ChangeListener,
    MouseListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TStdoutPane.this.doCommand(e.getActionCommand(), null);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TStdoutPane.this.doCommand(UPDATE_COMMAND, null);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TStdoutPane.this.runner.stop();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

