/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.toy.TSimMachinePane;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TSimDetailPane
extends JPanel {
    private static final String CLASS_STRING = TSimDetailPane.class.toString();
    public static final String RESCALE_COMMAND = CLASS_STRING + "#rescaleCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    public static final int MIN_SCALE = 2;
    public static final int MAX_SCALE = Integer.MAX_VALUE;
    public static final int PREFERRED_SCALE = 14;
    public static final Border DETAIL_AREA_BORDER = new LineBorder(Color.black, 1);
    private static final int CACHE_SIZE = 100;
    private static final Integer[] INTEGERS = new Integer[100];
    private static final int REGISTERS_PER_ROW = 8;
    private static final int REGISTER_ROWS = 2;
    private static final int UNSCALED_WIDTH = 41;
    private static final int UNSCALED_HEIGHT = 11;
    private static final Font[] FONT_CACHE;
    private int scale;
    private Listener listener;
    private TVirtualMachine virtualMachine;
    private TSimMachinePane machinePane;
    private JPanel detailPanel;
    private JLabel[] registerNameLabels;
    private JLabel[] registerValueLabels;
    private JLabel pcInstrNameLabel;
    private JLabel pcInstrValueLabel;
    private JLabel pcInstrPseudoCodeLabel;
    private JLabel addrDataNameLabel;
    private JLabel addrDataValueLabel;
    private JLabel addrDataPseudoCodeLabel;

    public TSimDetailPane(TVirtualMachine virtualMachine, TSimMachinePane machinePane) {
        super(null, true);
        this.setForeground(Color.black);
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        this.virtualMachine = virtualMachine;
        if (machinePane == null) {
            throw new NullPointerException();
        }
        this.machinePane = machinePane;
        this.listener = new Listener();
        virtualMachine.addChangeListener(this.listener);
        machinePane.addChangeListener(this.listener);
        this.detailPanel = new JPanel(null, false);
        this.detailPanel.setForeground(null);
        this.detailPanel.setBackground(Color.white);
        this.detailPanel.setBorder(DETAIL_AREA_BORDER);
        this.registerNameLabels = new JLabel[16];
        this.registerValueLabels = new JLabel[16];
        for (int ctr = 0; ctr < 16; ++ctr) {
            this.registerNameLabels[ctr] = new JLabel();
            this.detailPanel.add(this.registerNameLabels[ctr]);
            this.registerNameLabels[ctr].setText("R[" + TWord.HEX_DIGITS[ctr] + "]");
            this.registerNameLabels[ctr].setForeground(null);
            this.registerNameLabels[ctr].setHorizontalAlignment(2);
            this.registerNameLabels[ctr].setVerticalAlignment(0);
            this.registerValueLabels[ctr] = new JLabel();
            this.detailPanel.add(this.registerValueLabels[ctr]);
            this.registerValueLabels[ctr].setForeground(null);
            this.registerValueLabels[ctr].setHorizontalAlignment(2);
            this.registerValueLabels[ctr].setVerticalAlignment(0);
        }
        this.pcInstrNameLabel = new JLabel();
        this.detailPanel.add(this.pcInstrNameLabel);
        this.pcInstrNameLabel.setText("PC/INSTR:");
        this.pcInstrNameLabel.setForeground(null);
        this.pcInstrNameLabel.setHorizontalAlignment(2);
        this.pcInstrNameLabel.setVerticalAlignment(0);
        this.pcInstrValueLabel = new JLabel();
        this.detailPanel.add(this.pcInstrValueLabel);
        this.pcInstrValueLabel.setForeground(null);
        this.pcInstrValueLabel.setHorizontalAlignment(2);
        this.pcInstrValueLabel.setVerticalAlignment(0);
        this.pcInstrPseudoCodeLabel = new JLabel();
        this.detailPanel.add(this.pcInstrPseudoCodeLabel);
        this.pcInstrPseudoCodeLabel.setForeground(null);
        this.pcInstrPseudoCodeLabel.setHorizontalAlignment(2);
        this.pcInstrPseudoCodeLabel.setVerticalAlignment(0);
        this.addrDataNameLabel = new JLabel();
        this.detailPanel.add(this.addrDataNameLabel);
        this.addrDataNameLabel.setText("ADDR/DATA:");
        this.addrDataNameLabel.setForeground(null);
        this.addrDataNameLabel.setHorizontalAlignment(2);
        this.addrDataNameLabel.setVerticalAlignment(0);
        this.addrDataValueLabel = new JLabel();
        this.detailPanel.add(this.addrDataValueLabel);
        this.addrDataValueLabel.setForeground(null);
        this.addrDataValueLabel.setHorizontalAlignment(2);
        this.addrDataValueLabel.setVerticalAlignment(0);
        this.addrDataPseudoCodeLabel = new JLabel();
        this.detailPanel.add(this.addrDataPseudoCodeLabel);
        this.addrDataPseudoCodeLabel.setForeground(null);
        this.addrDataPseudoCodeLabel.setHorizontalAlignment(2);
        this.addrDataPseudoCodeLabel.setVerticalAlignment(0);
        this.add(this.detailPanel);
        this.scale = -1;
        this.doCommand(RESCALE_COMMAND, INTEGERS[14]);
        this.setMinimumSize(new Dimension(82, 22));
        this.setPreferredSize(new Dimension(574, 154));
        this.enableEvents(1L);
    }

    public void setVirtualMachine(TVirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new NullPointerException();
        }
        if (this.virtualMachine == virtualMachine) {
            return;
        }
        this.virtualMachine.removeChangeListener(this.listener);
        virtualMachine.addChangeListener(this.listener);
        this.virtualMachine = virtualMachine;
        this.doCommand(UPDATE_COMMAND, null);
    }

    public TVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public void setMachinePane(TSimMachinePane machinePane) {
        if (machinePane == null) {
            throw new NullPointerException();
        }
        if (this.machinePane == machinePane) {
            return;
        }
        this.machinePane.removeChangeListener(this.listener);
        machinePane.addChangeListener(this.listener);
        this.machinePane = machinePane;
        this.doCommand(UPDATE_COMMAND, null);
    }

    public TSimMachinePane getMachinePane() {
        return this.machinePane;
    }

    public synchronized boolean doCommand(String command, Object extraInfo) {
        if (command == RESCALE_COMMAND) {
            Font font;
            int scale = (Integer)extraInfo;
            if (scale < 2 || scale > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            if (scale == this.scale) {
                return false;
            }
            if (scale >= 100) {
                font = new Font("Monospaced", 1, (int)(0.9 * (double)scale));
            } else {
                if (FONT_CACHE[scale] == null) {
                    TSimDetailPane.FONT_CACHE[scale] = new Font("Monospaced", 1, (int)(0.9 * (double)scale));
                }
                font = FONT_CACHE[scale];
            }
            for (int ctr = 0; ctr < 16; ++ctr) {
                int row = ctr / 8;
                int column = ctr % 8;
                this.registerNameLabels[ctr].setBounds((1 + 5 * column) * scale, (1 + 3 * row) * scale, 4 * scale, 1 * scale);
                this.registerNameLabels[ctr].setFont(font);
                this.registerValueLabels[ctr].setBounds((1 + 5 * column) * scale, (2 + 3 * row) * scale, 4 * scale, 1 * scale);
                this.registerValueLabels[ctr].setFont(font);
            }
            int pcInstrColumns = 4;
            int addrDataColumns = 8 - pcInstrColumns;
            this.pcInstrNameLabel.setBounds(1 * scale, 7 * scale, (5 * pcInstrColumns - 1) * scale, 1 * scale);
            this.pcInstrNameLabel.setFont(font);
            this.pcInstrValueLabel.setBounds(1 * scale, 8 * scale, (5 * pcInstrColumns - 1) * scale, 1 * scale);
            this.pcInstrValueLabel.setFont(font);
            this.pcInstrPseudoCodeLabel.setBounds(1 * scale, 9 * scale, (5 * pcInstrColumns - 1) * scale, 1 * scale);
            this.pcInstrPseudoCodeLabel.setFont(font);
            this.addrDataNameLabel.setBounds((1 + 5 * pcInstrColumns) * scale, 7 * scale, (5 * addrDataColumns - 1) * scale, 1 * scale);
            this.addrDataNameLabel.setFont(font);
            this.addrDataValueLabel.setBounds((1 + 5 * pcInstrColumns) * scale, 8 * scale, (5 * addrDataColumns - 1) * scale, 1 * scale);
            this.addrDataValueLabel.setFont(font);
            this.addrDataPseudoCodeLabel.setBounds((1 + 5 * pcInstrColumns) * scale, 9 * scale, (5 * addrDataColumns - 1) * scale, 1 * scale);
            this.addrDataPseudoCodeLabel.setFont(font);
            this.repaint();
            return true;
        }
        if (command == UPDATE_COMMAND) {
            for (int ctr = 0; ctr < 16; ++ctr) {
                TWord register = this.virtualMachine.getRegister(ctr);
                this.registerValueLabels[ctr].setText(register.toHexString(false));
            }
            TWord pc = this.virtualMachine.getProgramCtr();
            TWord instr = this.virtualMachine.getCurrentInstruction();
            this.pcInstrValueLabel.setText(TWord.HEX_PAIRS[pc.getValue()] + ": " + instr.toHexString(false));
            this.pcInstrPseudoCodeLabel.setText(instr.toPseudoCodeString(false));
            TWord addr = this.machinePane.getAddr();
            TWord data = this.machinePane.getData();
            this.addrDataValueLabel.setText(TWord.HEX_PAIRS[addr.getValue()] + ": " + data.toHexString(false));
            this.addrDataPseudoCodeLabel.setText(data.toPseudoCodeString(false));
            this.repaint();
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void processComponentEvent(ComponentEvent e) {
        if (e.getID() == 101) {
            int height;
            int width = this.getWidth();
            int scale = Math.min(width / 41, (height = this.getHeight()) / 11);
            if (scale < 2) {
                scale = 2;
            }
            if (scale > Integer.MAX_VALUE) {
                scale = Integer.MAX_VALUE;
            }
            this.detailPanel.setBounds(width / 2 - 41 * scale / 2, height / 2 - 11 * scale / 2, 41 * scale, 11 * scale);
            if (scale >= 100) {
                this.doCommand(RESCALE_COMMAND, new Integer(scale));
            } else {
                this.doCommand(RESCALE_COMMAND, INTEGERS[scale]);
            }
        }
        super.processComponentEvent(e);
    }

    static {
        for (int ctr = 0; ctr < 100; ++ctr) {
            TSimDetailPane.INTEGERS[ctr] = new Integer(ctr);
        }
        FONT_CACHE = new Font[100];
    }

    protected class Listener
    implements ChangeListener {
        protected Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TSimDetailPane.this.doCommand(UPDATE_COMMAND, null);
        }
    }
}

