/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.JOptionPane;

public abstract class TResourceLoader {
    private static Class ANCHOR_CLASS;
    private static final Toolkit TOOLKIT;
    private static final ClassLoader LOADER;

    public static URL getUrl(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        return LOADER.getResource(path);
    }

    public static Image getImage(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        return TOOLKIT.getImage(LOADER.getResource(path));
    }

    public static InputStream getInputStream(String path) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        return LOADER.getResource(path).openStream();
    }

    public static Reader getReader(String path) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        return new InputStreamReader(LOADER.getResource(path).openStream());
    }

    public static BufferedReader getBufferedReader(String path) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        return new BufferedReader(new InputStreamReader(LOADER.getResource(path).openStream()));
    }

    static {
        try {
            ANCHOR_CLASS = Class.forName("ResourceAnchor");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The resource loader cannot load any of Visual X-TOY's resources because your JVM does not comply with the Java specification.", "JVM Error", 0);
            System.exit(-1);
        }
        TOOLKIT = Toolkit.getDefaultToolkit();
        LOADER = ANCHOR_CLASS.getClassLoader();
    }
}

