/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.PTextArea;
import edu.princeton.toy.TBaseConverterPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class TReferencePane
extends JPanel {
    public static final String REFERENCE_TEXT = "INSTRUCTION FORMATS\n\n           | .... | .... | .... | .... |\nFormat RR: |  op  |  d   |  s   |  t   |\nFormat A:  |  op  |  d   |     addr    |\n\n\nARITHMETIC and LOGICAL operations\n  1: add              R[d] <- R[s] +  R[t]\n  2: subtract         R[d] <- R[s] -  R[t]\n  3: and              R[d] <- R[s] &  R[t]\n  4: xor              R[d] <- R[s] ^  R[t]\n  5: shift left       R[d] <- R[s] << R[t]\n  6: shift right      R[d] <- R[s] >> R[t]\n\nTRANSFER between registers and memory\n  7: load address     R[d] <- addr\n  8: load             R[d] <- M[addr]\n  9: store            M[addr] <- R[d]\n  A: load indirect    R[d] <- M[R[t]]\n  B: store indirect   M[R[t]] <- R[d]\n\nCONTROL\n  0: halt             halt\n  C: branch zero      if (R[d] == 0) PC <- addr\n  D: branch positive  if (R[d] >  0) PC <- addr\n  E: jump register    PC <- R[d]\n  F: jump and link    R[d] <- PC; PC <- addr\n\n\nRegister 0 always reads 0.\nLoads from M[FF] come from stdin.\nStores to  M[FF] go to stdout.\n\n16-bit registers (two's complement)\n16-bit memory locations\n 8-bit program counter\n";
    private JToolBar baseConverterToolbar = new JToolBar();
    private Object lastToolbarLocation;

    public TReferencePane() {
        super(new BorderLayout());
        this.baseConverterToolbar.setFont(null);
        TBaseConverterPane baseConverterPane = new TBaseConverterPane();
        baseConverterPane.setFont(null);
        this.baseConverterToolbar.add(baseConverterPane);
        this.lastToolbarLocation = "North";
        this.add((Component)this.baseConverterToolbar, "North");
        JPanel languageReferencePanel = new JPanel(new GridBagLayout());
        languageReferencePanel.setFont(null);
        languageReferencePanel.add((Component)new JLabel("Language Reference"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        PTextArea referenceTextArea = new PTextArea(REFERENCE_TEXT);
        referenceTextArea.setEditable(false);
        referenceTextArea.setFont(null);
        JScrollPane scrollPane = new JScrollPane(referenceTextArea, 22, 30);
        scrollPane.setFont(null);
        scrollPane.getViewport().setFont(null);
        languageReferencePanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)languageReferencePanel, "Center");
    }

    @Override
    public void setFont(Font font) {
        if (this.baseConverterToolbar != null) {
            this.baseConverterToolbar.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == this.baseConverterToolbar) {
            if (constraints != "North" && constraints != "South") {
                constraints = this.lastToolbarLocation;
                this.baseConverterToolbar.setOrientation(0);
            } else {
                this.lastToolbarLocation = constraints;
            }
        }
        super.addImpl(comp, constraints, index);
    }
}

