/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.toy.TResourceLoader;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TImageManager {
    public static final String[][] UNSCALED_IMAGE_PATHS = new String[][]{{"images/splashBackground.jpg"}, {"images/frameIconWindows.gif", "images/frameIconOtherOs.gif", "images/iconNew.gif", "images/iconOpen.gif", "images/iconOpenExample.gif", "images/iconSave.gif", "images/iconSaveAs.gif", "images/iconSaveAll.gif", "images/iconEditModeOff.gif", "images/iconEditModeOn.gif", "images/iconDebugModeOff.gif", "images/iconDebugModeOn.gif", "images/iconSimModeOff.gif", "images/iconSimModeOn.gif", "images/iconReset.gif", "images/iconStep.gif", "images/iconRun.gif", "images/iconInterrupt.gif", "images/iconCheckSyntax.gif"}};
    public static final byte STARTUP_UNSCALED_IMAGE_GROUP = 0;
    public static final short STARTUP_UNSCALED_SPLASH_BACKGROUND = 0;
    public static final byte REGULAR_UNSCALED_IMAGE_GROUP = 1;
    public static final short REGULAR_UNSCALED_FRAME_ICON_WINDOWS = 0;
    public static final short REGULAR_UNSCALED_FRAME_ICON_OTHER_OS = 1;
    public static final short REGULAR_UNSCALED_NEW_ICON = 2;
    public static final short REGULAR_UNSCALED_OPEN_ICON = 3;
    public static final short REGULAR_UNSCALED_OPEN_EXAMPLE_ICON = 4;
    public static final short REGULAR_UNSCALED_SAVE_ICON = 5;
    public static final short REGULAR_UNSCALED_SAVE_AS_ICON = 6;
    public static final short REGULAR_UNSCALED_SAVE_ALL_ICON = 7;
    public static final short REGULAR_UNSCALED_EDIT_MODE_ICON_OFF = 8;
    public static final short REGULAR_UNSCALED_EDIT_MODE_ICON_ON = 9;
    public static final short REGULAR_UNSCALED_DEBUG_MODE_ICON_OFF = 10;
    public static final short REGULAR_UNSCALED_DEBUG_MODE_ICON_ON = 11;
    public static final short REGULAR_UNSCALED_SIM_MODE_ICON_OFF = 12;
    public static final short REGULAR_UNSCALED_SIM_MODE_ICON_ON = 13;
    public static final short REGULAR_UNSCALED_RESET_ICON = 14;
    public static final short REGULAR_UNSCALED_STEP_ICON = 15;
    public static final short REGULAR_UNSCALED_RUN_ICON = 16;
    public static final short REGULAR_UNSCALED_INTERRUPT_ICON = 17;
    public static final short REGULAR_UNSCALED_CHECK_SYNTAX_ICON = 18;
    public static final String[][] SCALED_IMAGE_PATHS = new String[][]{{"images/buttonEnterOff.jpg", "images/buttonEnterOn.jpg", "images/buttonInterruptOff.jpg", "images/buttonInterruptOn.jpg", "images/buttonLoadOff.jpg", "images/buttonLoadOn.jpg", "images/buttonLookOff.jpg", "images/buttonLookOn.jpg", "images/buttonResetOff.jpg", "images/buttonResetOn.jpg", "images/buttonRunOff.jpg", "images/buttonRunOn.jpg", "images/buttonStepOff.jpg", "images/buttonStepOn.jpg", "images/labelAddr.gif", "images/labelData.gif", "images/labelInstr.gif", "images/labelInwait.gif", "images/labelPc.gif", "images/labelReady.gif", "images/labelStdout.gif", "images/switchOff.jpg", "images/switchOn.jpg", "images/lightOff.jpg", "images/lightOn.jpg", "images/digitBlank.gif", "images/digit0.gif", "images/digit1.gif", "images/digit2.gif", "images/digit3.gif", "images/digit4.gif", "images/digit5.gif", "images/digit6.gif", "images/digit7.gif", "images/digit8.gif", "images/digit9.gif", "images/digitA.gif", "images/digitB.gif", "images/digitC.gif", "images/digitD.gif", "images/digitE.gif", "images/digitF.gif"}, {"images/punchcardDisabled.jpg", "images/punchcardUnselected.jpg", "images/punchcardSelected.jpg"}};
    public static final int[] ORIGINAL_IMAGE_SCALES = new int[]{30, 20};
    public static final int[] MAX_SCALE = new int[]{60, 40};
    public static final byte MACHINE_SCALED_IMAGE_GROUP = 0;
    public static final short MACHINE_SCALED_BUTTON_ENTER_OFF = 0;
    public static final short MACHINE_SCALED_BUTTON_ENTER_ON = 1;
    public static final short MACHINE_SCALED_BUTTON_INTERRUPT_OFF = 2;
    public static final short MACHINE_SCALED_BUTTON_INTERRUPT_ON = 3;
    public static final short MACHINE_SCALED_BUTTON_LOAD_OFF = 4;
    public static final short MACHINE_SCALED_BUTTON_LOAD_ON = 5;
    public static final short MACHINE_SCALED_BUTTON_LOOK_OFF = 6;
    public static final short MACHINE_SCALED_BUTTON_LOOK_ON = 7;
    public static final short MACHINE_SCALED_BUTTON_RESET_OFF = 8;
    public static final short MACHINE_SCALED_BUTTON_RESET_ON = 9;
    public static final short MACHINE_SCALED_BUTTON_RUN_OFF = 10;
    public static final short MACHINE_SCALED_BUTTON_RUN_ON = 11;
    public static final short MACHINE_SCALED_BUTTON_STEP_OFF = 12;
    public static final short MACHINE_SCALED_BUTTON_STEP_ON = 13;
    public static final short MACHINE_SCALED_LABEL_ADDR = 14;
    public static final short MACHINE_SCALED_LABEL_DATA = 15;
    public static final short MACHINE_SCALED_LABEL_INSTR = 16;
    public static final short MACHINE_SCALED_LABEL_INWAIT = 17;
    public static final short MACHINE_SCALED_LABEL_PC = 18;
    public static final short MACHINE_SCALED_LABEL_READY = 19;
    public static final short MACHINE_SCALED_LABEL_STDOUT = 20;
    public static final short MACHINE_SCALED_SWITCH_OFF = 21;
    public static final short MACHINE_SCALED_SWITCH_ON = 22;
    public static final short MACHINE_SCALED_LIGHT_OFF = 23;
    public static final short MACHINE_SCALED_LIGHT_ON = 24;
    public static final short MACHINE_SCALED_DIGIT_BLANK = 25;
    public static final short[] MACHINE_SCALED_DIGITS = new short[]{26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41};
    public static final byte STDIO_SCALED_IMAGE_GROUP = 1;
    public static final short STDIO_SCALED_PUNCHCARD_DISABLED = 0;
    public static final short STDIO_SCALED_PUNCHCARD_UNSELECTED = 1;
    public static final short STDIO_SCALED_PUNCHCARD_SELECTED = 2;
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private static final TImageManager INSTANCE = new TImageManager();
    private Image[][] unscaledImageArray = new Image[UNSCALED_IMAGE_PATHS.length][];
    private Icon[][] unscaledIconArray = new Icon[UNSCALED_IMAGE_PATHS.length][];
    private boolean[] unscaledGroupDone = new boolean[UNSCALED_IMAGE_PATHS.length];
    private Image[][][] scaledImageArray = new Image[SCALED_IMAGE_PATHS.length][][];
    private Icon[][][] scaledIconArray = new Icon[SCALED_IMAGE_PATHS.length][][];
    private boolean[][] scaledGroupDone = new boolean[SCALED_IMAGE_PATHS.length][];

    private TImageManager() {
        for (int ctr = 0; ctr < SCALED_IMAGE_PATHS.length; ++ctr) {
            this.scaledImageArray[ctr] = new Image[MAX_SCALE[ctr] + 1][];
            this.scaledIconArray[ctr] = new Icon[MAX_SCALE[ctr] + 1][];
            this.scaledGroupDone[ctr] = new boolean[MAX_SCALE[ctr] + 1];
        }
    }

    public static boolean isPrepared(byte unscaledGroupId) {
        return TImageManager.INSTANCE.unscaledGroupDone[unscaledGroupId];
    }

    public static boolean isPrepared(byte scaledGroupId, int scale) {
        return TImageManager.INSTANCE.scaledGroupDone[scaledGroupId][scale];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepare(byte unscaledGroupId) {
        if (TImageManager.INSTANCE.unscaledGroupDone[unscaledGroupId]) {
            return;
        }
        int length = 0;
        String[] pathArray = null;
        Image[] imageArray = null;
        Icon[] iconArray = null;
        TImageManager tImageManager = INSTANCE;
        synchronized (tImageManager) {
            if (TImageManager.INSTANCE.unscaledImageArray[unscaledGroupId] == null) {
                pathArray = UNSCALED_IMAGE_PATHS[unscaledGroupId];
                length = pathArray.length;
                imageArray = new Image[length];
                TImageManager.INSTANCE.unscaledImageArray[unscaledGroupId] = imageArray;
                iconArray = new Icon[length];
                TImageManager.INSTANCE.unscaledIconArray[unscaledGroupId] = iconArray;
            }
        }
        if (imageArray != null) {
            for (int ctr = 0; ctr < length; ++ctr) {
                Image image;
                imageArray[ctr] = image = TResourceLoader.getImage(pathArray[ctr]);
                iconArray[ctr] = new ImageIcon(image);
            }
            TImageManager.INSTANCE.unscaledGroupDone[unscaledGroupId] = true;
        } else {
            while (!TImageManager.INSTANCE.unscaledGroupDone[unscaledGroupId]) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepare(byte scaledGroupId, int scale) {
        if (TImageManager.INSTANCE.scaledGroupDone[scaledGroupId][scale]) {
            return;
        }
        int length = 0;
        String[] pathArray = null;
        Image[] imageArray = null;
        Icon[] iconArray = null;
        TImageManager tImageManager = INSTANCE;
        synchronized (tImageManager) {
            if (TImageManager.INSTANCE.scaledImageArray[scaledGroupId][scale] == null) {
                pathArray = SCALED_IMAGE_PATHS[scaledGroupId];
                length = pathArray.length;
                imageArray = new Image[length];
                TImageManager.INSTANCE.scaledImageArray[scaledGroupId][scale] = imageArray;
                iconArray = new Icon[length];
                TImageManager.INSTANCE.scaledIconArray[scaledGroupId][scale] = iconArray;
            }
        }
        if (imageArray != null) {
            int originalImageScale = ORIGINAL_IMAGE_SCALES[scaledGroupId];
            if (scale != originalImageScale) {
                TImageManager.prepare(scaledGroupId, originalImageScale);
                Image[] originalImageArray = TImageManager.INSTANCE.scaledImageArray[scaledGroupId][originalImageScale];
                for (int ctr = 0; ctr < length; ++ctr) {
                    Image image;
                    int originalWidth = originalImageArray[ctr].getWidth(null);
                    int originalHeight = originalImageArray[ctr].getHeight(null);
                    imageArray[ctr] = image = originalImageArray[ctr].getScaledInstance((int)((double)originalWidth * (double)scale / (double)originalImageScale), (int)((double)originalHeight * (double)scale / (double)originalImageScale), 16);
                    iconArray[ctr] = new ImageIcon(image);
                }
            } else {
                for (int ctr = 0; ctr < length; ++ctr) {
                    Image image;
                    imageArray[ctr] = image = TResourceLoader.getImage(pathArray[ctr]);
                    iconArray[ctr] = new ImageIcon(image);
                }
            }
            TImageManager.INSTANCE.scaledGroupDone[scaledGroupId][scale] = true;
        } else {
            while (!TImageManager.INSTANCE.scaledGroupDone[scaledGroupId][scale]) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Prepare interrupted");
                }
            }
        }
    }

    public static Image getImage(byte unscaledGroupId, short index) {
        TImageManager.prepare(unscaledGroupId);
        return TImageManager.INSTANCE.unscaledImageArray[unscaledGroupId][index];
    }

    public static Icon getIcon(byte unscaledGroupId, short index) {
        TImageManager.prepare(unscaledGroupId);
        return TImageManager.INSTANCE.unscaledIconArray[unscaledGroupId][index];
    }

    public static Image getImage(byte scaledGroupId, int scale, short index) {
        TImageManager.prepare(scaledGroupId, scale);
        return TImageManager.INSTANCE.scaledImageArray[scaledGroupId][scale][index];
    }

    public static Icon getIcon(byte scaledGroupId, int scale, short index) {
        TImageManager.prepare(scaledGroupId, scale);
        return TImageManager.INSTANCE.scaledIconArray[scaledGroupId][scale][index];
    }
}

