/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.toy.TProgramDocument;
import edu.princeton.toy.TResourceLoader;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Vector;

public class TExampleManager
implements Runnable {
    public static final String EXAMPLE_MANIFEST_FILE = "examples.mf";
    private static final TExampleManager INSTANCE = new TExampleManager();
    private int exampleCount = 0;
    private Vector exampleTitles = new Vector();
    private Vector exampleText = new Vector();
    private Thread runner = new Thread(this);

    private TExampleManager() {
        this.runner.start();
    }

    public static boolean isReady() {
        return TExampleManager.INSTANCE.runner == null;
    }

    public static int getExampleCount() {
        if (TExampleManager.INSTANCE.runner != null) {
            throw new RuntimeException();
        }
        return TExampleManager.INSTANCE.exampleCount;
    }

    public static String getExampleTitle(int index) {
        return (String)TExampleManager.INSTANCE.exampleTitles.get(index);
    }

    public static String getExampleText(int index) {
        return (String)TExampleManager.INSTANCE.exampleText.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Vector<String> examplePaths = new Vector<String>();
            try {
                BufferedReader reader = TResourceLoader.getBufferedReader(EXAMPLE_MANIFEST_FILE);
                String string = reader.readLine();
                while (string != null) {
                    if ((string = string.trim()).length() > 0) {
                        examplePaths.add(string);
                    }
                    string = reader.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator iterator = examplePaths.iterator();
            char[] array = new char[100];
            StringBuffer buffer = new StringBuffer();
            TProgramDocument program = new TProgramDocument("");
            while (iterator.hasNext()) {
                try {
                    Reader reader = TResourceLoader.getReader((String)iterator.next());
                    int readChars = reader.read(array, 0, 100);
                    buffer.delete(0, buffer.length());
                    while (readChars != -1) {
                        buffer.append(array, 0, readChars);
                        readChars = reader.read(array, 0, 100);
                    }
                    program.setText(buffer.toString());
                    this.exampleText.add(program.getText());
                    this.exampleTitles.add(program.getTitle());
                    ++this.exampleCount;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.runner = null;
        }
    }
}

