/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.ClipboardTargetManager;
import edu.princeton.swing.PHighlightedTextArea;
import edu.princeton.swing.PSpacer;
import edu.princeton.swing.PWrappedList;
import edu.princeton.toy.TExampleManager;
import edu.princeton.toy.TOptionsFrame;
import edu.princeton.toy.TProgramDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TExampleDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final int TITLE_ROWS = 7;
    public static final int DESCRIPTION_ROWS = 7;
    private static final String CLASS_STRING = TExampleDialog.class.toString();
    public static final String OPEN_COMMAND = CLASS_STRING + "#openCommand";
    public static final String CANCEL_COMMAND = CLASS_STRING + "#cancelCommand";
    public static final String UPDATE_COMMAND = CLASS_STRING + "#updateCommand";
    private String[] selection;
    private int lastSelectedIndex;
    private PHighlightedTextArea textArea;
    private PWrappedList list;
    private TProgramDocument program;
    private JButton openButton;

    private TExampleDialog(Frame parent) {
        super(parent, "Open Example Program", true);
    }

    private TExampleDialog(Dialog parent) {
        super(parent, "Open Example Program", true);
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menu.add(ClipboardTargetManager.CUT_ACTION.createMenuItem());
        menu.add(ClipboardTargetManager.COPY_ACTION.createMenuItem());
        menu.add(ClipboardTargetManager.PASTE_ACTION.createMenuItem());
        menu.addSeparator();
        menu.add(ClipboardTargetManager.SELECT_ALL_ACTION.createMenuItem());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)new JLabel("Available Examples:", 2), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        Object[] exampleTitles = new String[TExampleManager.getExampleCount()];
        for (int ctr = 0; ctr < exampleTitles.length; ++ctr) {
            exampleTitles[ctr] = TExampleManager.getExampleTitle(ctr);
        }
        this.list = new PWrappedList(exampleTitles);
        this.list.addActionListener(this);
        this.list.setActionCommand(OPEN_COMMAND);
        this.list.setVisibleRowCount(7);
        this.list.setSelectionMode(2);
        this.list.addListSelectionListener(this);
        contentPane.add((Component)new JScrollPane(this.list, 22, 31), new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        contentPane.add((Component)new JLabel("Preview:", 2), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.program = new TProgramDocument("");
        this.textArea = new PHighlightedTextArea(this.program, 7, 82);
        this.textArea.setEditable(false);
        this.textArea.setHighlightedLine(-2);
        TOptionsFrame.registerComponent(this.textArea, 0);
        TOptionsFrame.registerHighlightedTextArea(this.textArea);
        int[] columnMarkers = new int[]{8, 41, 80};
        this.textArea.setColumnMarkers(columnMarkers);
        contentPane.add((Component)this.textArea, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.1, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        contentPane.add((Component)new PSpacer(1, 1), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
        JButton button = new JButton("Open");
        button.addActionListener(this);
        button.setActionCommand(OPEN_COMMAND);
        this.openButton = button;
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        button.setActionCommand(CANCEL_COMMAND);
        buttonPanel.add(button);
        contentPane.add((Component)buttonPanel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.doCommand(UPDATE_COMMAND, null);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.pack();
        Window owner = this.getOwner();
        this.setLocation(owner.getX() + owner.getWidth() / 2 - this.getWidth() / 2, owner.getY() + owner.getHeight() / 2 - this.getHeight() / 2);
        this.lastSelectedIndex = -1;
        this.selection = null;
    }

    @Override
    public void dispose() {
        TOptionsFrame.unregisterComponent(this.textArea, 0);
        TOptionsFrame.registerHighlightedTextArea(this.textArea);
        super.dispose();
    }

    public static String[] showExampleDialog(Window parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        TExampleDialog dialog = parent instanceof Frame ? new TExampleDialog((Frame)parent) : new TExampleDialog((Dialog)parent);
        dialog.setVisible(true);
        String[] selection = dialog.selection;
        dialog.dispose();
        return selection;
    }

    public boolean doCommand(String command, Object extraInfo) {
        if (command == OPEN_COMMAND) {
            int[] selectedIndices = this.list.getSelectedIndices();
            int length = selectedIndices.length;
            this.selection = new String[length];
            for (int ctr = 0; ctr < length; ++ctr) {
                this.selection[ctr] = TExampleManager.getExampleText(selectedIndices[ctr]);
            }
            this.setVisible(false);
            return true;
        }
        if (command == CANCEL_COMMAND) {
            this.selection = null;
            this.setVisible(false);
            return true;
        }
        if (command == UPDATE_COMMAND) {
            int selectedIndex = this.list.getSelectedIndex();
            if (selectedIndex != this.lastSelectedIndex) {
                if (selectedIndex == -1) {
                    this.program.setText("");
                    this.openButton.setEnabled(false);
                    this.lastSelectedIndex = selectedIndex;
                } else {
                    this.program.setText(TExampleManager.getExampleText(selectedIndex));
                    this.openButton.setEnabled(true);
                    this.lastSelectedIndex = selectedIndex;
                }
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doCommand(e.getActionCommand(), null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.doCommand(UPDATE_COMMAND, null);
    }
}

