/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TConfigurationManager
extends DefaultHandler
implements Runnable {
    public static final String CONFIGURATION_FILE = "toy.conf";
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static final TConfigurationManager INSTANCE = new TConfigurationManager();
    private Locator locator;
    private StringBuffer tags;
    private Thread runner;
    private HashMap bindings = new HashMap(50);
    private File configurationFile;

    private TConfigurationManager() {
        String homePath = System.getProperty("user.home");
        if (homePath == null) {
            System.err.println("Configuration file not loaded: property user.home not found.");
        } else {
            this.configurationFile = new File(homePath, CONFIGURATION_FILE);
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean exportProperties(Map bindings) {
        if (bindings == null) {
            throw new NullPointerException();
        }
        File configurationFile = TConfigurationManager.INSTANCE.configurationFile;
        if (configurationFile == null) {
            System.err.println("Configuration file not updated: property user.home not found.");
            return false;
        }
        if (configurationFile.exists()) {
            if (!configurationFile.isFile()) {
                System.err.println("Configuration file not updated: file \"" + configurationFile + "\" is not a file.");
                return false;
            }
            if (!configurationFile.canWrite()) {
                System.err.println("Configuration file not updated: file \"" + configurationFile + "\" could not be written to.");
                return false;
            }
        }
        try {
            int ctr;
            PrintStream printStream = new PrintStream(new FileOutputStream(configurationFile));
            printStream.print("<!--\n   - toy.conf\n   -    This is the configuration file for Visual X-TOY.  It is in XML format\n   -    and is parsed by the java.xml library.\n  -->\n\n");
            Object[] keyObjects = bindings.keySet().toArray();
            int keyCount = keyObjects.length;
            String[] keys = new String[keyCount];
            int maxStringLength = 0;
            for (ctr = 0; ctr < keyCount; ++ctr) {
                keys[ctr] = (String)keyObjects[ctr];
                int length = keys[ctr].length();
                if (maxStringLength >= length) continue;
                maxStringLength = length;
            }
            for (ctr = keyCount; ctr > 1; --ctr) {
                String largestString = keys[0];
                int largestIndex = 0;
                for (int ctr2 = 1; ctr2 < ctr; ++ctr2) {
                    if (keys[ctr2].compareTo(largestString) <= 0) continue;
                    largestString = keys[ctr2];
                    largestIndex = ctr2;
                }
                keys[largestIndex] = keys[ctr - 1];
                keys[ctr - 1] = largestString;
            }
            String[] oldLocation = new String[maxStringLength + 1];
            int oldDepth = 0;
            String[] newLocation = new String[maxStringLength + 1];
            int newDepth = 0;
            StringBuffer buffer = new StringBuffer();
            int shareCount = 0;
            for (int ctr2 = 0; ctr2 < keyCount; ++ctr2) {
                int commonDepth;
                String parameter = null;
                newDepth = 0;
                char[] chars = keys[ctr2].toCharArray();
                int charCount = chars.length;
                int startCtr = 0;
                int charCtr = 0;
                boolean encounteredPound = false;
                while (charCtr < charCount) {
                    if (chars[charCtr] == '.') {
                        if (encounteredPound || charCtr == startCtr) {
                            throw new IllegalArgumentException("Invalid key: \"" + keys[ctr2] + "\".");
                        }
                        newLocation[newDepth] = new String(chars, startCtr, charCtr - startCtr);
                        ++newDepth;
                        startCtr = ++charCtr;
                        continue;
                    }
                    if (chars[charCtr] == '#') {
                        if (encounteredPound || charCtr == startCtr) {
                            throw new IllegalArgumentException("Invalid key: \"" + keys[ctr2] + "\".");
                        }
                        newLocation[newDepth] = new String(chars, startCtr, charCtr - startCtr);
                        ++newDepth;
                        startCtr = ++charCtr;
                        encounteredPound = true;
                        continue;
                    }
                    ++charCtr;
                }
                if (!encounteredPound || charCtr == startCtr) {
                    throw new IllegalArgumentException("Invalid key: \"" + keys[ctr2] + "\".");
                }
                parameter = new String(chars, startCtr, charCtr - startCtr);
                for (commonDepth = 0; commonDepth < oldDepth && commonDepth < newDepth && oldLocation[commonDepth].equals(newLocation[commonDepth]); ++commonDepth) {
                }
                if (commonDepth == newDepth) {
                    if (commonDepth != oldDepth) throw new RuntimeException("Unknown error");
                    if (shareCount == 0) {
                        printStream.print('\n');
                    }
                    buffer.delete(0, buffer.length());
                    TConfigurationManager.fillSpaces(buffer, 4 * (newDepth - 1) + 2 + newLocation[newDepth - 1].length());
                    buffer.append(parameter);
                    buffer.append(" = \"");
                    buffer.append(bindings.get(keys[ctr2]));
                    buffer.append("\"\n");
                    printStream.print(buffer);
                    ++shareCount;
                } else {
                    if (commonDepth < oldDepth) {
                        buffer.delete(0, buffer.length());
                        if (shareCount > 0) {
                            TConfigurationManager.fillSpaces(buffer, 4 * (oldDepth - 1) + 2 + oldLocation[oldDepth - 1].length());
                        }
                        buffer.append("/>\n");
                        printStream.print(buffer);
                        --oldDepth;
                        while (commonDepth < oldDepth) {
                            buffer.delete(0, buffer.length());
                            TConfigurationManager.fillSpaces(buffer, 4 * (oldDepth - 1));
                            buffer.append("</");
                            buffer.append(oldLocation[oldDepth - 1]);
                            buffer.append(">\n");
                            printStream.print(buffer);
                            --oldDepth;
                        }
                    } else if (oldDepth > 0) {
                        buffer.delete(0, buffer.length());
                        if (shareCount > 0) {
                            TConfigurationManager.fillSpaces(buffer, 4 * (oldDepth - 1) + 2 + oldLocation[oldDepth - 1].length());
                        }
                        buffer.append(">\n");
                        printStream.print(buffer);
                    }
                    while (commonDepth < newDepth - 1) {
                        buffer.delete(0, buffer.length());
                        TConfigurationManager.fillSpaces(buffer, 4 * commonDepth);
                        buffer.append('<');
                        buffer.append(newLocation[commonDepth]);
                        buffer.append(">\n");
                        printStream.print(buffer);
                        ++commonDepth;
                    }
                    buffer.delete(0, buffer.length());
                    TConfigurationManager.fillSpaces(buffer, 4 * commonDepth);
                    buffer.append('<');
                    buffer.append(newLocation[commonDepth]);
                    buffer.append(' ');
                    buffer.append(parameter);
                    buffer.append(" = \"");
                    buffer.append(bindings.get(keys[ctr2]));
                    buffer.append("\"");
                    printStream.print(buffer);
                    shareCount = 0;
                }
                oldDepth = newDepth;
                String[] location = newLocation;
                newLocation = oldLocation;
                oldLocation = location;
            }
            if (oldDepth > 0) {
                buffer.delete(0, buffer.length());
                if (shareCount > 0) {
                    TConfigurationManager.fillSpaces(buffer, 4 * (oldDepth - 1) + 2 + oldLocation[oldDepth - 1].length());
                }
                buffer.append("/>\n");
                printStream.print(buffer);
                --oldDepth;
                while (oldDepth > 0) {
                    buffer.delete(0, buffer.length());
                    TConfigurationManager.fillSpaces(buffer, 4 * (oldDepth - 1));
                    buffer.append("</");
                    buffer.append(oldLocation[oldDepth - 1]);
                    buffer.append(">\n");
                    printStream.print(buffer);
                    --oldDepth;
                }
            }
            printStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void fillSpaces(StringBuffer buffer, int n) {
        for (int ctr = 0; ctr < n; ++ctr) {
            buffer.append(' ');
        }
    }

    public static boolean isReady() {
        return TConfigurationManager.INSTANCE.runner == null;
    }

    public static String getProperty(String name) {
        return (String)TConfigurationManager.INSTANCE.bindings.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.configurationFile.exists()) {
                System.err.println("Configuration file not loaded: file \"" + this.configurationFile + "\" does not exist.");
                return;
            }
            if (!this.configurationFile.isFile()) {
                System.err.println("Configuration file not loaded: file \"" + this.configurationFile + "\" is not a file.");
                return;
            }
            if (!this.configurationFile.canRead()) {
                System.err.println("Configuration file not loaded: file \"" + this.configurationFile + "\" can not be read from.");
                return;
            }
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.configurationFile));
                SAXParser parser = parserFactory.newSAXParser();
                parser.parse((InputStream)inputStream, (DefaultHandler)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.runner = null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        new UnsupportedOperationException().printStackTrace();
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
        new UnsupportedOperationException().printStackTrace();
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        new UnsupportedOperationException().printStackTrace();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        this.tags = new StringBuffer();
        if (this.locator == null) {
            throw new NullPointerException("Document started without locator");
        }
    }

    @Override
    public void endDocument() {
        this.locator = null;
        this.tags = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        new UnsupportedOperationException().printStackTrace();
    }

    @Override
    public void endPrefixMapping(String prefix) {
        new UnsupportedOperationException().printStackTrace();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.tags.length() > 0) {
            this.tags.append('.');
        }
        this.tags.append(qName);
        int length = attributes.getLength();
        for (int ctr = 0; ctr < length; ++ctr) {
            this.bindings.put(this.tags + "#" + attributes.getQName(ctr), attributes.getValue(ctr));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        int qNameLength;
        int tagsLength = this.tags.length();
        if (tagsLength > (qNameLength = qName.length())) {
            this.tags.delete(tagsLength - qNameLength - 1, tagsLength);
        } else {
            this.tags.delete(0, tagsLength);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        new UnsupportedOperationException().printStackTrace();
    }

    @Override
    public void skippedEntity(String name) {
        new UnsupportedOperationException().printStackTrace();
    }

    @Override
    public void warning(SAXParseException e) {
        System.err.println("Warning at toy.conf(" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + "):\n" + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) {
        System.err.println("Error at toy.conf(" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + "):\n" + e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) {
        System.err.println("Fatal error at toy.conf(" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + "):\n" + e.getMessage());
    }
}

