/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing.text;

import edu.princeton.swing.text.HighlightedDocumentRenderer;
import edu.princeton.toy.lang.TWord;
import java.awt.Point;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public abstract class HighlightedDocument {
    public static final char MAX_ALLOWED_CHARACTER = '~';
    public static final boolean[] CHARACTER_ALLOWED = new boolean[127];
    private HashSet positions = new HashSet();
    private Vector textListeners = new Vector();
    private Vector undoableEditListeners = new Vector();
    protected char[] chars = new char[100000];
    protected byte[] charStyles = new byte[100000];
    protected int charCount = 0;
    protected int[] lineOffsets = new int[10000];
    protected int lineCount = 0;
    protected int maxLineLength = 0;
    private Thread writer = null;
    private int readerCount = 0;
    private int positionCtr = 0;
    private UndoableEdit undoableEdit;

    public abstract int getStyleCount();

    public abstract int getTabSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextListener(TextListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            this.writeLock();
            this.textListeners.add(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextListener(TextListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            this.writeLock();
            this.textListeners.remove(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoableEditListener(UndoableEditListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            this.writeLock();
            this.undoableEditListeners.add(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoableEditListener(UndoableEditListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            this.writeLock();
            this.undoableEditListeners.remove(listener);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position createPosition(int offset) {
        Position answer = null;
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        try {
            this.writeLock();
            if (offset > this.charCount) {
                offset = this.charCount;
            }
            answer = new Position(this.positionCtr, offset);
            this.positions.add(answer);
            ++this.positionCtr;
        }
        finally {
            this.writeUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePosition(Position position) {
        if (position == null) {
            throw new NullPointerException();
        }
        try {
            this.writeLock();
            this.positions.remove(position);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionTriplet createPositionTriplet() {
        PositionTriplet answer = null;
        try {
            this.writeLock();
            answer = new PositionTriplet(new Position(this.positionCtr, 0), new Position(this.positionCtr + 1, 0), new Position(this.positionCtr + 2, 0));
            this.positions.add(answer.selectionDot);
            this.positions.add(answer.selectionMark);
            this.positions.add(answer.caretPosition);
            this.positionCtr += 3;
        }
        finally {
            this.writeUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePositionTriplet(PositionTriplet positionTriplet) {
        if (positionTriplet == null) {
            throw new NullPointerException();
        }
        try {
            this.writeLock();
            this.positions.remove(positionTriplet.selectionDot);
            this.positions.remove(positionTriplet.selectionMark);
            this.positions.remove(positionTriplet.caretPosition);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getPositionOffsets() {
        try {
            this.readLock();
            Iterator iterator = this.positions.iterator();
            int[] positionOffsets = new int[this.positionCtr];
            while (iterator.hasNext()) {
                Position position = (Position)iterator.next();
                positionOffsets[position.id] = position.offset;
            }
            int[] nArray = positionOffsets;
            return nArray;
        }
        finally {
            this.readUnlock();
        }
    }

    public void remove(int offset, int length, boolean mergable) {
        this.replace(offset, length, "", mergable, true, null, false);
    }

    public void insertString(int offset, String string, boolean mergable) {
        this.replace(offset, 0, string, mergable, true, null, false);
    }

    public void replace(int offset, int length, String string, boolean mergable) {
        this.replace(offset, length, string, mergable, true, null, false);
    }

    public void setText(String string) {
        this.replace(0, Integer.MAX_VALUE, string, false, true, new int[0], true);
    }

    protected void utilReplace(int offset, int length, StringBuffer buffer, int newLength, int[] positionOffsets, boolean disablePositionUpdate) {
        int ctr;
        char[] oldChars = this.chars;
        int difference = newLength - length;
        if (this.charCount + difference > this.chars.length) {
            this.chars = new char[2 * (this.charCount + difference)];
            this.charStyles = new byte[2 * (this.charCount + difference)];
            for (ctr = 0; ctr < offset; ++ctr) {
                this.chars[ctr] = oldChars[ctr];
            }
        }
        if (difference != 0 || this.chars != oldChars) {
            if (difference > 0) {
                int stopIndex = offset + length;
                for (int ctr2 = this.charCount - 1; ctr2 >= stopIndex; --ctr2) {
                    this.chars[ctr2 + difference] = oldChars[ctr2];
                }
            } else {
                for (ctr = offset + length; ctr < this.charCount; ++ctr) {
                    this.chars[ctr + difference] = oldChars[ctr];
                }
            }
        }
        buffer.getChars(0, newLength, this.chars, offset);
        this.charCount += difference;
        this.lineOffsets[0] = 0;
        this.lineCount = 1;
        for (ctr = 0; ctr < this.charCount; ++ctr) {
            if (this.chars[ctr] != '\n') continue;
            if (this.lineCount == this.lineOffsets.length) {
                int[] oldLineOffsets = this.lineOffsets;
                this.lineOffsets = new int[this.lineCount * 2];
                for (int ctr2 = 0; ctr2 < this.lineCount; ++ctr2) {
                    this.lineOffsets[ctr2] = oldLineOffsets[ctr2];
                }
            }
            this.lineOffsets[this.lineCount] = ctr + 1;
            ++this.lineCount;
        }
        this.maxLineLength = this.charCount - this.lineOffsets[this.lineCount - 1];
        for (ctr = 0; ctr < this.lineCount - 1; ++ctr) {
            int lineLength = this.lineOffsets[ctr + 1] - this.lineOffsets[ctr] - 1;
            if (lineLength <= this.maxLineLength) continue;
            this.maxLineLength = lineLength;
        }
        this.assignStyles();
        if (!this.positions.isEmpty()) {
            int positionOffset;
            if (positionOffsets != null) {
                for (Position position : this.positions) {
                    if (position.id < positionOffsets.length) {
                        position.offset = positionOffsets[position.id];
                        continue;
                    }
                    position.offset = 0;
                }
            }
            if (!disablePositionUpdate) {
                for (Position position : this.positions) {
                    positionOffset = position.offset;
                    if (positionOffset >= offset + length) {
                        position.offset = positionOffset + difference;
                        continue;
                    }
                    if (positionOffset < offset) continue;
                    position.offset = offset + newLength;
                }
            }
            if (positionOffsets != null || disablePositionUpdate) {
                for (Position position : this.positions) {
                    positionOffset = position.offset;
                    if (positionOffset >= this.charCount) {
                        position.offset = this.charCount;
                        continue;
                    }
                    if (positionOffset >= 0) continue;
                    position.offset = 0;
                }
            }
        }
    }

    private String replaceString(String oldStr, String newStr, int index, int count) {
        StringBuilder sb = new StringBuilder();
        char[] charArray = oldStr.toCharArray();
        sb.append(charArray, 0, index).append(newStr);
        sb.append(charArray, index + count, charArray.length - (index + count));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replace(int offset, int length, String string, boolean mergable, boolean generateUndoEvent, int[] positionOffsets, boolean disablePositionUpdate) {
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        StringBuffer buffer = this.filterString(string);
        int newLength = buffer.length();
        if (length == 0 && newLength == 0 && this.positions == null) {
            return;
        }
        try {
            this.writeLock();
            if (offset > this.charCount) {
                offset = this.charCount;
            }
            if (offset + length > this.charCount) {
                length = this.charCount - offset;
            }
            if (length == 0 && newLength == 0 && this.positions == null) {
                return;
            }
            String charsStr = new String(this.chars, 0, this.charCount);
            StringBuffer textBefore = new StringBuffer(charsStr);
            this.utilReplace(offset, length, buffer, newLength, positionOffsets, disablePositionUpdate);
            int lineStart = offset - this.offsetToCoordinate((int)offset).x;
            int lineEnd = this.coordinateToOffset(Integer.MAX_VALUE, this.offsetToCoordinate((int)(offset + string.length())).y);
            String newLines = this.getText(lineStart, lineEnd);
            String oldLines = new String(newLines);
            int index = 0;
            int oldIndex = 0;
            boolean changed = false;
            while (index < newLines.length()) {
                String commentedLine;
                StringBuilder line = new StringBuilder();
                while (index < newLines.length() && newLines.charAt(index) != '\n') {
                    line.append(newLines.charAt(index));
                    ++index;
                }
                int lineLength = line.length();
                String pseudoCodeString = "";
                boolean needsPseudo = true;
                if (lineLength < 8) {
                    needsPseudo = false;
                } else if (!this.isCommand(line.substring(0, 8))) {
                    needsPseudo = false;
                }
                if (needsPseudo && !(commentedLine = TWord.commentLine(line.toString())).equals(line.toString())) {
                    index += commentedLine.length() - line.length();
                    newLines = this.replaceString(newLines, commentedLine, oldIndex, line.length());
                    changed = true;
                }
                oldIndex = ++index;
            }
            if (changed) {
                StringBuffer bf = new StringBuffer(newLines);
                this.utilReplace(lineStart, oldLines.length(), bf, bf.length(), positionOffsets, disablePositionUpdate);
            }
            if (!this.textListeners.isEmpty()) {
                TextEvent e = new TextEvent(this, 900);
                Object[] array = this.textListeners.toArray();
                for (int ctr = 0; ctr < array.length; ++ctr) {
                    ((TextListener)array[ctr]).textValueChanged(e);
                }
            }
            if (generateUndoEvent && !this.undoableEditListeners.isEmpty()) {
                charsStr = new String(this.chars, 0, this.charCount);
                StringBuffer textAfter = new StringBuffer(charsStr);
                UndoableEdit undoableEdit = null;
                undoableEdit = new UndoableEdit(0, textBefore, textAfter, mergable);
                UndoableEditEvent e = new UndoableEditEvent(this, undoableEdit);
                Object[] array = this.undoableEditListeners.toArray();
                for (int ctr = 0; ctr < array.length; ++ctr) {
                    ((UndoableEditListener)array[ctr]).undoableEditHappened(e);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isCommand(String str) {
        if (str.length() > 8) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!(i >= 2 && i <= 3 || TWord.isHexDigit(str.charAt(i)))) {
                return false;
            }
            if (i == 2 && str.charAt(i) != ':') {
                return false;
            }
            if (i != 3 || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    protected abstract void assignStyles();

    public StringBuffer filterString(String string) {
        int length = string.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        block8: for (int ctr = 0; ctr < length; ++ctr) {
            char character = string.charAt(ctr);
            switch (character) {
                case '\u00d4': 
                case '\u00d5': {
                    buffer.append('\'');
                    continue block8;
                }
                case '\u00d2': 
                case '\u00d3': {
                    buffer.append('\"');
                    continue block8;
                }
                case '\u2018': 
                case '\u2019': {
                    buffer.append('\'');
                    continue block8;
                }
                case '\u201c': 
                case '\u201d': {
                    buffer.append('\"');
                    continue block8;
                }
                case '\r': {
                    if (ctr + 1 < length && string.charAt(ctr + 1) == '\n') {
                        buffer.append('\n');
                        ++ctr;
                        continue block8;
                    }
                    buffer.append('\n');
                    continue block8;
                }
                case '\t': {
                    int tabSize = this.getTabSize();
                    for (int ctr2 = 0; ctr2 < tabSize; ++ctr2) {
                        buffer.append(' ');
                    }
                    continue block8;
                }
                default: {
                    if (character > '~' || !CHARACTER_ALLOWED[character]) continue block8;
                    buffer.append(character);
                }
            }
        }
        return buffer;
    }

    public String getText() {
        return this.getText(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int start, int end) {
        String answer;
        if (start < 0 || start > end) {
            throw new IllegalArgumentException();
        }
        if (start == end) {
            return "";
        }
        try {
            this.readLock();
            if (start > this.charCount) {
                start = this.charCount;
            }
            if (end > this.charCount) {
                end = this.charCount;
            }
            answer = new String(this.chars, start, end - start);
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        int answer;
        try {
            this.readLock();
            answer = this.charCount;
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() {
        int answer;
        try {
            this.readLock();
            answer = this.lineCount;
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxLineLength() {
        int answer;
        try {
            this.readLock();
            answer = this.maxLineLength;
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getWordBounds(int offset) {
        int[] answer = new int[2];
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        try {
            this.readLock();
            if (offset >= this.charCount) {
                answer[0] = this.charCount;
                answer[1] = this.charCount;
            } else {
                char ch = this.chars[offset];
                if (ch == '\n') {
                    answer[0] = offset;
                    answer[1] = offset + 1;
                } else if (ch == ' ') {
                    int start;
                    int end = offset + 1;
                    for (start = offset; start > 0 && this.chars[start - 1] == ' '; --start) {
                    }
                    while (end < this.charCount && this.chars[end] == ' ') {
                        ++end;
                    }
                    answer[0] = start;
                    answer[1] = end;
                } else if (Character.isLetterOrDigit(ch) || ch == '_') {
                    int start;
                    int end = offset + 1;
                    for (start = offset; start > 0 && (Character.isLetterOrDigit(this.chars[start - 1]) || this.chars[start - 1] == '_'); --start) {
                    }
                    while (end < this.charCount && (Character.isLetterOrDigit(this.chars[end]) || this.chars[end] == '_')) {
                        ++end;
                    }
                    answer[0] = start;
                    answer[1] = end;
                } else {
                    int start;
                    int end = offset + 1;
                    for (start = offset; start > 0 && this.chars[start - 1] == ch; --start) {
                    }
                    while (end < this.charCount && this.chars[end] == ch) {
                        ++end;
                    }
                    answer[0] = start;
                    answer[1] = end;
                }
            }
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowRender(HighlightedDocumentRenderer renderer, Object extraInfo) {
        if (renderer == null) {
            throw new NullPointerException();
        }
        try {
            this.readLock();
            renderer.doRender(this.chars, this.charStyles, this.charCount, this.lineOffsets, this.lineCount, extraInfo);
        }
        finally {
            this.readUnlock();
        }
    }

    public int coordinateToOffset(Point p) {
        return this.coordinateToOffset(p.x, p.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int coordinateToOffset(int column, int line) {
        int answer = 0;
        try {
            this.readLock();
            if (line < 0) {
                line = 0;
            }
            if (line >= this.lineCount) {
                line = this.lineCount - 1;
            }
            int lineLength = line == this.lineCount - 1 ? this.charCount - this.lineOffsets[line] : this.lineOffsets[line + 1] - this.lineOffsets[line] - 1;
            if (column < 0) {
                column = 0;
            }
            if (column > lineLength) {
                column = lineLength;
            }
            answer = this.lineOffsets[line] + column;
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point offsetToCoordinate(int offset) {
        Point answer = new Point();
        try {
            this.readLock();
            if (offset < 0) {
                offset = 0;
            }
            if (offset > this.charCount) {
                offset = this.charCount;
            }
            int line = 0;
            while (line + 1 < this.lineCount && offset >= this.lineOffsets[line + 1]) {
                ++line;
            }
            answer.x = offset - this.lineOffsets[line];
            answer.y = line;
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    protected final synchronized void writeLock() {
        try {
            while (this.readerCount > 0 || this.writer != null) {
                if (Thread.currentThread() == this.writer) {
                    throw new RuntimeException("DocumentListener attempted to mutate");
                }
                this.wait();
            }
            this.writer = Thread.currentThread();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted attempt to aquire write lock");
        }
    }

    protected final synchronized void writeUnlock() {
        this.writer = null;
        this.notifyAll();
    }

    protected final synchronized void readLock() {
        try {
            while (this.writer != null) {
                if (this.writer == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            ++this.readerCount;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted attempt to aquire read lock");
        }
    }

    protected final synchronized void readUnlock() {
        if (this.writer == Thread.currentThread()) {
            return;
        }
        int index = -1;
        --this.readerCount;
        if (this.readerCount < 0) {
            throw new RuntimeException("Bad reader count");
        }
    }

    static {
        HighlightedDocument.CHARACTER_ALLOWED[10] = true;
        for (int ctr = 32; ctr <= 126; ++ctr) {
            HighlightedDocument.CHARACTER_ALLOWED[ctr] = true;
        }
    }

    public class PositionTriplet {
        public static final int NO_CHANGE = Integer.MIN_VALUE;
        protected Position selectionDot;
        protected Position selectionMark;
        protected Position caretPosition;

        protected PositionTriplet(Position selectionDot, Position selectionMark, Position caretPosition) {
            if (selectionDot == null || selectionMark == null || caretPosition == null) {
                throw new NullPointerException();
            }
            this.selectionDot = selectionDot;
            this.selectionMark = selectionMark;
            this.caretPosition = caretPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int selectionDotOffset, int selectionMarkOffset, int caretPositionOffset) {
            try {
                HighlightedDocument.this.readLock();
                if (selectionDotOffset != Integer.MIN_VALUE) {
                    this.selectionDot.offset = selectionDotOffset < 0 ? 0 : (selectionDotOffset > HighlightedDocument.this.charCount ? HighlightedDocument.this.charCount : selectionDotOffset);
                }
                if (selectionMarkOffset != Integer.MIN_VALUE) {
                    this.selectionMark.offset = selectionMarkOffset < 0 ? 0 : (selectionMarkOffset > HighlightedDocument.this.charCount ? HighlightedDocument.this.charCount : selectionMarkOffset);
                }
                if (caretPositionOffset != Integer.MIN_VALUE) {
                    this.caretPosition.offset = caretPositionOffset < 0 ? 0 : (caretPositionOffset > HighlightedDocument.this.charCount ? HighlightedDocument.this.charCount : caretPositionOffset);
                }
            }
            finally {
                HighlightedDocument.this.readUnlock();
            }
        }

        public int getSelectionDotOffset() {
            return this.selectionDot.offset;
        }

        public int getSelectionMarkOffset() {
            return this.selectionMark.offset;
        }

        public int getCaretPositionOffset() {
            return this.caretPosition.offset;
        }

        public int getSelectionStartOffset() {
            return Math.min(this.selectionDot.offset, this.selectionMark.offset);
        }

        public int getSelectionEndOffset() {
            return Math.max(this.selectionDot.offset, this.selectionMark.offset);
        }
    }

    public class Position
    implements javax.swing.text.Position {
        protected int id;
        protected int offset;

        protected Position(int id, int offset) {
            this.id = id;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            if (this.offset == offset) {
                return;
            }
            try {
                HighlightedDocument.this.readLock();
                this.offset = offset < 0 ? 0 : (offset > HighlightedDocument.this.charCount ? HighlightedDocument.this.charCount : offset);
            }
            finally {
                HighlightedDocument.this.readUnlock();
            }
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }

    public class UndoableEdit
    implements javax.swing.undo.UndoableEdit {
        private HighlightedDocument document;
        private int offset;
        private StringBuffer oldText;
        private StringBuffer newText;
        private int[] positionOffsets;
        private boolean mergable;
        private boolean undoable;

        protected UndoableEdit(int offset, StringBuffer oldText, StringBuffer newText, boolean mergable) {
            if (newText == null) {
                throw new NullPointerException();
            }
            if (offset < 0) {
                throw new IllegalArgumentException();
            }
            this.document = HighlightedDocument.this;
            this.newText = newText;
            this.mergable = mergable;
            this.oldText = oldText;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected UndoableEdit(int offset, int length, StringBuffer newText, boolean mergable) {
            if (newText == null) {
                throw new NullPointerException();
            }
            if (length < 0 || offset < 0) {
                throw new IllegalArgumentException();
            }
            this.document = HighlightedDocument.this;
            this.newText = newText;
            this.mergable = mergable;
            try {
                HighlightedDocument.this.readLock();
                if (offset > HighlightedDocument.this.charCount) {
                    offset = HighlightedDocument.this.charCount;
                }
                this.offset = offset;
                if (length + offset > HighlightedDocument.this.charCount) {
                    length = HighlightedDocument.this.charCount - offset;
                }
                if (length == 0) {
                    this.oldText = new StringBuffer();
                } else {
                    this.oldText = new StringBuffer(2 * length);
                    this.oldText.append(HighlightedDocument.this.chars, offset, length);
                }
                this.positionOffsets = HighlightedDocument.this.getPositionOffsets();
            }
            finally {
                HighlightedDocument.this.readUnlock();
            }
        }

        @Override
        public boolean addEdit(javax.swing.undo.UndoableEdit edit) {
            if (this.document == null) {
                throw new IllegalStateException();
            }
            if (this.mergable && edit != null && edit instanceof UndoableEdit) {
                UndoableEdit undoableEdit = (UndoableEdit)edit;
                if (undoableEdit.mergable && undoableEdit.document == this.document) {
                    int newTextLength;
                    if (this.oldText.length() == 0 && undoableEdit.oldText.length() == 0 && undoableEdit.offset == this.offset + (newTextLength = this.newText.length()) && (newTextLength == 0 || undoableEdit.newText.length() == 0 || Character.isWhitespace(this.newText.charAt(newTextLength - 1)) == Character.isWhitespace(undoableEdit.newText.charAt(0)))) {
                        this.newText.append(undoableEdit.newText);
                        undoableEdit.die();
                        return true;
                    }
                    if (this.newText.length() == 0 && undoableEdit.newText.length() == 0) {
                        if (undoableEdit.offset == this.offset) {
                            this.oldText.append(undoableEdit.oldText);
                            undoableEdit.die();
                            return true;
                        }
                        if (undoableEdit.offset + this.oldText.length() == this.offset) {
                            this.oldText.insert(0, undoableEdit.oldText);
                            this.offset = undoableEdit.offset;
                            undoableEdit.die();
                            return true;
                        }
                    }
                    if (this.newText.length() == this.oldText.length() && undoableEdit.newText.length() == undoableEdit.oldText.length() && undoableEdit.offset == this.offset + (newTextLength = this.newText.length()) && (newTextLength == 0 || undoableEdit.newText.length() == 0 || Character.isWhitespace(this.newText.charAt(newTextLength - 1)) == Character.isWhitespace(undoableEdit.newText.charAt(0)))) {
                        this.newText.append(undoableEdit.newText);
                        this.oldText.append(undoableEdit.oldText);
                        undoableEdit.die();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean canRedo() {
            return this.document != null;
        }

        @Override
        public boolean canUndo() {
            return this.document != null;
        }

        @Override
        public void die() {
            this.document = null;
            this.oldText = null;
            this.newText = null;
            this.positionOffsets = null;
        }

        @Override
        public String getPresentationName() {
            return (this.mergable ? "Mergeable " : "") + "UndoableEdit (" + this.offset + ", \"" + this.oldText + "\", \"" + this.newText + "\")";
        }

        @Override
        public String getRedoPresentationName() {
            return this.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            return this.getPresentationName();
        }

        public String toString() {
            return this.getPresentationName();
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void redo() {
            if (this.document == null) {
                throw new IllegalStateException();
            }
            HighlightedDocument.this.replace(this.offset, this.oldText.length(), this.newText.toString(), false, false, this.positionOffsets, false);
        }

        @Override
        public boolean replaceEdit(javax.swing.undo.UndoableEdit anEdit) {
            return false;
        }

        @Override
        public void undo() {
            if (this.document == null) {
                throw new IllegalStateException();
            }
            HighlightedDocument.this.replace(this.offset, this.newText.length(), this.oldText.toString(), false, false, this.positionOffsets, true);
        }
    }
}

