/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing.text;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class FontInfo {
    private static final FontRenderContext DEFAULT_FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);
    private Font font;
    private int characterHeight;
    private int lineSpacing;
    private boolean monospaced;
    private int maxCharacterWidth;
    private int[] plainCharacterWidths;
    private int[] boldCharacterWidths;
    private int[] italicCharacterWidths;
    private int[] boldItalicCharacterWidths;

    public FontInfo(Font font, boolean[] characterAllowed) {
        if (font == null || characterAllowed == null) {
            throw new NullPointerException();
        }
        Font plainFont = font.deriveFont(0);
        Font boldFont = font.deriveFont(1);
        Font italicFont = font.deriveFont(2);
        Font boldItalicFont = font.deriveFont(3);
        this.font = plainFont;
        int characterAllowedLength = characterAllowed.length;
        StringBuffer buffer = new StringBuffer(characterAllowedLength);
        for (int ctr = 0; ctr < characterAllowedLength; ++ctr) {
            if (!characterAllowed[ctr]) continue;
            buffer.append((char)ctr);
        }
        String testString = buffer.toString();
        LineMetrics lineMetrics = plainFont.getLineMetrics(testString, DEFAULT_FONT_RENDER_CONTEXT);
        this.characterHeight = (int)Math.ceil(lineMetrics.getAscent());
        this.lineSpacing = (int)Math.ceil(lineMetrics.getDescent() + lineMetrics.getLeading());
        lineMetrics = boldFont.getLineMetrics(testString, DEFAULT_FONT_RENDER_CONTEXT);
        this.characterHeight = Math.max(this.characterHeight, (int)Math.ceil(lineMetrics.getAscent()));
        this.lineSpacing = Math.max(this.lineSpacing, (int)Math.ceil(lineMetrics.getDescent() + lineMetrics.getLeading()));
        lineMetrics = italicFont.getLineMetrics(testString, DEFAULT_FONT_RENDER_CONTEXT);
        this.characterHeight = Math.max(this.characterHeight, (int)Math.ceil(lineMetrics.getAscent()));
        this.lineSpacing = Math.max(this.lineSpacing, (int)Math.ceil(lineMetrics.getDescent() + lineMetrics.getLeading()));
        lineMetrics = boldItalicFont.getLineMetrics(testString, DEFAULT_FONT_RENDER_CONTEXT);
        this.characterHeight = Math.max(this.characterHeight, (int)Math.ceil(lineMetrics.getAscent()));
        this.lineSpacing = Math.max(this.lineSpacing, (int)Math.ceil(lineMetrics.getDescent() + lineMetrics.getLeading()));
        boolean monospaced = true;
        int maxCharacterWidth = 0;
        int[] plainCharacterWidths = new int[characterAllowedLength];
        int[] boldCharacterWidths = new int[characterAllowedLength];
        int[] italicCharacterWidths = new int[characterAllowedLength];
        int[] boldItalicCharacterWidths = new int[characterAllowedLength];
        char[] testArray = new char[1];
        for (int ctr = 0; ctr < characterAllowedLength; ++ctr) {
            int width;
            if (!characterAllowed[ctr]) continue;
            testArray[0] = (char)ctr;
            Rectangle2D stringBounds = plainFont.getStringBounds(testArray, 0, 1, DEFAULT_FONT_RENDER_CONTEXT);
            plainCharacterWidths[ctr] = width = (int)Math.ceil(stringBounds.getWidth());
            if (maxCharacterWidth == 0) {
                maxCharacterWidth = width;
            } else if (width > maxCharacterWidth) {
                maxCharacterWidth = width;
                monospaced = false;
            } else if (width < maxCharacterWidth) {
                monospaced = false;
            }
            stringBounds = boldFont.getStringBounds(testArray, 0, 1, DEFAULT_FONT_RENDER_CONTEXT);
            boldCharacterWidths[ctr] = width = (int)Math.ceil(stringBounds.getWidth());
            if (maxCharacterWidth == 0) {
                maxCharacterWidth = width;
            } else if (width > maxCharacterWidth) {
                maxCharacterWidth = width;
                monospaced = false;
            } else if (width < maxCharacterWidth) {
                monospaced = false;
            }
            stringBounds = italicFont.getStringBounds(testArray, 0, 1, DEFAULT_FONT_RENDER_CONTEXT);
            italicCharacterWidths[ctr] = width = (int)Math.ceil(stringBounds.getWidth());
            if (maxCharacterWidth == 0) {
                maxCharacterWidth = width;
            } else if (width > maxCharacterWidth) {
                maxCharacterWidth = width;
                monospaced = false;
            } else if (width < maxCharacterWidth) {
                monospaced = false;
            }
            stringBounds = boldItalicFont.getStringBounds(testArray, 0, 1, DEFAULT_FONT_RENDER_CONTEXT);
            boldItalicCharacterWidths[ctr] = width = (int)Math.ceil(stringBounds.getWidth());
            if (maxCharacterWidth == 0) {
                maxCharacterWidth = width;
                continue;
            }
            if (width > maxCharacterWidth) {
                maxCharacterWidth = width;
                monospaced = false;
                continue;
            }
            if (width >= maxCharacterWidth) continue;
            monospaced = false;
        }
        this.monospaced = monospaced;
        this.maxCharacterWidth = maxCharacterWidth;
        this.plainCharacterWidths = plainCharacterWidths;
        this.boldCharacterWidths = boldCharacterWidths;
        this.italicCharacterWidths = italicCharacterWidths;
        this.boldItalicCharacterWidths = boldItalicCharacterWidths;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isMonospaced() {
        return this.monospaced;
    }

    public int getMaxCharacterWidth() {
        return this.maxCharacterWidth;
    }

    public int[] getPlainCharacterWidths() {
        return this.plainCharacterWidths;
    }

    public int[] getBoldCharacterWidths() {
        return this.boldCharacterWidths;
    }

    public int[] getItalicCharacterWidths() {
        return this.italicCharacterWidths;
    }

    public int[] getBoldItalicCharacterWidths() {
        return this.boldItalicCharacterWidths;
    }

    public int getCharacterHeight() {
        return this.characterHeight;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }
}

