/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.ClipboardTarget;
import edu.princeton.swing.ClipboardTargetManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class PTextArea
extends JTextArea
implements ClipboardTarget {
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private JPopupMenu popupMenu;

    public PTextArea() {
        this.initTextArea();
    }

    public PTextArea(String text) {
        super(text);
        this.initTextArea();
    }

    public PTextArea(int rows, int columns) {
        super(rows, columns);
        this.initTextArea();
    }

    public PTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.initTextArea();
    }

    public PTextArea(Document doc) {
        super(doc);
        this.initTextArea();
    }

    public PTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.initTextArea();
    }

    private void initTextArea() {
        this.popupMenu = ClipboardTargetManager.createDefaultPopupMenu();
        ClipboardTargetManager.installMappings(this);
        this.enableEvents(20L);
    }

    @Override
    public boolean canCut() {
        return this.isEnabled() && this.isEditable();
    }

    @Override
    public boolean canCopy() {
        return this.isEnabled();
    }

    @Override
    public boolean canPaste() {
        return this.isEnabled() && this.isEditable();
    }

    @Override
    public boolean canSelectAll() {
        return this.isEnabled();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            ClipboardTargetManager.targetGainedFocus(this);
        } else if (e.getID() == 1005) {
            ClipboardTargetManager.targetLostFocus(this);
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean passedToSuper = false;
        if (this.popupMenu != null && e.isPopupTrigger()) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            int x = e.getX();
            int y = e.getY();
            Point componentLocation = this.getLocationOnScreen();
            Dimension screenSize = TOOLKIT.getScreenSize();
            Dimension preferredSize = this.popupMenu.getPreferredSize();
            if (componentLocation.x + x + preferredSize.width > screenSize.width) {
                x -= preferredSize.width;
            }
            if (componentLocation.y + y + preferredSize.height > screenSize.height) {
                y -= preferredSize.height;
            }
            e.consume();
            passedToSuper = true;
            super.processMouseEvent(e);
            this.popupMenu.show(this, x, y);
        }
        if (!passedToSuper) {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ClipboardTargetManager.targetAbilityChanged(this);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        ClipboardTargetManager.targetAbilityChanged(this);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (popupMenu != this.popupMenu) {
            if (popupMenu != null && this.popupMenu.isVisible()) {
                this.popupMenu.setVisible(false);
            }
            JPopupMenu oldValue = this.popupMenu;
            this.popupMenu = popupMenu;
            this.firePropertyChange("popupMenu", oldValue, popupMenu);
        }
    }
}

