/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JComponent;

public abstract class PSwingUtilities {
    public static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();

    public static void revalidateImmediately(Component component) {
        while (!(component == null || component instanceof JComponent && ((JComponent)component).isValidateRoot())) {
            component = component.getParent();
        }
        if (component != null) {
            component.validate();
        }
    }

    public static void paintWindowImmediately(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component != null) {
            if (component instanceof JComponent) {
                ((JComponent)component).paintImmediately(0, 0, component.getWidth(), component.getHeight());
            } else {
                component.paint(component.getGraphics());
            }
        }
    }
}

