/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PHyperlink
extends AbstractButton {
    public static final byte CLASSIC_STYLE = 0;
    public static final byte CLASSIC_HOVER_STYLE = 1;
    public static final byte BLUE_STYLE = 2;
    public static final byte METAL_STYLE = 3;
    private static final Color[][] STYLE_COLORS = new Color[][]{{new Color(0, 0, 255), new Color(0, 0, 255), new Color(128, 128, 128), new Color(128, 0, 128), new Color(128, 0, 128), new Color(128, 128, 128), new Color(255, 0, 0)}, {new Color(0, 0, 255), new Color(0, 0, 255), new Color(128, 128, 128), new Color(128, 0, 128), new Color(128, 0, 128), new Color(128, 128, 128), new Color(255, 0, 0)}, {new Color(0, 0, 255), new Color(0, 0, 255), new Color(128, 128, 128), new Color(0, 0, 255), new Color(0, 0, 255), new Color(128, 128, 128), new Color(73, 77, 255)}, {new Color(102, 102, 153), new Color(102, 102, 153), new Color(128, 128, 128), new Color(102, 102, 153), new Color(102, 102, 153), new Color(128, 128, 128), new Color(145, 146, 183)}};
    private static final boolean[][] STYLE_UNDERLINES = new boolean[][]{{true, true, false, true, true, false, true}, {false, true, false, false, true, false, true}, {false, true, false, false, true, false, true}, {false, true, false, false, true, false, true}};
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 1, 0);
    private static final Border UNDERLINE_BORDER = new UnderlineBorder(null, 0, 1);
    private JLabel label;
    private ButtonModel model;
    private Listener listener;
    private Color linkColor;
    private boolean linkUnderline;
    private Color hoverColor;
    private boolean hoverUnderline;
    private Color disabledColor;
    private boolean disabledUnderline;
    private Color visitedColor;
    private boolean visitedUnderline;
    private Color visitedHoverColor;
    private boolean visitedHoverUnderline;
    private Color visitedDisabledColor;
    private boolean visitedDisabledUnderline;
    private Color activeColor;
    private boolean activeUnderline;

    public PHyperlink() {
        this("", null, Color.blue, false, Color.blue, true, Color.gray, false, new Color(128, 0, 128), false, new Color(128, 0, 128), true, Color.gray, false, Color.red, true);
    }

    public PHyperlink(String text) {
        this(text, null, Color.blue, false, Color.blue, true, Color.gray, false, new Color(128, 0, 128), false, new Color(128, 0, 128), true, Color.gray, false, Color.red, true);
    }

    public PHyperlink(String text, Icon icon) {
        this(text, icon, Color.blue, false, Color.blue, true, Color.gray, false, new Color(128, 0, 128), false, new Color(128, 0, 128), true, Color.gray, false, Color.red, true);
    }

    public PHyperlink(String text, Icon icon, byte style) {
        this(text, icon, STYLE_COLORS[style][0], STYLE_UNDERLINES[style][0], STYLE_COLORS[style][1], STYLE_UNDERLINES[style][1], STYLE_COLORS[style][2], STYLE_UNDERLINES[style][2], STYLE_COLORS[style][3], STYLE_UNDERLINES[style][3], STYLE_COLORS[style][4], STYLE_UNDERLINES[style][4], STYLE_COLORS[style][5], STYLE_UNDERLINES[style][5], STYLE_COLORS[style][6], STYLE_UNDERLINES[style][6]);
    }

    public PHyperlink(Action a) {
        this((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        this.setAction(a);
    }

    public PHyperlink(Action a, byte style) {
        this((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"), STYLE_COLORS[style][0], STYLE_UNDERLINES[style][0], STYLE_COLORS[style][1], STYLE_UNDERLINES[style][1], STYLE_COLORS[style][2], STYLE_UNDERLINES[style][2], STYLE_COLORS[style][3], STYLE_UNDERLINES[style][3], STYLE_COLORS[style][4], STYLE_UNDERLINES[style][4], STYLE_COLORS[style][5], STYLE_UNDERLINES[style][5], STYLE_COLORS[style][6], STYLE_UNDERLINES[style][6]);
        this.setAction(a);
    }

    public PHyperlink(String text, Icon icon, Color linkColor, boolean linkUnderline, Color hoverColor, boolean hoverUnderline, Color disabledColor, boolean disabledUnderline, Color visitedColor, boolean visitedUnderline, Color visitedHoverColor, boolean visitedHoverUnderline, Color visitedDisabledColor, boolean visitedDisabledUnderline, Color activeColor, boolean activeUnderline) {
        this.initHyperlink();
        this.setText(text);
        this.setIcon(icon);
        this.setLinkColor(linkColor);
        this.setLinkUnderline(linkUnderline);
        this.setHoverColor(hoverColor);
        this.setHoverUnderline(hoverUnderline);
        this.setDisabledColor(disabledColor);
        this.setDisabledUnderline(disabledUnderline);
        this.setVisitedColor(visitedColor);
        this.setVisitedUnderline(visitedUnderline);
        this.setVisitedHoverColor(visitedHoverColor);
        this.setVisitedHoverUnderline(visitedHoverUnderline);
        this.setVisitedDisabledColor(visitedDisabledColor);
        this.setVisitedDisabledUnderline(visitedDisabledUnderline);
        this.setActiveColor(activeColor);
        this.setActiveUnderline(activeUnderline);
    }

    public void initHyperlink() {
        this.listener = new Listener();
        this.setBackground(null);
        this.setLayout(new CardLayout());
        this.label = new JLabel(this.getText(), this.getIcon(), 2);
        this.label.setBackground(null);
        this.setFont(this.label.getFont().deriveFont(0));
        this.label.setFont(null);
        this.label.setBorder(EMPTY_BORDER);
        this.label.addMouseListener(this.listener);
        this.add((Component)this.label, "label");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setModel(new HyperlinkButtonModel());
    }

    private void updateLabel() {
        if (!this.model.isEnabled()) {
            if (this.model.isSelected()) {
                this.label.setForeground(this.visitedDisabledColor != null ? this.visitedDisabledColor : this.linkColor);
                this.label.setBorder(this.visitedDisabledUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
                this.label.setIcon(this.getDisabledSelectedIcon());
            } else {
                this.label.setForeground(this.disabledColor != null ? this.disabledColor : this.linkColor);
                this.label.setBorder(this.disabledUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
                this.label.setIcon(this.getDisabledIcon());
            }
        }
        if (this.model.isPressed()) {
            this.label.setForeground(this.activeColor != null ? this.activeColor : this.linkColor);
            this.label.setBorder(this.activeUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
            this.label.setIcon(this.getPressedIcon());
        } else if (this.model.isRollover()) {
            if (this.model.isSelected()) {
                this.label.setForeground(this.visitedHoverColor != null ? this.visitedHoverColor : this.linkColor);
                this.label.setBorder(this.visitedHoverUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
                this.label.setIcon(this.getRolloverSelectedIcon());
            } else {
                this.label.setForeground(this.hoverColor != null ? this.hoverColor : this.linkColor);
                this.label.setBorder(this.hoverUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
                this.label.setIcon(this.getRolloverIcon());
            }
        } else if (this.model.isSelected()) {
            this.label.setForeground(this.visitedColor != null ? this.visitedColor : this.linkColor);
            this.label.setBorder(this.visitedUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
            this.label.setIcon(this.getSelectedIcon());
        } else {
            this.label.setForeground(this.linkColor);
            this.label.setBorder(this.linkUnderline ? UNDERLINE_BORDER : EMPTY_BORDER);
            this.label.setIcon(this.getIcon());
        }
    }

    @Override
    public void setModel(ButtonModel model) {
        super.setModel(model);
        if (model != this.model && this.listener != null) {
            if (this.model != null) {
                this.model.removeChangeListener(this.listener);
            }
            this.model = model;
            model.addChangeListener(this.listener);
            this.updateLabel();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.label.setText(text);
    }

    @Override
    public void setPressedIcon(Icon icon) {
        super.setPressedIcon(icon);
        this.updateLabel();
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.updateLabel();
    }

    @Override
    public void setSelectedIcon(Icon icon) {
        super.setSelectedIcon(icon);
        this.updateLabel();
    }

    @Override
    public void setRolloverIcon(Icon icon) {
        super.setRolloverIcon(icon);
        this.updateLabel();
    }

    @Override
    public void setRolloverSelectedIcon(Icon icon) {
        super.setRolloverSelectedIcon(icon);
        this.updateLabel();
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        super.setDisabledIcon(icon);
        this.updateLabel();
    }

    @Override
    public void setDisabledSelectedIcon(Icon icon) {
        super.setDisabledSelectedIcon(icon);
        this.updateLabel();
    }

    public void setLinkColor(Color color) {
        if (color != this.linkColor) {
            Color oldValue = this.linkColor;
            this.linkColor = color;
            this.firePropertyChange("linkColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkUnderline(boolean underline) {
        if (underline != this.linkUnderline) {
            boolean oldValue = this.linkUnderline;
            this.linkUnderline = underline;
            this.firePropertyChange("linkUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getLinkUnderline() {
        return this.linkUnderline;
    }

    public void setHoverColor(Color color) {
        if (color != this.hoverColor) {
            Color oldValue = this.hoverColor;
            this.hoverColor = color;
            this.firePropertyChange("hoverColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverUnderline(boolean underline) {
        if (underline != this.hoverUnderline) {
            boolean oldValue = this.hoverUnderline;
            this.hoverUnderline = underline;
            this.firePropertyChange("hoverUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getHoverUnderline() {
        return this.hoverUnderline;
    }

    public void setDisabledColor(Color color) {
        if (color != this.disabledColor) {
            Color oldValue = this.disabledColor;
            this.disabledColor = color;
            this.firePropertyChange("disabledColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledUnderline(boolean underline) {
        if (underline != this.disabledUnderline) {
            boolean oldValue = this.disabledUnderline;
            this.disabledUnderline = underline;
            this.firePropertyChange("disabledUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getDisabledUnderline() {
        return this.disabledUnderline;
    }

    public void setVisitedColor(Color color) {
        if (color != this.visitedColor) {
            Color oldValue = this.visitedColor;
            this.visitedColor = color;
            this.firePropertyChange("visitedColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getVisitedColor() {
        return this.visitedColor;
    }

    public void setVisitedUnderline(boolean underline) {
        if (underline != this.visitedUnderline) {
            boolean oldValue = this.visitedUnderline;
            this.visitedUnderline = underline;
            this.firePropertyChange("visitedUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getVisitedUnderline() {
        return this.visitedUnderline;
    }

    public void setVisitedHoverColor(Color color) {
        if (color != this.visitedHoverColor) {
            Color oldValue = this.visitedHoverColor;
            this.visitedHoverColor = color;
            this.firePropertyChange("visitedHoverColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getVisitedHoverColor() {
        return this.visitedHoverColor;
    }

    public void setVisitedHoverUnderline(boolean underline) {
        if (underline != this.visitedHoverUnderline) {
            boolean oldValue = this.visitedHoverUnderline;
            this.visitedHoverUnderline = underline;
            this.firePropertyChange("visitedHoverUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getVisitedHoverUnderline() {
        return this.visitedHoverUnderline;
    }

    public void setVisitedDisabledColor(Color color) {
        if (color != this.visitedDisabledColor) {
            Color oldValue = this.visitedDisabledColor;
            this.visitedDisabledColor = color;
            this.firePropertyChange("visitedDisabledColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getVisitedDisabledColor() {
        return this.visitedDisabledColor;
    }

    public void setVisitedDisabledUnderline(boolean underline) {
        if (underline != this.visitedDisabledUnderline) {
            boolean oldValue = this.visitedDisabledUnderline;
            this.visitedDisabledUnderline = underline;
            this.firePropertyChange("visitedDisabledUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getVisitedDisabledUnderline() {
        return this.visitedDisabledUnderline;
    }

    public void setActiveColor(Color color) {
        if (color != this.activeColor) {
            Color oldValue = this.activeColor;
            this.activeColor = color;
            this.firePropertyChange("activeColor", oldValue, color);
            this.updateLabel();
        }
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveUnderline(boolean underline) {
        if (underline != this.activeUnderline) {
            boolean oldValue = this.activeUnderline;
            this.activeUnderline = underline;
            this.firePropertyChange("activeUnderline", oldValue, underline);
            this.updateLabel();
        }
    }

    public boolean getActiveUnderline() {
        return this.activeUnderline;
    }

    public static class UnderlineBorder
    extends AbstractBorder {
        private Color color;
        private int pad;
        private int thickness;

        public UnderlineBorder(Color color, int pad, int thickness) {
            this.color = color;
            if (pad < 0) {
                throw new IllegalArgumentException();
            }
            this.pad = pad;
            if (thickness < 0) {
                throw new IllegalArgumentException();
            }
            this.thickness = thickness;
        }

        public Color getColor() {
            return this.color;
        }

        public int getPad() {
            return this.pad;
        }

        public int getThickness() {
            return this.thickness;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            Color color = this.color;
            if (color == null) {
                color = c.getForeground();
            }
            if (color == null) {
                return;
            }
            g.setColor(color);
            g.fillRect(x, y + height - this.thickness, width, this.thickness);
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, this.pad + this.thickness, 0);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 0;
            insets.left = 0;
            insets.bottom = this.pad + this.thickness;
            insets.right = 0;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.pad == 0;
        }
    }

    public static class HyperlinkButtonModel
    extends DefaultButtonModel {
        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() != b && this.isEnabled()) {
                if (!b && this.isArmed() && !this.isSelected()) {
                    this.setSelected(true);
                }
                super.setPressed(b);
            }
        }
    }

    protected class Listener
    implements ChangeListener,
    MouseListener {
        protected Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (PHyperlink.this.model.isEnabled() != PHyperlink.this.isEnabled()) {
                PHyperlink.this.setEnabled(PHyperlink.this.model.isEnabled());
            } else {
                PHyperlink.this.updateLabel();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PHyperlink.this.model.setArmed(true);
            PHyperlink.this.model.setPressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PHyperlink.this.model.setPressed(false);
            PHyperlink.this.model.setArmed(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PHyperlink.this.model.setArmed(PHyperlink.this.model.isPressed());
            PHyperlink.this.model.setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PHyperlink.this.model.setRollover(false);
            PHyperlink.this.model.setArmed(false);
        }
    }
}

