/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.ClipboardTarget;
import edu.princeton.swing.ClipboardTargetManager;
import edu.princeton.swing.text.AutoCompleter;
import edu.princeton.swing.text.DefaultAutoCompleter;
import edu.princeton.swing.text.DefaultHighlightedDocument;
import edu.princeton.swing.text.FontInfo;
import edu.princeton.swing.text.HighlightStyle;
import edu.princeton.swing.text.HighlightedDocument;
import edu.princeton.swing.text.HighlightedDocumentRenderer;
import edu.princeton.toy.lang.TWord;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class PHighlightedTextArea
extends JScrollPane
implements TextListener,
ClipboardTarget {
    public static final int FOLLOW_CARET = -3;
    public static final int NEVER_HIGHLIGHT = -2;
    public static final int NO_HIGHLIGHT = -1;
    public static final int NO_CHANGE = Integer.MIN_VALUE;
    public static final AutoCompleter DEFAULT_AUTO_COMPLETER = new DefaultAutoCompleter();
    public static final Color DEFAULT_FOREGROUND = Color.black;
    public static final Color DEFAULT_BACKGROUND = Color.white;
    private static final String[] CHARACTER_STRINGS = new String[128];
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private static final Hashtable fontInfoTable = new Hashtable();
    private InternalNumberedArea numberedArea;
    private InternalTextArea textArea;
    private HighlightStyle[] highlightStyles;
    private Font plainFont;
    private Font[] highlightFonts;
    private boolean supressReaction;
    private boolean monospaced;
    private int maxCharacterWidth;
    private int[] plainCharacterWidths;
    private int[] boldCharacterWidths;
    private int[] italicCharacterWidths;
    private int[] boldItalicCharacterWidths;
    private int characterHeight;
    private int lineSpacing;
    private boolean showLineNumbers;
    private int[] columnMarkers;
    private boolean insertMode;
    private boolean editable;
    private Insets margin;
    private HighlightedDocument document;
    private AutoCompleter autoCompleter;
    private HighlightedDocument.PositionTriplet selection;
    private int highlightedLine;
    private int rows;
    private int columns;
    private Color caretColor;
    private Color lineNumberColor;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private Color highlightedTextColor;
    private Color highlightColor;
    private Color markerColor;
    private JPopupMenu popupMenu;
    private boolean caretVisible;
    private boolean keepCaretVisible;
    private Thread runner;

    public PHighlightedTextArea() {
        this(new DefaultHighlightedDocument(), 10, 10);
    }

    public PHighlightedTextArea(HighlightedDocument document) {
        this(document, 10, 10);
    }

    public PHighlightedTextArea(int rows, int columns) {
        this(new DefaultHighlightedDocument(), rows, columns);
    }

    public PHighlightedTextArea(HighlightedDocument document, int rows, int columns) {
        super(22, 30);
        this.setDoubleBuffered(true);
        if (document == null) {
            throw new NullPointerException();
        }
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException();
        }
        this.supressReaction = false;
        this.numberedArea = new InternalNumberedArea();
        this.textArea = new InternalTextArea();
        this.setRowHeaderView(this.numberedArea);
        this.setViewportView(this.textArea);
        this.setCorner("LOWER_LEFT_CORNER", new JPanel());
        this.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.insertMode = true;
        this.editable = true;
        this.rows = rows;
        this.columns = columns;
        this.margin = new Insets(6, 6, 6, 6);
        this.columnMarkers = new int[0];
        this.showLineNumbers = true;
        this.highlightedLine = -3;
        this.highlightStyles = new HighlightStyle[0];
        this.highlightFonts = new Font[0];
        this.setDocument(document);
        this.autoCompleter = DEFAULT_AUTO_COMPLETER;
        this.setFont(new Font("Monospaced", 0, 12));
        this.setForeground(DEFAULT_FOREGROUND);
        this.setBackground(DEFAULT_BACKGROUND);
        this.caretColor = null;
        this.lineNumberColor = new Color(148, 148, 148);
        this.disabledTextColor = new Color(148, 148, 148);
        this.selectedTextColor = null;
        this.selectionColor = new Color(204, 204, 255);
        this.highlightedTextColor = null;
        this.highlightColor = new Color(186, 186, 255);
        this.markerColor = new Color(206, 206, 206);
        ClipboardTargetManager.installMappings(this);
        this.popupMenu = ClipboardTargetManager.createDefaultPopupMenu();
        this.recalculateSizes();
    }

    public void finalize() throws Throwable {
        this.runner = null;
        super.finalize();
    }

    public Point modelToView(Point p) {
        return this.modelToView(p.x, p.y);
    }

    public Point modelToView(int column, int line) {
        return new Point(this.margin.left + column * this.maxCharacterWidth, this.margin.top + (line + 1) * this.characterHeight + line * this.lineSpacing);
    }

    public Point viewToModel(Point p) {
        return this.viewToModel(p.x, p.y);
    }

    public Point viewToModel(int x, int y) {
        return new Point((x - this.margin.left + this.maxCharacterWidth / 2) / this.maxCharacterWidth, (y - this.margin.top + this.lineSpacing - this.characterHeight / 2) / (this.characterHeight + this.lineSpacing));
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (popupMenu != this.popupMenu) {
            if (popupMenu != null && this.popupMenu.isVisible()) {
                this.popupMenu.setVisible(false);
            }
            JPopupMenu oldValue = this.popupMenu;
            this.popupMenu = popupMenu;
            this.firePropertyChange("popupMenu", oldValue, popupMenu);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            if (this.editable && this.isEnabled()) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            ClipboardTargetManager.targetAbilityChanged(this.textArea);
        }
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color caretColor) {
        if (!(caretColor == this.caretColor || caretColor != null && caretColor.equals(this.caretColor))) {
            Color oldValue = this.caretColor;
            this.caretColor = caretColor;
            this.firePropertyChange("caretColor", oldValue, caretColor);
            this.repaint();
        }
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public void setLineNumberColor(Color lineNumberColor) {
        if (!(lineNumberColor == this.lineNumberColor || lineNumberColor != null && lineNumberColor.equals(this.lineNumberColor))) {
            Color oldValue = this.lineNumberColor;
            this.lineNumberColor = lineNumberColor;
            this.firePropertyChange("lineNumberColor", oldValue, lineNumberColor);
            this.repaint();
        }
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color disabledTextColor) {
        if (!(disabledTextColor == this.disabledTextColor || disabledTextColor != null && disabledTextColor.equals(this.disabledTextColor))) {
            Color oldValue = this.disabledTextColor;
            this.disabledTextColor = disabledTextColor;
            this.firePropertyChange("disabledTextColor", oldValue, disabledTextColor);
            this.repaint();
        }
    }

    public boolean getShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        if (showLineNumbers != this.showLineNumbers) {
            boolean oldValue = this.showLineNumbers;
            this.showLineNumbers = showLineNumbers;
            if (showLineNumbers) {
                this.setRowHeaderView(this.numberedArea);
            } else {
                this.setRowHeaderView(null);
            }
            this.firePropertyChange("showLineNumbers", oldValue, showLineNumbers);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            boolean oldValue = this.editable;
            this.editable = editable;
            if (editable && this.isEnabled()) {
                this.textArea.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.textArea.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.firePropertyChange("editable", oldValue, editable);
            ClipboardTargetManager.targetAbilityChanged(this.textArea);
            this.repaint();
        }
    }

    public boolean getInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(boolean insertMode) {
        if (insertMode != this.insertMode) {
            boolean oldValue = this.insertMode;
            this.insertMode = insertMode;
            this.firePropertyChange("insertMode", oldValue, insertMode);
            this.caretVisible = true;
            this.keepCaretVisible = true;
            this.scrollToCaret();
        }
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Color markerColor) {
        if (!(markerColor == this.markerColor || markerColor != null && markerColor.equals(this.markerColor))) {
            Color oldValue = this.markerColor;
            this.markerColor = markerColor;
            this.firePropertyChange("markerColor", oldValue, markerColor);
            this.repaint();
        }
    }

    public int[] getColumnMarkers() {
        int[] answer = new int[this.columnMarkers.length];
        for (int ctr = 0; ctr < this.columnMarkers.length; ++ctr) {
            answer[ctr] = this.columnMarkers[ctr];
        }
        return answer;
    }

    public void setColumnMarkers(int[] columnMarkers) {
        if (columnMarkers != this.columnMarkers) {
            int[] oldValue = this.columnMarkers;
            this.columnMarkers = new int[columnMarkers.length];
            for (int ctr = 0; ctr < columnMarkers.length; ++ctr) {
                if (columnMarkers[ctr] < 0) {
                    throw new IllegalArgumentException();
                }
                this.columnMarkers[ctr] = columnMarkers[ctr];
            }
            this.firePropertyChange("columnMarkers", oldValue, columnMarkers);
            this.repaint();
        }
    }

    public int getCaretPosition() {
        return this.selection.getCaretPositionOffset();
    }

    public void setCaretPosition(int caretPosition) {
        if (caretPosition == Integer.MIN_VALUE) {
            caretPosition = this.selection.getCaretPositionOffset();
        }
        this.select(caretPosition, caretPosition, caretPosition);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color selectedTextColor) {
        if (!(selectedTextColor == this.selectedTextColor || selectedTextColor != null && selectedTextColor.equals(this.selectedTextColor))) {
            Color oldValue = this.selectedTextColor;
            this.selectedTextColor = selectedTextColor;
            this.firePropertyChange("selectedTextColor", oldValue, selectedTextColor);
            this.repaint();
        }
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (!(selectionColor == this.selectionColor || selectionColor != null && selectionColor.equals(this.selectionColor))) {
            Color oldValue = this.selectionColor;
            this.selectionColor = selectionColor;
            this.firePropertyChange("selectionColor", oldValue, selectionColor);
            this.repaint();
        }
    }

    public int getSelectionStart() {
        return this.selection.getSelectionStartOffset();
    }

    public int getSelectionEnd() {
        return this.selection.getSelectionEndOffset();
    }

    public int getSelectionDot() {
        return this.selection.getSelectionDotOffset();
    }

    public int getSelectionMark() {
        return this.selection.getSelectionMarkOffset();
    }

    public String getSelectedText() {
        return this.document.getText(this.selection.getSelectionStartOffset(), this.selection.getSelectionEndOffset());
    }

    @Override
    public boolean canSelectAll() {
        return this.isEnabled();
    }

    @Override
    public void selectAll() {
        this.select(0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void select(int selectionDot, int selectionMark) {
        if (selectionDot == Integer.MIN_VALUE) {
            selectionDot = this.selection.getSelectionDotOffset();
        }
        this.select(selectionDot, selectionMark, selectionDot);
    }

    public void select(int selectionDot, int selectionMark, int caretPosition) {
        if (selectionDot != Integer.MIN_VALUE || selectionMark != Integer.MIN_VALUE || caretPosition != Integer.MIN_VALUE) {
            this.selection.set(selectionDot, selectionMark, caretPosition);
            this.caretVisible = true;
            this.keepCaretVisible = true;
            this.scrollToCaret();
        }
    }

    public Color getHighlightedTextColor() {
        return this.highlightedTextColor;
    }

    public void setHighlightedTextColor(Color highlightedTextColor) {
        if (!(highlightedTextColor == this.highlightedTextColor || highlightedTextColor != null && highlightedTextColor.equals(this.highlightedTextColor))) {
            Color oldValue = this.highlightedTextColor;
            this.highlightedTextColor = highlightedTextColor;
            this.firePropertyChange("highlightedTextColor", oldValue, highlightedTextColor);
            this.repaint();
        }
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        if (!(highlightColor == this.highlightColor || highlightColor != null && highlightColor.equals(this.highlightColor))) {
            Color oldValue = this.highlightColor;
            this.highlightColor = highlightColor;
            this.firePropertyChange("highlightColor", oldValue, highlightColor);
            this.repaint();
        }
    }

    public int getHighlightedLine() {
        return this.highlightedLine;
    }

    public void setHighlightedLine(int highlightedLine) {
        if (highlightedLine != this.highlightedLine) {
            int oldValue = this.highlightedLine;
            this.highlightedLine = highlightedLine;
            this.firePropertyChange("highlightedLine", oldValue, highlightedLine);
            this.repaint();
        }
    }

    private boolean isInPseudoCode() {
        int offset = this.selection.getSelectionDotOffset();
        Point coordinate = this.document.offsetToCoordinate(offset);
        String line = this.document.getText(offset - coordinate.x, this.document.coordinateToOffset(Integer.MAX_VALUE, coordinate.y));
        int length = line.length();
        boolean hasInstruction = false;
        if (length >= 8) {
            hasInstruction = TWord.isCommand(line.substring(0, 8));
        }
        Point selStart = this.document.offsetToCoordinate(this.getSelectionStart());
        boolean startIn = selStart.x >= 8 && selStart.x < 41;
        return hasInstruction && startIn;
    }

    @Override
    public boolean canCut() {
        return this.editable && this.isEnabled();
    }

    @Override
    public void cut() {
        if (!this.canCut() || this.isInPseudoCode()) {
            System.out.println("Cant Cut");
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int selectionStartOffset = this.selection.getSelectionStartOffset();
        int selectionEndOffset = this.selection.getSelectionEndOffset();
        this.supressReaction = true;
        if (selectionStartOffset != selectionEndOffset) {
            try {
                Clipboard clipboard = TOOLKIT.getSystemClipboard();
                StringSelection stringSelection = new StringSelection(this.document.getText(selectionStartOffset, selectionEndOffset));
                clipboard.setContents(stringSelection, stringSelection);
                this.document.remove(selectionStartOffset, selectionEndOffset - selectionStartOffset, false);
                selectionStartOffset = this.selection.getSelectionStartOffset();
                this.select(selectionStartOffset, selectionStartOffset, selectionStartOffset);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.recalculateSizes();
        this.caretVisible = true;
        this.keepCaretVisible = true;
        this.scrollToCaret();
        this.supressReaction = false;
    }

    @Override
    public boolean canCopy() {
        return this.isEnabled();
    }

    @Override
    public void copy() {
        int selectionEndOffset;
        if (!this.isEnabled()) {
            return;
        }
        int selectionStartOffset = this.selection.getSelectionStartOffset();
        if (selectionStartOffset != (selectionEndOffset = this.selection.getSelectionEndOffset())) {
            try {
                Clipboard clipboard = TOOLKIT.getSystemClipboard();
                StringSelection selection = new StringSelection(this.document.getText(selectionStartOffset, selectionEndOffset));
                clipboard.setContents(selection, selection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canPaste() {
        return this.editable && this.isEnabled();
    }

    @Override
    public void paste() {
        if (!this.canPaste() || this.isInPseudoCode()) {
            System.out.println("Cant paste");
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int selectionStartOffset = this.selection.getSelectionStartOffset();
        int selectionEndOffset = this.selection.getSelectionEndOffset();
        this.supressReaction = true;
        try {
            Clipboard clipboard = TOOLKIT.getSystemClipboard();
            String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            if (selectionStartOffset != selectionEndOffset) {
                this.document.replace(selectionStartOffset, selectionEndOffset - selectionStartOffset, string, false);
            } else if (this.insertMode) {
                this.document.insertString(selectionStartOffset, string, false);
            } else {
                this.document.replace(selectionStartOffset, string.length(), string, false);
            }
            selectionStartOffset = this.selection.getSelectionStartOffset();
            this.select(selectionStartOffset, selectionStartOffset, selectionStartOffset);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recalculateSizes();
        this.caretVisible = true;
        this.keepCaretVisible = true;
        this.scrollToCaret();
        this.supressReaction = false;
    }

    public String getText() {
        return this.document.getText();
    }

    public void setText(String text) {
        this.document.setText(text);
        this.select(0, 0, 0);
    }

    public HighlightedDocument getDocument() {
        return this.document;
    }

    public void setDocument(HighlightedDocument document) {
        if (document == null) {
            throw new NullPointerException();
        }
        if (document != this.document) {
            if (this.document != null) {
                this.document.removeTextListener(this);
                this.document.freePositionTriplet(this.selection);
            }
            HighlightedDocument oldValue = this.document;
            this.document = document;
            document.addTextListener(this);
            this.selection = document.createPositionTriplet();
            int styleCount = document.getStyleCount();
            if (this.highlightStyles.length != styleCount) {
                this.highlightStyles = new HighlightStyle[styleCount];
                this.highlightFonts = new Font[styleCount];
            }
            for (int ctr = 0; ctr < styleCount; ++ctr) {
                this.highlightStyles[ctr] = HighlightStyle.DEFAULT_STYLE;
                this.highlightFonts[ctr] = this.plainFont;
            }
            this.select(0, 0, 0);
            this.firePropertyChange("document", oldValue, document);
            this.recalculateSizes();
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.highlightStyles == null) {
            return;
        }
        if (font == null) {
            throw new NullPointerException();
        }
        String name = font.getName();
        int size = font.getSize();
        this.margin.top = size / 2;
        this.margin.left = size / 2;
        this.margin.bottom = size / 2;
        this.margin.right = size / 2;
        this.plainFont = new Font(name, HighlightStyle.DEFAULT_STYLE.getStyleMask(), size);
        FontInfo fontInfo = (FontInfo)fontInfoTable.get(this.plainFont);
        if (fontInfo == null) {
            fontInfo = new FontInfo(this.plainFont, HighlightedDocument.CHARACTER_ALLOWED);
            fontInfoTable.put(this.plainFont, fontInfo);
        }
        this.monospaced = fontInfo.isMonospaced();
        this.maxCharacterWidth = fontInfo.getMaxCharacterWidth();
        this.plainCharacterWidths = fontInfo.getPlainCharacterWidths();
        this.boldCharacterWidths = fontInfo.getBoldCharacterWidths();
        this.italicCharacterWidths = fontInfo.getItalicCharacterWidths();
        this.boldItalicCharacterWidths = fontInfo.getBoldItalicCharacterWidths();
        this.characterHeight = fontInfo.getCharacterHeight();
        this.lineSpacing = fontInfo.getLineSpacing();
        for (int ctr = 0; ctr < this.highlightStyles.length; ++ctr) {
            this.highlightFonts[ctr] = new Font(name, this.highlightStyles[ctr].getStyleMask(), size);
        }
        super.setFont(font);
        this.recalculateSizes();
    }

    public int getStyleCount() {
        return this.highlightStyles.length;
    }

    public HighlightStyle getStyle(int index) {
        return this.highlightStyles[index];
    }

    public void setStyle(HighlightStyle style, int index) {
        if (style == null) {
            throw new NullPointerException();
        }
        if (this.highlightStyles[index] != style) {
            HighlightStyle oldValue = this.highlightStyles[index];
            this.highlightStyles[index] = style;
            this.highlightFonts[index] = new Font(this.getFont().getName(), style.getStyleMask(), this.getFont().getSize());
            this.firePropertyChange("highlightStyles[" + index + "]", oldValue, style);
            this.repaint();
        }
    }

    public AutoCompleter getAutoCompleter() {
        return this.autoCompleter;
    }

    public void setAutoCompleter(AutoCompleter autoCompleter) {
        if (autoCompleter == null) {
            throw new NullPointerException();
        }
        if (this.autoCompleter != autoCompleter) {
            AutoCompleter oldValue = this.autoCompleter;
            this.autoCompleter = autoCompleter;
            this.firePropertyChange("autoCompleter", oldValue, autoCompleter);
        }
    }

    public void recalculateSizes() {
        int lineCount = this.document.getLineCount();
        int maxLineLength = this.document.getMaxLineLength();
        Dimension textAreaPreferredSize = this.textArea.getPreferredSize();
        Dimension textAreaMinimumSize = this.textArea.getMinimumSize();
        textAreaMinimumSize.width = this.columns * this.maxCharacterWidth + this.margin.left + this.margin.right;
        textAreaMinimumSize.height = this.rows * (this.characterHeight + this.lineSpacing) - this.lineSpacing + this.margin.top + this.margin.bottom;
        textAreaPreferredSize.width = this.maxCharacterWidth * (maxLineLength + 1) + this.margin.left + this.margin.right;
        if (textAreaPreferredSize.width < textAreaMinimumSize.width) {
            textAreaPreferredSize.width = textAreaMinimumSize.width;
        }
        textAreaPreferredSize.height = (this.characterHeight + this.lineSpacing) * lineCount + this.lineSpacing + this.margin.top + this.margin.bottom;
        if (textAreaPreferredSize.height < textAreaMinimumSize.height) {
            textAreaPreferredSize.height = textAreaMinimumSize.height;
        }
        this.textArea.setPreferredSize(textAreaPreferredSize);
        this.textArea.setMinimumSize(textAreaMinimumSize);
        this.numberedArea.lineCount = lineCount;
        int digitCount = 1;
        while (lineCount >= 10) {
            lineCount /= 10;
            ++digitCount;
        }
        this.numberedArea.digitCount = digitCount = digitCount >= 2 ? digitCount : 2;
        Dimension numberedAreaPreferredSize = this.numberedArea.getPreferredSize();
        Dimension numberedAreaMinimumSize = this.numberedArea.getMinimumSize();
        numberedAreaPreferredSize.width = this.maxCharacterWidth * (digitCount + 1) + this.margin.left + this.margin.right;
        numberedAreaPreferredSize.height = textAreaPreferredSize.height;
        numberedAreaMinimumSize.width = numberedAreaPreferredSize.width;
        numberedAreaMinimumSize.height = textAreaMinimumSize.height;
        this.numberedArea.setPreferredSize(numberedAreaPreferredSize);
        this.numberedArea.setMinimumSize(numberedAreaMinimumSize);
        this.textArea.revalidate();
        this.numberedArea.revalidate();
    }

    public void scrollToCaret() {
        if (this.textArea.hasFocus() || this.highlightedLine == -3 || this.highlightedLine >= 0 && this.highlightedLine < this.document.getLineCount()) {
            Rectangle significantRect = this.textArea.hasFocus() ? new Rectangle(this.modelToView(this.document.offsetToCoordinate(this.selection.getCaretPositionOffset()))) : (this.highlightedLine == -3 ? new Rectangle(this.modelToView(0, this.document.offsetToCoordinate((int)this.selection.getCaretPositionOffset()).y)) : new Rectangle(this.modelToView(0, this.highlightedLine)));
            significantRect.y -= this.characterHeight;
            significantRect.height = this.characterHeight + this.lineSpacing;
            significantRect.x -= this.maxCharacterWidth / 2;
            significantRect.width = this.maxCharacterWidth;
            this.textArea.scrollRectToVisible(significantRect);
        }
        this.repaint();
    }

    @Override
    public void textValueChanged(TextEvent e) {
        if (!this.supressReaction) {
            this.recalculateSizes();
            this.scrollToCaret();
        }
    }

    static {
        for (int ctr = 0; ctr < CHARACTER_STRINGS.length; ++ctr) {
            PHighlightedTextArea.CHARACTER_STRINGS[ctr] = String.valueOf((char)ctr);
        }
    }

    protected class InternalTextArea
    extends JComponent
    implements Runnable,
    HighlightedDocumentRenderer,
    Scrollable,
    ClipboardTarget {
        protected InternalTextArea() {
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.enableEvents(60L);
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public void paintComponent(Graphics g) {
            PHighlightedTextArea.this.document.allowRender(this, g);
        }

        @Override
        public boolean canCut() {
            return PHighlightedTextArea.this.canCut();
        }

        @Override
        public void cut() {
            PHighlightedTextArea.this.cut();
        }

        @Override
        public boolean canCopy() {
            return PHighlightedTextArea.this.canCopy();
        }

        @Override
        public void copy() {
            PHighlightedTextArea.this.copy();
        }

        @Override
        public boolean canPaste() {
            return PHighlightedTextArea.this.canPaste();
        }

        @Override
        public void paste() {
            PHighlightedTextArea.this.paste();
        }

        @Override
        public boolean canSelectAll() {
            return PHighlightedTextArea.this.canSelectAll();
        }

        @Override
        public void selectAll() {
            PHighlightedTextArea.this.selectAll();
        }

        @Override
        public void doRender(char[] chars, byte[] charStyles, int charCount, int[] lineOffsets, int lineCount, Object extraInfo) {
            Point p;
            Graphics g = (Graphics)extraInfo;
            Rectangle clip = g.getClipBounds();
            boolean monospaced = PHighlightedTextArea.this.monospaced;
            int maxCharacterWidth = PHighlightedTextArea.this.maxCharacterWidth;
            int characterHeight = PHighlightedTextArea.this.characterHeight;
            int lineSpacing = PHighlightedTextArea.this.lineSpacing;
            int caretPositionOffset = PHighlightedTextArea.this.selection.getCaretPositionOffset();
            Point caretPositionPoint = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
            int selectionStartOffset = PHighlightedTextArea.this.selection.getSelectionStartOffset();
            Point selectionStartPoint = PHighlightedTextArea.this.document.offsetToCoordinate(selectionStartOffset);
            int selectionEndOffset = PHighlightedTextArea.this.selection.getSelectionEndOffset();
            Point selectionEndPoint = PHighlightedTextArea.this.document.offsetToCoordinate(selectionEndOffset);
            int actualHighlightedLine = PHighlightedTextArea.this.highlightedLine;
            if (actualHighlightedLine == -3) {
                actualHighlightedLine = caretPositionPoint.y;
            } else if (actualHighlightedLine < 0 || actualHighlightedLine >= lineCount) {
                actualHighlightedLine = -1;
            }
            Color background = PHighlightedTextArea.this.getBackground();
            if (background != null) {
                g.setColor(background);
            } else {
                g.setColor(DEFAULT_BACKGROUND);
            }
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            if (PHighlightedTextArea.this.columnMarkers.length > 0 && PHighlightedTextArea.this.markerColor != null) {
                g.setColor(PHighlightedTextArea.this.markerColor);
                for (int ctr = 0; ctr < PHighlightedTextArea.this.columnMarkers.length; ++ctr) {
                    p = PHighlightedTextArea.this.modelToView(PHighlightedTextArea.this.columnMarkers[ctr], 0);
                    g.drawLine(p.x, clip.y, p.x, clip.y + clip.height);
                }
            }
            if (selectionStartOffset != selectionEndOffset && PHighlightedTextArea.this.selectionColor != null) {
                Point selectionStartPixel = PHighlightedTextArea.this.modelToView(selectionStartPoint);
                Point selectionEndPixel = PHighlightedTextArea.this.modelToView(selectionEndPoint);
                g.setColor(PHighlightedTextArea.this.selectionColor);
                if (selectionStartPoint.y == selectionEndPoint.y) {
                    g.fillRect(selectionStartPixel.x, selectionStartPixel.y - characterHeight, selectionEndPixel.x - selectionStartPixel.x, characterHeight + lineSpacing);
                } else {
                    g.fillRect(selectionStartPixel.x, selectionStartPixel.y - characterHeight, clip.x + clip.width - selectionStartPixel.x, characterHeight + lineSpacing);
                    g.fillRect(Math.max(((PHighlightedTextArea)PHighlightedTextArea.this).margin.left, clip.x), selectionStartPixel.y + lineSpacing, clip.width, (selectionEndPoint.y - selectionStartPoint.y - 1) * (characterHeight + lineSpacing));
                    g.fillRect(((PHighlightedTextArea)PHighlightedTextArea.this).margin.left, selectionEndPixel.y - characterHeight, selectionEndPixel.x - ((PHighlightedTextArea)PHighlightedTextArea.this).margin.left, characterHeight + lineSpacing);
                }
            }
            if (actualHighlightedLine != -1 && PHighlightedTextArea.this.highlightColor != null) {
                int y = PHighlightedTextArea.this.modelToView((int)0, (int)actualHighlightedLine).y;
                g.setColor(PHighlightedTextArea.this.highlightColor);
                g.drawLine(clip.x, y - characterHeight, clip.x + clip.width, y - characterHeight);
                g.drawLine(clip.x, y + lineSpacing, clip.x + clip.width, y + lineSpacing);
            }
            int lineStart = Math.max(0, PHighlightedTextArea.this.viewToModel((int)clip.x, (int)clip.y).y);
            int lineEnd = Math.min(lineCount, PHighlightedTextArea.this.viewToModel((int)clip.x, (int)(clip.y + clip.height)).y + 1);
            for (int lineCtr = lineStart; lineCtr < lineEnd; ++lineCtr) {
                int charStart = lineOffsets[lineCtr];
                int charEnd = lineCtr + 1 < lineCount ? lineOffsets[lineCtr + 1] - 1 : charCount;
                p = PHighlightedTextArea.this.modelToView(0, lineCtr);
                int charCtr = charStart;
                while (charCtr < charEnd) {
                    if (chars[charCtr] >= '!' && chars[charCtr] <= '~') {
                        int runEnd;
                        byte styleIndex = charStyles[charCtr];
                        int maxRunEnd = charCtr < selectionStartOffset ? Math.min(charEnd, selectionStartOffset) : (charCtr < selectionEndOffset ? Math.min(charEnd, selectionEndOffset) : charEnd);
                        for (runEnd = charCtr + 1; runEnd < maxRunEnd && charStyles[runEnd] == styleIndex && chars[runEnd] >= ' ' && chars[runEnd] <= '~'; ++runEnd) {
                        }
                        if (charCtr >= selectionStartOffset && charCtr < selectionEndOffset && PHighlightedTextArea.this.selectedTextColor != null) {
                            g.setColor(PHighlightedTextArea.this.selectedTextColor);
                        } else if (lineCtr == actualHighlightedLine && PHighlightedTextArea.this.highlightedTextColor != null) {
                            g.setColor(PHighlightedTextArea.this.highlightedTextColor);
                        } else if (!PHighlightedTextArea.this.isEnabled() && PHighlightedTextArea.this.disabledTextColor != null) {
                            g.setColor(PHighlightedTextArea.this.disabledTextColor);
                        } else {
                            g.setColor(PHighlightedTextArea.this.highlightStyles[styleIndex].getColor());
                        }
                        Font font = PHighlightedTextArea.this.highlightFonts[styleIndex];
                        g.setFont(font);
                        if (monospaced) {
                            g.drawChars(chars, charCtr, runEnd - charCtr, p.x, p.y);
                        } else {
                            int[] characterWidths = font.isBold() ? (font.isItalic() ? PHighlightedTextArea.this.boldItalicCharacterWidths : PHighlightedTextArea.this.boldCharacterWidths) : (font.isItalic() ? PHighlightedTextArea.this.italicCharacterWidths : PHighlightedTextArea.this.plainCharacterWidths);
                            for (int ctr = charCtr; ctr < runEnd; ++ctr) {
                                g.drawChars(chars, ctr, 1, p.x + (ctr - charCtr) * maxCharacterWidth + (maxCharacterWidth - characterWidths[chars[ctr]]) / 2, p.y);
                            }
                        }
                        p.x += maxCharacterWidth * (runEnd - charCtr);
                        charCtr = runEnd;
                        continue;
                    }
                    p.x += maxCharacterWidth;
                    ++charCtr;
                }
            }
            if (PHighlightedTextArea.this.isEnabled() && PHighlightedTextArea.this.editable && (PHighlightedTextArea.this.caretVisible && this.hasFocus() || PHighlightedTextArea.this.popupMenu != null && PHighlightedTextArea.this.popupMenu.isVisible())) {
                p = PHighlightedTextArea.this.modelToView(caretPositionPoint);
                if (PHighlightedTextArea.this.caretColor != null) {
                    g.setColor(PHighlightedTextArea.this.caretColor);
                } else {
                    Color foreground = PHighlightedTextArea.this.getForeground();
                    if (foreground != null) {
                        g.setColor(foreground);
                    } else {
                        g.setColor(DEFAULT_FOREGROUND);
                    }
                }
                if (PHighlightedTextArea.this.insertMode) {
                    g.drawLine(p.x, p.y - characterHeight, p.x, p.y + lineSpacing - 1);
                } else {
                    g.drawLine(p.x, p.y + lineSpacing - 2, p.x + maxCharacterWidth - 1, p.y + lineSpacing - 2);
                    g.drawLine(p.x, p.y + lineSpacing - 1, p.x + maxCharacterWidth - 1, p.y + lineSpacing - 1);
                }
            }
        }

        @Override
        public void run() {
            Point p;
            Thread thisThread = Thread.currentThread();
            while (PHighlightedTextArea.this.runner == thisThread) {
                if (PHighlightedTextArea.this.isEnabled() && PHighlightedTextArea.this.editable && this.hasFocus()) {
                    if (PHighlightedTextArea.this.keepCaretVisible) {
                        PHighlightedTextArea.this.caretVisible = true;
                        PHighlightedTextArea.this.keepCaretVisible = false;
                    } else {
                        PHighlightedTextArea.this.caretVisible = !PHighlightedTextArea.this.caretVisible;
                    }
                    p = PHighlightedTextArea.this.modelToView(PHighlightedTextArea.this.document.offsetToCoordinate(PHighlightedTextArea.this.selection.getCaretPositionOffset()));
                    this.repaint(p.x - 2, p.y - PHighlightedTextArea.this.characterHeight - 2, PHighlightedTextArea.this.maxCharacterWidth + 4, PHighlightedTextArea.this.characterHeight + PHighlightedTextArea.this.lineSpacing + 4);
                } else if (PHighlightedTextArea.this.caretVisible) {
                    PHighlightedTextArea.this.caretVisible = false;
                    p = PHighlightedTextArea.this.modelToView(PHighlightedTextArea.this.document.offsetToCoordinate(PHighlightedTextArea.this.selection.getCaretPositionOffset()));
                    this.repaint(p.x - 2, p.y - PHighlightedTextArea.this.characterHeight - 2, PHighlightedTextArea.this.maxCharacterWidth + 4, PHighlightedTextArea.this.characterHeight + PHighlightedTextArea.this.lineSpacing + 4);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {}
            }
            p = PHighlightedTextArea.this.modelToView(PHighlightedTextArea.this.document.offsetToCoordinate(PHighlightedTextArea.this.selection.getCaretPositionOffset()));
            this.repaint(p.x - 2, p.y - PHighlightedTextArea.this.characterHeight - 2, PHighlightedTextArea.this.maxCharacterWidth + 4, PHighlightedTextArea.this.characterHeight + PHighlightedTextArea.this.lineSpacing + 4);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 1: {
                    return visibleRect.height / 10;
                }
                case 0: {
                    return visibleRect.width / 10;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 1: {
                    return visibleRect.height;
                }
                case 0: {
                    return visibleRect.width;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
            }
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
            }
            return false;
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1004) {
                ClipboardTargetManager.targetGainedFocus(this);
                PHighlightedTextArea.this.runner = new Thread(this);
                PHighlightedTextArea.this.runner.start();
            } else if (e.getID() == 1005) {
                ClipboardTargetManager.targetLostFocus(this);
                PHighlightedTextArea.this.runner = null;
            }
            super.processFocusEvent(e);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            char ch;
            if (!PHighlightedTextArea.this.isEnabled()) {
                return;
            }
            PHighlightedTextArea.this.supressReaction = true;
            if (PHighlightedTextArea.this.autoCompleter.interceptKeyEvent(PHighlightedTextArea.this, e)) {
                PHighlightedTextArea.this.recalculateSizes();
                PHighlightedTextArea.this.scrollToCaret();
                e.consume();
                return;
            }
            if (e.getID() == 401) {
                int caretPositionOffset = PHighlightedTextArea.this.selection.getCaretPositionOffset();
                int selectionStartOffset = PHighlightedTextArea.this.selection.getSelectionStartOffset();
                int selectionEndOffset = PHighlightedTextArea.this.selection.getSelectionEndOffset();
                boolean handled = true;
                switch (e.getKeyCode()) {
                    case 127: {
                        if (selectionStartOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.document.remove(selectionStartOffset, selectionEndOffset - selectionStartOffset, false);
                            selectionStartOffset = PHighlightedTextArea.this.selection.getSelectionStartOffset();
                            PHighlightedTextArea.this.select(selectionStartOffset, selectionStartOffset, selectionStartOffset);
                        } else {
                            PHighlightedTextArea.this.document.remove(caretPositionOffset, 1, true);
                        }
                        PHighlightedTextArea.this.recalculateSizes();
                        break;
                    }
                    case 155: {
                        PHighlightedTextArea.this.setInsertMode(!PHighlightedTextArea.this.insertMode);
                        break;
                    }
                    case 8: {
                        if (selectionStartOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.document.remove(selectionStartOffset, selectionEndOffset - selectionStartOffset, false);
                            selectionStartOffset = PHighlightedTextArea.this.selection.getSelectionStartOffset();
                            PHighlightedTextArea.this.select(selectionStartOffset, selectionStartOffset, selectionStartOffset);
                        } else if (caretPositionOffset > 0) {
                            PHighlightedTextArea.this.document.remove(caretPositionOffset - 1, 1, true);
                        }
                        PHighlightedTextArea.this.recalculateSizes();
                        break;
                    }
                    case 37: {
                        int offset = caretPositionOffset - 1;
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 39: {
                        int offset = caretPositionOffset + 1;
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 38: {
                        Point p = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(p.x, p.y - 1);
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 40: {
                        Point p = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(p.x, p.y + 1);
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 33: {
                        int pageSize = PHighlightedTextArea.this.getViewport().getVisibleRect().height / (PHighlightedTextArea.this.characterHeight + PHighlightedTextArea.this.lineSpacing);
                        Point p = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(p.x, p.y - pageSize);
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 34: {
                        int pageSize = PHighlightedTextArea.this.getViewport().getVisibleRect().height / (PHighlightedTextArea.this.characterHeight + PHighlightedTextArea.this.lineSpacing);
                        Point p = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(p.x, p.y + pageSize);
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 36: {
                        Point p = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(0, p.y);
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    case 35: {
                        Point p = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(Integer.MAX_VALUE, p.y);
                        if (!e.isShiftDown() || caretPositionOffset != selectionStartOffset && caretPositionOffset != selectionEndOffset) {
                            PHighlightedTextArea.this.select(offset, offset, offset);
                            break;
                        }
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                        break;
                    }
                    default: {
                        handled = false;
                    }
                }
                if (handled) {
                    e.consume();
                    PHighlightedTextArea.this.caretVisible = true;
                    PHighlightedTextArea.this.keepCaretVisible = true;
                    PHighlightedTextArea.this.scrollToCaret();
                }
            }
            if (!(e.getID() != 400 || ((ch = e.getKeyChar()) < ' ' || ch > '~') && ch != '\r' && ch != '\n' && ch != '\t' || e.isAltDown() || e.isControlDown() || e.isMetaDown() || e.isAltGraphDown())) {
                if (PHighlightedTextArea.this.editable) {
                    int caretPositionOffset = PHighlightedTextArea.this.selection.getCaretPositionOffset();
                    int selectionStartOffset = PHighlightedTextArea.this.selection.getSelectionStartOffset();
                    int selectionEndOffset = PHighlightedTextArea.this.selection.getSelectionEndOffset();
                    String string = CHARACTER_STRINGS[ch];
                    if (selectionStartOffset != selectionEndOffset) {
                        PHighlightedTextArea.this.document.replace(selectionStartOffset, selectionEndOffset - selectionStartOffset, string, false);
                    } else if (PHighlightedTextArea.this.insertMode) {
                        PHighlightedTextArea.this.document.insertString(selectionStartOffset, string, true);
                    } else {
                        PHighlightedTextArea.this.document.replace(selectionStartOffset, string.length(), string, true);
                    }
                    selectionStartOffset = PHighlightedTextArea.this.selection.getSelectionStartOffset();
                    PHighlightedTextArea.this.select(selectionStartOffset, selectionStartOffset, selectionStartOffset);
                    PHighlightedTextArea.this.caretVisible = true;
                    PHighlightedTextArea.this.keepCaretVisible = true;
                    PHighlightedTextArea.this.recalculateSizes();
                    PHighlightedTextArea.this.scrollToCaret();
                }
                e.consume();
            }
            if (e.getKeyCode() == 9 || e.getKeyChar() == '\t') {
                e.consume();
            }
            PHighlightedTextArea.this.supressReaction = false;
            super.processKeyEvent(e);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (!PHighlightedTextArea.this.isEnabled()) {
                return;
            }
            boolean passedToSuper = false;
            if (PHighlightedTextArea.this.popupMenu != null && e.isPopupTrigger()) {
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
                if (PHighlightedTextArea.this.selection.getSelectionDotOffset() == PHighlightedTextArea.this.selection.getSelectionMarkOffset()) {
                    int offset = PHighlightedTextArea.this.document.coordinateToOffset(PHighlightedTextArea.this.viewToModel(e.getX(), e.getY()));
                    PHighlightedTextArea.this.select(offset, offset, offset);
                }
                int x = e.getX();
                int y = e.getY();
                Point componentLocation = this.getLocationOnScreen();
                Dimension screenSize = TOOLKIT.getScreenSize();
                Dimension preferredSize = PHighlightedTextArea.this.popupMenu.getPreferredSize();
                if (componentLocation.x + x + preferredSize.width > screenSize.width) {
                    x -= preferredSize.width;
                }
                if (componentLocation.y + y + preferredSize.height > screenSize.height) {
                    y -= preferredSize.height;
                }
                e.consume();
                passedToSuper = true;
                super.processMouseEvent(e);
                PHighlightedTextArea.this.popupMenu.show(this, x, y);
                this.repaint();
            } else if ((e.getModifiers() & 0x10) != 0) {
                if (e.getID() == 501) {
                    if (!this.hasFocus()) {
                        this.requestFocus();
                    }
                    int offset = PHighlightedTextArea.this.document.coordinateToOffset(PHighlightedTextArea.this.viewToModel(e.getX(), e.getY()));
                    if (e.isShiftDown()) {
                        PHighlightedTextArea.this.selection;
                        PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                    } else {
                        PHighlightedTextArea.this.select(offset, offset, offset);
                    }
                    PHighlightedTextArea.this.caretVisible = true;
                    PHighlightedTextArea.this.keepCaretVisible = true;
                    PHighlightedTextArea.this.scrollToCaret();
                    e.consume();
                }
                if (e.getID() == 500 && e.getClickCount() > 1) {
                    if (e.getClickCount() % 2 == 0) {
                        int[] wordBounds = PHighlightedTextArea.this.document.getWordBounds(PHighlightedTextArea.this.document.coordinateToOffset(PHighlightedTextArea.this.viewToModel(e.getX(), e.getY())));
                        PHighlightedTextArea.this.select(wordBounds[0], wordBounds[1], wordBounds[1]);
                    } else {
                        int line = PHighlightedTextArea.this.viewToModel((int)e.getX(), (int)e.getY()).y;
                        int offset = PHighlightedTextArea.this.document.coordinateToOffset(0, line);
                        PHighlightedTextArea.this.select(offset, PHighlightedTextArea.this.document.coordinateToOffset(Integer.MAX_VALUE, line), offset);
                    }
                    PHighlightedTextArea.this.caretVisible = true;
                    PHighlightedTextArea.this.keepCaretVisible = true;
                    PHighlightedTextArea.this.scrollToCaret();
                    e.consume();
                }
            }
            if (!passedToSuper) {
                super.processMouseEvent(e);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            if (!PHighlightedTextArea.this.isEnabled()) {
                return;
            }
            if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0) {
                int offset = PHighlightedTextArea.this.document.coordinateToOffset(PHighlightedTextArea.this.viewToModel(e.getX(), e.getY()));
                PHighlightedTextArea.this.selection;
                PHighlightedTextArea.this.select(offset, Integer.MIN_VALUE, offset);
                PHighlightedTextArea.this.caretVisible = true;
                PHighlightedTextArea.this.keepCaretVisible = true;
                PHighlightedTextArea.this.scrollToCaret();
                e.consume();
            }
            super.processMouseMotionEvent(e);
        }
    }

    protected class InternalNumberedArea
    extends JComponent {
        private int anchorLine;
        protected int lineCount;
        protected int digitCount;

        protected InternalNumberedArea() {
            this.enableEvents(48L);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle clip = g.getClipBounds();
            char[] chars = new char[this.digitCount];
            boolean monospaced = PHighlightedTextArea.this.monospaced;
            int maxCharacterWidth = PHighlightedTextArea.this.maxCharacterWidth;
            int characterHeight = PHighlightedTextArea.this.characterHeight;
            int lineSpacing = PHighlightedTextArea.this.lineSpacing;
            int caretPositionOffset = PHighlightedTextArea.this.selection.getCaretPositionOffset();
            Point caretPositionPoint = PHighlightedTextArea.this.document.offsetToCoordinate(caretPositionOffset);
            int actualHighlightedLine = PHighlightedTextArea.this.highlightedLine;
            if (actualHighlightedLine == -3) {
                actualHighlightedLine = caretPositionPoint.y;
            } else if (actualHighlightedLine < 0 || actualHighlightedLine >= this.lineCount) {
                actualHighlightedLine = -1;
            }
            Color background = PHighlightedTextArea.this.getBackground();
            if (background != null) {
                g.setColor(background);
            } else {
                g.setColor(DEFAULT_BACKGROUND);
            }
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            if (actualHighlightedLine != -1 && PHighlightedTextArea.this.highlightColor != null) {
                int y = PHighlightedTextArea.this.modelToView((int)0, (int)actualHighlightedLine).y;
                g.setColor(PHighlightedTextArea.this.highlightColor);
                g.drawLine(clip.x, y - characterHeight, clip.x + clip.width, y - characterHeight);
                g.drawLine(clip.x, y + lineSpacing, clip.x + clip.width, y + lineSpacing);
            }
            int lineStart = Math.max(0, PHighlightedTextArea.this.viewToModel((int)clip.x, (int)clip.y).y);
            int lineEnd = Math.min(this.lineCount, PHighlightedTextArea.this.viewToModel((int)clip.x, (int)(clip.y + clip.height)).y + 1);
            if (PHighlightedTextArea.this.lineNumberColor != null) {
                g.setColor(PHighlightedTextArea.this.lineNumberColor);
            } else {
                Color foreground = PHighlightedTextArea.this.getForeground();
                if (foreground != null) {
                    g.setColor(foreground);
                } else {
                    g.setColor(DEFAULT_FOREGROUND);
                }
            }
            Font font = PHighlightedTextArea.this.getFont();
            g.setFont(font);
            Point p = PHighlightedTextArea.this.modelToView(0, lineStart);
            for (int lineCtr = lineStart; lineCtr < lineEnd; ++lineCtr) {
                if (lineCtr == actualHighlightedLine && PHighlightedTextArea.this.highlightedTextColor != null) {
                    g.setColor(PHighlightedTextArea.this.highlightedTextColor);
                }
                int tempInt = lineCtr + 1;
                for (int ctr = this.digitCount - 1; ctr >= 0; --ctr) {
                    if (tempInt == 0) {
                        chars[ctr] = 32;
                        continue;
                    }
                    chars[ctr] = (char)(48 + tempInt % 10);
                    tempInt /= 10;
                }
                if (monospaced) {
                    g.drawChars(chars, 0, this.digitCount, p.x, p.y);
                } else {
                    int[] characterWidths = font.isBold() ? (font.isItalic() ? PHighlightedTextArea.this.boldItalicCharacterWidths : PHighlightedTextArea.this.boldCharacterWidths) : (font.isItalic() ? PHighlightedTextArea.this.italicCharacterWidths : PHighlightedTextArea.this.plainCharacterWidths);
                    for (int ctr = 0; ctr < this.digitCount; ++ctr) {
                        g.drawChars(chars, ctr, 1, p.x + ctr * maxCharacterWidth + (maxCharacterWidth - characterWidths[chars[ctr]]) / 2, p.y);
                    }
                }
                p.y += characterHeight + lineSpacing;
                if (lineCtr != actualHighlightedLine || PHighlightedTextArea.this.highlightedTextColor == null) continue;
                if (PHighlightedTextArea.this.lineNumberColor != null) {
                    g.setColor(PHighlightedTextArea.this.lineNumberColor);
                    continue;
                }
                Color foreground = PHighlightedTextArea.this.getForeground();
                if (foreground != null) {
                    g.setColor(foreground);
                    continue;
                }
                g.setColor(DEFAULT_FOREGROUND);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (!PHighlightedTextArea.this.isEnabled()) {
                return;
            }
            boolean passedToSuper = false;
            if (PHighlightedTextArea.this.popupMenu != null && e.isPopupTrigger()) {
                if (!PHighlightedTextArea.this.textArea.hasFocus()) {
                    PHighlightedTextArea.this.textArea.requestFocus();
                }
                int x = e.getX();
                int y = e.getY();
                Point componentLocation = this.getLocationOnScreen();
                Dimension screenSize = TOOLKIT.getScreenSize();
                Dimension preferredSize = PHighlightedTextArea.this.popupMenu.getPreferredSize();
                if (componentLocation.x + x + preferredSize.width > screenSize.width) {
                    x -= preferredSize.width;
                }
                if (componentLocation.y + y + preferredSize.height > screenSize.height) {
                    y -= preferredSize.height;
                }
                e.consume();
                passedToSuper = true;
                super.processMouseEvent(e);
                PHighlightedTextArea.this.popupMenu.show(this, x, y);
                this.repaint();
            } else if (e.getID() == 501 && (e.getModifiers() & 0x10) != 0) {
                if (!PHighlightedTextArea.this.textArea.hasFocus()) {
                    PHighlightedTextArea.this.textArea.requestFocus();
                }
                Point coordinate = PHighlightedTextArea.this.viewToModel(e.getX(), e.getY());
                this.anchorLine = coordinate.y;
                int offset = PHighlightedTextArea.this.document.coordinateToOffset(0, coordinate.y);
                PHighlightedTextArea.this.select(offset, PHighlightedTextArea.this.document.coordinateToOffset(Integer.MAX_VALUE, coordinate.y), offset);
                PHighlightedTextArea.this.caretVisible = true;
                PHighlightedTextArea.this.keepCaretVisible = true;
                PHighlightedTextArea.this.scrollToCaret();
                e.consume();
            }
            if (!passedToSuper) {
                super.processMouseEvent(e);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            if (!PHighlightedTextArea.this.isEnabled()) {
                return;
            }
            if (e.getID() == 506 && (e.getModifiers() & 0x10) != 0) {
                Point coordinate = PHighlightedTextArea.this.viewToModel(e.getX(), e.getY());
                if (coordinate.y <= this.anchorLine) {
                    int offset = PHighlightedTextArea.this.document.coordinateToOffset(0, coordinate.y);
                    PHighlightedTextArea.this.select(offset, PHighlightedTextArea.this.document.coordinateToOffset(Integer.MAX_VALUE, this.anchorLine), offset);
                } else {
                    PHighlightedTextArea.this.select(PHighlightedTextArea.this.document.coordinateToOffset(0, this.anchorLine), PHighlightedTextArea.this.document.coordinateToOffset(Integer.MAX_VALUE, coordinate.y), PHighlightedTextArea.this.document.coordinateToOffset(0, coordinate.y));
                }
                PHighlightedTextArea.this.caretVisible = true;
                PHighlightedTextArea.this.keepCaretVisible = true;
                PHighlightedTextArea.this.scrollToCaret();
                e.consume();
            }
            super.processMouseMotionEvent(e);
        }
    }
}

