/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private String[] extensions;
    private int extensionCount;
    private String description;
    private String baseDescription;

    public ExtensionFileFilter() {
        this(null, "");
    }

    public ExtensionFileFilter(String baseDescription) {
        this(null, baseDescription);
    }

    public ExtensionFileFilter(String extension, String baseDescription) {
        if (baseDescription == null) {
            throw new NullPointerException();
        }
        this.baseDescription = baseDescription;
        this.extensions = new String[10];
        if (extension != null) {
            this.extensions[0] = "." + extension;
            this.extensionCount = 1;
        } else {
            this.extensionCount = 0;
        }
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName();
        for (int ctr = 0; ctr < this.extensionCount; ++ctr) {
            if (!fileName.endsWith(this.extensions[ctr])) continue;
            return true;
        }
        return false;
    }

    public int getExtensionCount() {
        return this.extensionCount;
    }

    public String getExtension(int index) {
        if (index < 0 || index >= this.extensionCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.extensions[index].substring(1);
    }

    public void addExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException();
        }
        if (this.extensionCount == this.extensions.length) {
            String[] oldExtensions = this.extensions;
            this.extensions = new String[this.extensionCount * 2 + 1];
            for (int ctr = 0; ctr < this.extensionCount; ++ctr) {
                this.extensions[ctr] = oldExtensions[ctr];
            }
        }
        this.extensions[this.extensionCount] = "." + extension;
        ++this.extensionCount;
        this.description = null;
    }

    public void clearExtensions() {
        this.extensionCount = 0;
        this.description = null;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            StringBuffer buffer = new StringBuffer(this.baseDescription);
            buffer.append(" (");
            for (int ctr = 0; ctr < this.extensionCount; ++ctr) {
                buffer.append('*');
                buffer.append(this.extensions[ctr]);
                if (ctr >= this.extensionCount - 1) continue;
                buffer.append(';');
            }
            buffer.append(')');
            this.description = buffer.toString();
        }
        return this.description;
    }

    public void setBaseDescription(String baseDescription) {
        if (baseDescription == null) {
            throw new NullPointerException();
        }
        this.baseDescription = baseDescription;
    }
}

