/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.TristateButtonModel;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;

public class DefaultTristateButtonModel
extends JToggleButton.ToggleButtonModel
implements TristateButtonModel {
    private boolean tristate;

    public DefaultTristateButtonModel() {
        this.tristate = false;
    }

    public DefaultTristateButtonModel(ButtonModel model) {
        this.stateMask = (model.isArmed() ? 1 : 0) | (model.isEnabled() ? 8 : 0) | (model.isPressed() ? 4 : 0) | (model.isRollover() ? 16 : 0) | (model.isSelected() ? 2 : 0);
        this.actionCommand = model.getActionCommand();
        this.mnemonic = model.getMnemonic();
        this.tristate = false;
    }

    @Override
    public boolean isTristate() {
        return this.tristate;
    }

    @Override
    public void setTristate(boolean tristate) {
        if (tristate == this.tristate) {
            return;
        }
        this.tristate = tristate;
        if (tristate && !this.isSelected()) {
            super.setSelected(true);
        } else {
            this.fireStateChanged();
        }
    }

    @Override
    public void setSelected(boolean b) {
        if (!this.tristate && this.isSelected() == b) {
            return;
        }
        this.tristate = false;
        if (this.isSelected() != b) {
            super.setSelected(b);
        } else {
            this.fireStateChanged();
        }
    }
}

