/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import edu.princeton.swing.AbstractAction2;
import edu.princeton.swing.ClipboardTarget;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ClipboardTargetManager {
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    public static final byte[] CUT_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 24, 0, 24, 0, -77, -1, 0, 0, 0, 0, -1, -1, -1, -64, -64, -64, 107, 107, -57, 120, 120, -44, -14, -14, -14, -39, -39, -39, -105, -105, -105, -118, -118, -118, -122, -122, -122, 121, 121, 121, 36, 36, 36, 13, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 2, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 0, 4, -95, 80, -56, 73, -85, -67, 12, -124, 59, 1, 43, -100, -90, -123, -63, -120, 21, -119, -78, 85, 74, 82, 124, 92, -5, -126, -43, -25, 114, -110, 54, 83, 95, -71, 114, -87, -128, 76, 18, 84, -31, 38, 61, -109, 14, 118, 20, -56, 74, 9, -35, -83, -103, 11, -96, 116, 62, 106, -57, 87, -56, 106, 37, 25, -97, -121, -10, -59, -118, 126, -44, 113, -8, -91, 107, 70, 25, -117, -116, 28, -111, 57, -112, 45, -116, 1, 65, -81, 6, -20, -9, 76, 21, 9, 124, 121, 4, 11, 1, 8, -128, 126, 3, 118, 22, 126, 75, 3, 31, 121, 73, 4, 38, 60, -111, 32, -113, 37, -107, 27, -109, 119, 18, 10, -118, 123, 46, 7, -124, 122, 8, 104, 18, -101, 122, -104, 6, 47, -84, -100, -97, -86, 10, 25, 46, 6, 18, 5, 7, 30, -88, -78, 19, 86, 86, -73, 19, 93, -61, 95, -59, 17, 0, 59, -77, -81, -52, -78, -82, -53, -76, -80, -52, -62, -66, -36, -73, -77, -49, -75, -79, -51, -53, -57, -29, -51, -54, -31, -52, -55, -32, -43, -46, -24, -44, -47, -25, -45, -48, -26, -23, -26, -4, -100, -104, -72, -94, -98, -66, -82, -85, -56, -83, -86, -57, -85, -88, -59, -78, -81, -52, -83, -86, -58, -85, -88, -60, -73, -76, -49, -70, -73, -47, -71, -74, -48, -63, -66, -40, -66, -69, -44, -68, -71, -46, -60, -63, -38, -61, -64, -39, -63, -66, -41, -38, -41, -15, -31, -34, -10, -30, -32, -13, -34, -36, -17, -17, -19, -1, -23, -25, -8, -66, -68, -43, -56, -58, -34, -52, -54, -31, -53, -55, -32, -54, -56, -33, -45, -47, -25, -48, -50, -28, -31, -33, -10, -42, -44, -23, -48, -50, -29, -24, -26, -4, -35, -37, -17, -36, -38, -18, -37, -39, -19, -10, -11, -1, -46, -48, -22, -28, -29, -11, -29, -30, -11, -29, -29, -11, -40, -40, -38, -41, -41, -39, -38, -38, -38, -39, -39, -39, -74, -74, -74, 13, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 1, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 0, 8, -1, 0, 3, 8, 28, 72, -80, -96, -63, -125, -119, 18, 42, 92, -56, 16, 0, 66, 68, 0, 34, 74, -100, 40, 17, 81, 34, -121, 5, 47, 50, -36, -104, -16, -60, 69, -125, 26, -33, 28, -23, -127, -28, 77, 22, 54, 69, 0, 77, -127, -110, -56, 35, 70, -126, 26, -113, -76, 9, -44, -58, -49, -107, 42, 68, -126, 60, 9, -45, -14, 99, 70, 0, -119, -2, 8, -126, 51, -56, -115, -107, 57, 68, -128, 72, -15, -46, -13, -27, 64, -115, 72, -38, 8, -86, 105, 7, -89, 78, 38, 77, 65, 2, 125, -45, -121, -113, -97, 60, 119, -28, -108, 25, -29, 4, -85, 75, -83, -119, -10, 92, -79, -126, 69, 79, -99, 33, 102, -94, 112, 89, -110, -11, 103, 34, 60, 116, -88, -48, 49, 50, 36, -114, -112, 47, 94, -110, -44, -123, 9, 116, 13, 17, 52, 105, -44, -4, 32, -13, -92, -53, 18, 31, -125, -97, 2, 5, 116, 6, 72, -112, 49, 98, -102, -128, 81, -78, 69, 75, 100, -127, 26, 57, 50, 60, -101, 17, -59, -119, -45, -88, 83, -93, 70, -31, 19, -76, -24, -41, 10, 37, 83, -100, 77, -37, -25, 69, 67, 2, 36, -28, -112, -47, -126, -122, -115, 26, 31, 6, 40, 48, -47, 97, -61, -127, 11, 5, 108, 3, 48, 20, 65, -62, -114, 7, 46, 104, -64, 0, -15, -127, -127, -118, 10, 20, 38, -92, 8, 49, 66, -71, -128, 67, 56, 32, -36, 51, -104, 97, -61, 65, -125, 15, 30, 18, 112, -48, -128, -127, -124, -120, 21, -34, 9, 21, -30, -47, -62, -123, -114, 24, 47, 22, 16, 40, -127, 64, -125, -127, 12, 44, 88, 96, 27, 108, -80, -67, 68, -37, -127, -77, 29, -92, -32, -126, 1, 4, 4, 0, 33, -2, 79, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 50, 48, 48, 48, 32, 98, 121, 32, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 44, 32, 73, 110, 99, 46, 32, 65, 108, 108, 32, 82, 105, 103, 104, 116, 115, 32, 82, 101, 115, 101, 114, 118, 101, 100, 46, 13, 10, 74, 76, 70, 32, 71, 82, 32, 86, 101, 114, 32, 49, 46, 48, 13, 10, 0, 59};
    public static final Icon CUT_ICON = new ImageIcon(TOOLKIT.createImage(CUT_ICON_BYTES), "Cut");
    public static final byte[] COPY_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 24, 0, 24, 0, -26, -1, 0, -1, -1, -1, -25, -25, -1, -25, -26, -1, -26, -25, -1, -26, -26, -1, -27, -27, -1, -27, -27, -2, -28, -28, -3, -29, -29, -3, -30, -30, -4, -31, -31, -5, -32, -32, -7, -33, -33, -7, -34, -34, -8, -35, -35, -10, -36, -36, -11, -38, -38, -12, -39, -38, -13, -39, -39, -14, -40, -40, -15, -41, -41, -16, -44, -44, -19, -45, -45, -20, -46, -46, -21, -47, -47, -22, -48, -48, -23, -51, -51, -25, -51, -51, -26, -52, -52, -1, -52, -52, -26, -77, -77, -52, -77, -78, -52, -78, -77, -52, -78, -78, -52, -78, -78, -53, -79, -79, -53, -80, -80, -54, -80, -81, -55, -81, -80, -55, -82, -81, -56, -82, -82, -56, -82, -82, -57, -83, -83, -58, -84, -84, -59, -85, -85, -60, -86, -86, -60, -87, -87, -62, -89, -89, -63, -90, -90, -64, -91, -90, -65, -92, -91, -66, -92, -92, -66, -93, -92, -67, -93, -93, -67, -94, -94, -68, -96, -96, -70, -97, -97, -71, -98, -98, -72, -99, -99, -73, -101, -101, -76, -102, -102, -77, -103, -103, -77, -103, -103, -78, 0, 0, 0, -64, -64, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 64, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 64, 7, -76, -128, 64, -126, -125, -124, -123, -122, -122, 63, 0, 26, 49, 12, -119, 58, 26, -113, 63, 28, 28, 63, -121, -126, 63, -104, -103, 0, 39, 1, 30, -99, 1, 41, 20, 58, -119, -120, -118, -113, -93, -109, -107, -106, -123, -119, -97, -114, -117, 14, -100, -98, -104, -85, -125, -103, -73, -72, 0, -120, -72, -103, -75, -84, -90, 21, -68, -67, -85, -119, 14, -77, 0, -89, 21, 49, 1, -110, -86, -91, -82, 0, 49, 14, 37, -97, -98, 41, -92, -75, -119, -98, -42, 20, 56, -112, -40, -66, -31, -30, -29, -105, 0, -26, -25, -76, -29, -81, 58, 21, 47, -51, -22, -56, -117, -119, -25, -26, -23, -106, -119, -46, 30, -119, -112, -112, -63, -108, -60, 0, -88, -23, 51, -75, 40, 0, 53, 123, -65, -74, -19, -53, 87, -115, -103, -82, -124, -96, -118, -103, 104, -8, 34, -40, -61, 66, -12, 90, 109, 3, -43, 77, 3, -72, 123, 0, 62, -99, -96, 16, -125, -33, 71, 75, -12, 82, -98, 35, 23, 46, 16, 0, 33, -2, 79, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 50, 48, 48, 48, 32, 98, 121, 32, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 44, 32, 73, 110, 99, 46, 32, 65, 108, 108, 32, 82, 105, 103, 104, 116, 115, 32, 82, 101, 115, 101, 114, 118, 101, 100, 46, 13, 10, 74, 76, 70, 32, 71, 82, 32, 86, 101, 114, 32, 49, 46, 48, 13, 10, 0, 59};
    public static final Icon COPY_ICON = new ImageIcon(TOOLKIT.createImage(COPY_ICON_BYTES), "Copy");
    public static final byte[] PASTE_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 24, 0, 24, 0, -60, -1, 0, -1, -1, -1, -24, -46, -68, -24, -47, -68, -25, -47, -68, -25, -47, -69, -37, -56, -75, -37, -56, -76, -37, -57, -76, -38, -57, -76, -50, -67, -83, -52, -52, -52, -62, -63, -62, -63, -63, -63, -64, -64, -64, -75, -97, -119, -75, -98, -119, -76, -98, -119, -82, -102, -122, -82, -102, -123, -82, -103, -122, -82, -103, -123, -96, -113, 125, -96, -114, 125, -102, -118, 122, -103, -103, -103, 99, 99, 99, 99, 49, 49, 0, 0, 0, -64, -64, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 28, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 64, 5, -96, 32, 39, -114, 100, 105, -98, -36, 6, 36, 23, -101, 84, 71, 52, 56, 26, -128, -118, -22, 60, 7, -47, 81, -79, -75, 27, 78, -109, 1, 96, 22, -118, 69, 70, -77, 17, -30, 86, 48, -103, 99, 23, 9, -34, 84, -68, -62, -81, -59, -75, 58, 57, 69, 0, 32, -13, 29, -87, 52, -24, 116, -70, 106, -69, -82, 90, 81, 29, -83, -115, 82, -59, -28, -125, -120, -42, 123, -54, 77, 123, 91, 64, 116, 55, 98, -123, -122, 98, 101, 35, 25, -117, -119, 37, 97, 27, 72, 100, 101, 103, 98, 72, 11, 24, 24, 53, 26, 78, 42, 92, 46, 113, 124, 38, -99, -97, 119, 83, -95, 37, -93, 113, 83, -90, -125, -94, 0, -86, 58, 61, -89, 36, 42, 82, 84, 90, 9, -77, 102, 0, -85, 121, -72, 45, -70, 79, 14, 60, 62, 46, -64, -83, 38, 106, -54, 104, -120, -115, 101, 33, 0, 33, -2, 79, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 50, 48, 48, 48, 32, 98, 121, 32, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 44, 32, 73, 110, 99, 46, 32, 65, 108, 108, 32, 82, 105, 103, 104, 116, 115, 32, 82, 101, 115, 101, 114, 118, 101, 100, 46, 13, 10, 74, 76, 70, 32, 71, 82, 32, 86, 101, 114, 32, 49, 46, 48, 13, 10, 0, 59};
    public static final Icon PASTE_ICON = new ImageIcon(TOOLKIT.createImage(PASTE_ICON_BYTES), "Paste");
    public static final byte[] SELECT_ALL_ICON_BYTES = new byte[]{71, 73, 70, 56, 57, 97, 24, 0, 24, 0, -9, 0, 0, 0, 0, 0, 13, 13, 13, -99, -99, -73, -97, -97, -71, -91, -90, -65, -89, -89, -63, -82, -82, -57, -82, -81, -56, -81, -80, -55, -80, -81, -55, -77, -77, -52, -64, -64, -64, -51, -51, -25, -52, -52, -1, -44, -44, -19, -41, -41, -16, -35, -35, -10, -25, -25, -1, -1, -1, -1, -64, -64, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, -7, 4, 1, 0, 0, 19, 0, 44, 0, 0, 0, 0, 24, 0, 24, 0, 0, 8, -76, 0, 39, 8, 28, 72, -80, -96, 65, -126, 1, 2, 8, 76, -88, 112, 2, -61, -123, 9, 33, 14, 108, 120, -80, -30, 66, -117, 24, 51, 10, 4, -64, -79, 99, 71, -116, 20, 39, 0, -112, 64, -78, 36, 71, -125, 20, 67, -114, 20, -64, -128, 37, -128, 6, 13, 0, 20, 76, 73, 112, 100, -53, -106, 14, 94, -54, 68, 88, 113, 37, 78, 2, 17, 116, 106, 20, 41, -31, 38, -48, 4, 65, 119, -94, -84, 41, -127, 37, 1, 8, 7, 34, 40, 72, 58, -79, -22, 64, -101, 79, -89, 106, 13, 106, -43, 33, -45, -89, 72, -73, 26, 80, 26, -110, 41, 4, 4, 82, -45, 22, -56, -87, 113, 100, 84, -79, 15, 4, 40, -27, 121, 85, 66, -38, -87, 6, 30, 12, 96, 64, -74, 43, 81, -72, 123, -27, 118, 85, 105, 119, -22, -127, 7, 4, 110, -10, 61, -24, -79, -15, -57, -95, -112, -3, 70, 78, -39, -16, -95, -61, -120, -105, 43, -105, -115, -52, 25, 114, 64, 0, 0, 59};
    public static final Icon SELECT_ALL_ICON = new ImageIcon(TOOLKIT.createImage(SELECT_ALL_ICON_BYTES), "Select All");
    public static final KeyStroke CUT_KEYSTROKE = KeyStroke.getKeyStroke(88, TOOLKIT.getMenuShortcutKeyMask());
    public static final KeyStroke COPY_KEYSTROKE = KeyStroke.getKeyStroke(67, TOOLKIT.getMenuShortcutKeyMask());
    public static final KeyStroke PASTE_KEYSTROKE = KeyStroke.getKeyStroke(86, TOOLKIT.getMenuShortcutKeyMask());
    public static final KeyStroke SELECT_ALL_KEYSTROKE = KeyStroke.getKeyStroke(65, TOOLKIT.getMenuShortcutKeyMask());
    public static final AbstractAction2 CUT_ACTION = new CutAction();
    public static final AbstractAction2 COPY_ACTION = new CopyAction();
    public static final AbstractAction2 PASTE_ACTION = new PasteAction();
    public static final AbstractAction2 SELECT_ALL_ACTION = new SelectAllAction();
    private static final ClipboardTargetManager INSTANCE = new ClipboardTargetManager();
    private ClipboardTarget lastFocusedTarget = null;

    private ClipboardTargetManager() {
    }

    public static void installMappings(JComponent component) {
        InputMap inputMap = component.getInputMap();
        ActionMap actionMap = component.getActionMap();
        Object cutKey = inputMap.get(CUT_KEYSTROKE);
        if (cutKey == null) {
            cutKey = "cut";
        }
        inputMap.put(CUT_KEYSTROKE, cutKey);
        actionMap.put(cutKey, CUT_ACTION);
        Object copyKey = inputMap.get(COPY_KEYSTROKE);
        if (copyKey == null || copyKey.equals(cutKey)) {
            copyKey = "copy";
        }
        inputMap.put(COPY_KEYSTROKE, copyKey);
        actionMap.put(copyKey, COPY_ACTION);
        Object pasteKey = inputMap.get(PASTE_KEYSTROKE);
        if (pasteKey == null || pasteKey.equals(cutKey) || pasteKey.equals(copyKey)) {
            pasteKey = "paste";
        }
        inputMap.put(PASTE_KEYSTROKE, pasteKey);
        actionMap.put(pasteKey, PASTE_ACTION);
        Object selectAllKey = inputMap.get(SELECT_ALL_KEYSTROKE);
        if (selectAllKey == null || selectAllKey.equals(cutKey) || selectAllKey.equals(copyKey) || selectAllKey.equals(pasteKey)) {
            selectAllKey = "selectAll";
        }
        inputMap.put(SELECT_ALL_KEYSTROKE, selectAllKey);
        actionMap.put(selectAllKey, SELECT_ALL_ACTION);
    }

    public static JPopupMenu createDefaultPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(CUT_ACTION.createMenuItem());
        popupMenu.add(COPY_ACTION.createMenuItem());
        popupMenu.add(PASTE_ACTION.createMenuItem());
        popupMenu.addSeparator();
        popupMenu.add(SELECT_ALL_ACTION.createMenuItem());
        return popupMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void targetGainedFocus(ClipboardTarget target) {
        if (target == null) {
            throw new NullPointerException();
        }
        ClipboardTargetManager clipboardTargetManager = INSTANCE;
        synchronized (clipboardTargetManager) {
            ClipboardTargetManager.INSTANCE.lastFocusedTarget = target;
            CUT_ACTION.setEnabled(target.canCut());
            COPY_ACTION.setEnabled(target.canCopy());
            PASTE_ACTION.setEnabled(target.canPaste());
            SELECT_ALL_ACTION.setEnabled(target.canSelectAll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void targetLostFocus(ClipboardTarget target) {
        if (target == null) {
            throw new NullPointerException();
        }
        ClipboardTargetManager clipboardTargetManager = INSTANCE;
        synchronized (clipboardTargetManager) {
            ClipboardTargetManager.INSTANCE.lastFocusedTarget = target;
            CUT_ACTION.setEnabled(target.canCut());
            COPY_ACTION.setEnabled(target.canCopy());
            PASTE_ACTION.setEnabled(target.canPaste());
            SELECT_ALL_ACTION.setEnabled(target.canSelectAll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void targetAbilityChanged(ClipboardTarget target) {
        if (target == null) {
            throw new NullPointerException();
        }
        ClipboardTargetManager clipboardTargetManager = INSTANCE;
        synchronized (clipboardTargetManager) {
            if (ClipboardTargetManager.INSTANCE.lastFocusedTarget == target) {
                CUT_ACTION.setEnabled(target.canCut());
                COPY_ACTION.setEnabled(target.canCopy());
                PASTE_ACTION.setEnabled(target.canPaste());
                SELECT_ALL_ACTION.setEnabled(target.canSelectAll());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClipboardTarget getRecentTarget() {
        ClipboardTargetManager clipboardTargetManager = INSTANCE;
        synchronized (clipboardTargetManager) {
            ClipboardTarget target = ClipboardTargetManager.INSTANCE.lastFocusedTarget;
            if (target != null) {
                if (target instanceof Component) {
                    for (Component component = (Component)((Object)target); component != null; component = component.getParent()) {
                        if (component.isVisible()) continue;
                        return null;
                    }
                }
                return target;
            }
            return null;
        }
    }

    public static void cut() {
        ClipboardTarget target = ClipboardTargetManager.getRecentTarget();
        if (target != null) {
            target.cut();
        }
    }

    public static void copy() {
        ClipboardTarget target = ClipboardTargetManager.getRecentTarget();
        if (target != null) {
            target.copy();
        }
    }

    public static void paste() {
        ClipboardTarget target = ClipboardTargetManager.getRecentTarget();
        if (target != null) {
            target.paste();
        }
    }

    public static void selectAll() {
        ClipboardTarget target = ClipboardTargetManager.getRecentTarget();
        if (target != null) {
            target.selectAll();
        }
    }

    protected static class SelectAllAction
    extends AbstractAction2 {
        protected SelectAllAction() {
            super("Select All", SELECT_ALL_ICON);
            this.setAccelerator(SELECT_ALL_KEYSTROKE);
            this.setMnemonic(65);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardTargetManager.selectAll();
        }
    }

    protected static class PasteAction
    extends AbstractAction2 {
        protected PasteAction() {
            super("Paste", PASTE_ICON);
            this.setAccelerator(PASTE_KEYSTROKE);
            this.setMnemonic(80);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardTargetManager.paste();
        }
    }

    protected static class CopyAction
    extends AbstractAction2 {
        protected CopyAction() {
            super("Copy", COPY_ICON);
            this.setAccelerator(COPY_KEYSTROKE);
            this.setMnemonic(67);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardTargetManager.copy();
        }
    }

    protected static class CutAction
    extends AbstractAction2 {
        protected CutAction() {
            super("Cut", CUT_ICON);
            this.setAccelerator(CUT_KEYSTROKE);
            this.setMnemonic(67);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardTargetManager.cut();
        }
    }
}

