/******************************************************************************
 *  Compilation:  javac BoardChecker.java
 *  Execution:    java  BoardChecker goalNumber filename1.txt filename2.txt ...
 *  Dependencies: Board.java Solver.java
 *
 *  This program creates an initial board from each filename specified
 *  on the command line and finds the minimum number of moves to
 *  reach the goal state where the goal value is given in the command line.
 *
 *  % java BoardChecker 2048 Board3.txt Board4.txt Board5.txt 
 *           Board6.txt Board7.txt Board8.txt
 *  filename                    moves     time
 *  ------------------------------------------
 *  Board3.txt                      1     0.01
 *  Board4.txt                      2     0.00
 *  Board5.txt                      3     0.00
 *  Board6.txt                      2     0.00
 *  Board7.txt                      5     0.00
 *  Board8.txt                      0     0.00
 * 
 ******************************************************************************/

import edu.princeton.cs.algs4.In;
import edu.princeton.cs.algs4.StdOut;
import edu.princeton.cs.algs4.Stopwatch;

public class BoardChecker {

    public static void main(String[] args) {

        // header
        StdOut.printf("%-25s %7s %8s\n", "filename", "moves", "time");
        StdOut.println("------------------------------------------");

        int goal = Integer.parseInt(args[0]);
        // for each command-line argument
        for (int i = 1; i < args.length; i++) {
            // read in the board specified in the filename
            String filename = args[i];
            In in = new In(filename);
            int n = in.readInt();
            int[][] blocks = new int[n][n];
            for (int row = 0; row < n; row++)
                for (int col = 0; col < n; col++)
                    blocks[row][col] = in.readInt();
            Board initial = new Board(blocks, goal);

            // check if board is solvable; if so, solve it print out number of moves
            //if (initial.isSolvable()) {
                Stopwatch timer = new Stopwatch();
                Solver solver = new Solver(initial);
                int moves = solver.moves();
                double time = timer.elapsedTime();
                StdOut.printf("%-25s %7d %8.2f\n", filename, moves, time);
            //}
        }
    }
}
