import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.io.*;

public class ToySim extends Applet implements ActionListener, AdjustmentListener
{
	public int[] R; public int[] mem;   
	public int  pc; 
	public int curData; public int curMem;
	char[] dataLights = new char[16];
	char[] dataSwitch = new char[16];
	char[] memLights = new char[8];
	char[] memSwitch = new char[8];
	Point[] dataSwLoc = new Point[16];    
	Point[] memSwLoc = new Point[8];
	boolean goPressed=false; int displayVal=1;
	boolean stepThrough = false;
	/*goPressed true if go is pressed or */
	/*the instructions were loaded from  */
	/*html.                              */
	String showStep; String showStep2; String instruct;
	String lastLoaded;
	
	Button b_load; Button b_go; Button b_look;
	Button b_loadfApplet; Button b_step;
	Button b_reset;
	Scrollbar scr_display;
	
	public void init()
	{
		Font f  =   new Font("SansSerif",   Font.BOLD, 14);
		this.setFont(f);
		
		R=new int[8]; mem=new int[256]; pc=16;      
		for(int i=0; i<256; i++) mem[i]=0;
		for(int i=0; i<8;   i++){R[i]=0; memLights[i]=0;memSwitch[i]=0;}
		memSwitch[3]=1;
		for(int i=0; i<16; i++){dataLights[i]=0; dataSwitch[i]=0;}
		
		b_load = new Button("Load"); b_go   =   new Button("Go");
		b_look = new Button("Look"); b_step = new Button("Step");
		b_loadfApplet = new Button("Load From HTML");
		b_reset = new Button("Reload From HTML");
		scr_display = new Scrollbar(Scrollbar.HORIZONTAL, 1, 0, 0, 15);
		
		
		b_load.addActionListener(this);
		b_go.addActionListener(this);
		b_look.addActionListener(this);
		b_step.addActionListener(this);
		b_loadfApplet.addActionListener(this);
		b_reset.addActionListener(this);
		scr_display.addAdjustmentListener(this);
		addMouseListener(new MouseAdapter()
			{public void mouseClicked(MouseEvent evt)
			{ToySim.this.mouseClicked(evt);}
			});
		setLayout(null);
		add(b_load); add(b_go);
		add(b_look); add(b_step);
		add(b_loadfApplet); add(b_reset);
		add(scr_display);    
		b_load.setBounds(340, 70, 50, 20);
		b_go.setBounds(400, 70, 50, 20);
		b_look.setBounds(460, 70, 50, 20);
		b_step.setBounds(400, 100, 50, 20);
		b_loadfApplet.setBounds(160, 350, 150, 20);
		b_reset.setBounds(160, 300, 150, 20);
		scr_display.setBounds(528, 275, 165, 20);
		
		finishLoad("BlankProgram");
		setValsToSwitches();
	}
	
	public void loadFunction()
	{
		pc = curMem;
		mem[pc] = curData;
		repaint();
	}
	
	
	/**********************************/
	/*Sets memSwitch and dataSwitch to*/
	/*values displayed by the switches*/
	/**********************************/
	public void setValsToSwitches()
	{
		curData=0;
		curMem=0;
		
		for(int i=0; i<8; i++) curMem = (curMem<<1)+memSwitch[i];
		for(int i=0; i<16; i++) curData = (curData<<1)+dataSwitch[i];                                                 
	}
	
	public int getValFromMemSwitch()
	{
		int temp=0;
		curData=0; 
		for(int i=0; i<8; i++) temp = (temp<<1)+memSwitch[i];

		return temp;
	}
	
	public void setMemSwitchesToVals()
	{
		String zero = "0";
		String mems = new String();
		mems = Integer.toBinaryString(pc);
		
		while(mems.length()<8) mems = zero + mems;
		for(int i=0; i<8; i++)
		{
			if(mems.substring(i, i+1).equalsIgnoreCase("0"))
				memSwitch[i]=0;
			else memSwitch[i]=1;
		}
	}
	
	
	
	public void mouseClicked(MouseEvent evt)
	{
		int x = evt.getX(); int y = evt.getY();
		boolean holder = stepThrough;
		for(int i=0; i<16; i++)
		{
			if(x>dataSwLoc[i].x && x<dataSwLoc[i].x+SWITCHWIDTH &&
			   y>dataSwLoc[i].y && y<dataSwLoc[i].y+SWITCHHEIGHT)
			{
				stepThrough=true;
				if(dataSwitch[i]==0) dataSwitch[i]=1;
				else dataSwitch[i]=0;
				
				setValsToSwitches();
				repaint();
			}
		}
		
		for(int i=0; i<8; i++)
		{
			if(x>memSwLoc[i].x && x<memSwLoc[i].x+SWITCHWIDTH &&
			   y>memSwLoc[i].y && y<memSwLoc[i].y+SWITCHHEIGHT)
			{
				if(memSwitch[i]==0) memSwitch[i]=1;
				else memSwitch[i]=0;
				setValsToSwitches();
				repaint();
			}
		}
		stepThrough = holder;
	}               
	
	/**************************************/
	/*Loads instructions from   applet. Uses*/
	/*getParameter() function   call to get */
	/*instructions.                                             */
	/**************************************/
	public void loadFromApplet()
	{
		String temp = getParameter("ProgNames");
		int i=0; int j=0; String name = new String();;
		String[]perm = new String[30];
		
		for(i=0; i<256; i++) mem[i]=0;
		for(i=0; i<8; i++){memLights[i]=0;}
		for(i=0; i<16; i++){dataLights[i]=0;}
		for(i=0; i<8; i++) R[i]=0;
		pc=16;
		
		for(i=0,j=0; i<temp.length(); i++)
		{
			if(temp.substring(i, i+1).equalsIgnoreCase(" ")==false)
				name = name+temp.substring(i, i+1);
			if(temp.substring(i, i+1).equalsIgnoreCase(" ") || 
			   i==(temp.length()-1))
			{
				perm[j]=name;
				name= new String();
				j++;
			}
		}
		
		LoadDialog loader = new LoadDialog();
		loader.setSize(300, 200);
		loader.LoadDialog(this, perm, j);
		loader.show();
	}
	
	public void finishLoad(String param)
	{
		lastLoaded = param;
		int addr; int data; int arrayLength;
		String longStr = getParameter(param);
		arrayLength =   longStr.length();
		int pcHold = pc;
		longStr.trim();
		for(int i=0; i<arrayLength; i=i+7)
		{
			while(longStr.substring(i, i+1).equalsIgnoreCase(" ")) i++;
			
			String temp =   longStr.substring(i, i+7);
			data = Integer.parseInt(temp.substring(3, 7),16);
			pcHold = Integer.parseInt(temp.substring(0, 2), 16);
			mem[pcHold]=data;
			pcHold++;
		}
		goPressed=true;
		repaint();
	}
	
	public void resetFunction()
	{
		for(int i=0; i<8;   i++){R[i]=0; memLights[i]=0;memSwitch[i]=0;}
		memSwitch[3]=1;
		for(int i=0; i<16; i++){dataLights[i]=0; dataSwitch[i]=0;}
		for(int i=0; i<256; i++)mem[i]=0;
		pc=16;
		setValsToSwitches();
		finishLoad(lastLoaded);
	}
	
	public void adjustmentValueChanged(AdjustmentEvent evt)
	{
		displayVal = scr_display.getValue();
		repaint();
	}
	
	public void actionPerformed(ActionEvent evt)
	{
		String arg = evt.getActionCommand();
		if(arg.equals("Load From HTML"))
		{
			loadFromApplet();
		}
		else if(arg.equals("Step")) stepToy();
		
		else if(arg.equals("Load"))
		{stepThrough = false; loadFunction();}
		
		else if(arg.equals("Look"))
		{pc = curMem; lookFunction();}
		
		else if(arg.equals("Go"))
		{stepThrough = false; goFunction(); stepThrough=true;}
		
		else if(arg.equals("Reload From HTML"))
		{stepThrough = false; resetFunction();}
		
		else System.out.println("Zounds!!!");
		repaint();
	}
	
	public void lookFunction()
	{
		int addr;   String zero = "0";
		
		String tempLights = Integer.toBinaryString(pc);
		while(tempLights.length()<8) tempLights = zero+tempLights;
		memLights = tempLights.toCharArray();
		for(int i=0; i<tempLights.length(); i++)
		{
			if(tempLights.substring(i, i+1).equals("0")) memLights[i]=0;
			else memLights[i]=1;
		}
		
		String tempStr = Integer.toBinaryString(mem[pc]);
		while(tempStr.length()<16) tempStr = zero+tempStr;
		for(int i=0; i<tempStr.length(); i++)
		{
			if(tempStr.substring(i, i+1).equals("0")) dataLights[i]=0;
			else dataLights[i]=1;
		}
	}
	
	/*****************************/
	/*Gets description of current*/
	/*instruction.      0=48     */
	/*****************************/
	public void getInstDescr(Graphics bg)
	{
		Font descrCourier = new Font("Courier", Font.BOLD, 18);
		char [] tempInst;
		bg.setFont(descrCourier);
		String zero = "0";
		String A = "A";
		String a = "a";
		instruct = Integer.toHexString(mem[pc]);
		instruct = instruct.toUpperCase();
		while(instruct.length()<4) instruct = zero+instruct;
		tempInst = instruct.toCharArray();
		
		
		
		if(instruct.substring(0,1).equalsIgnoreCase("9"))
		{
			bg.drawString("Load", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("R"+hold+"<-mem[R"+tempInst[2]+"+"+
							  "R"+tempInst[3]+"]", 480, 360);
			}
			else bg.drawString("R"+instruct.substring(1,2)+
							   "<-mem["+instruct.substring(2,4)+"]", 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("A"))
		{
			bg.drawString("Store", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("mem[R"+tempInst[2]+"+"+
							  "R"+tempInst[3]+"]<-R"+hold, 480, 360);
			}
			else bg.drawString("R"+instruct.substring(1,2)+
							   "->mem["+instruct.substring(2,4)+"]", 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("B"))
		{
			bg.drawString("Load Addr", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("R"+hold+"<-R"+tempInst[2]+"+R"+tempInst[3], 480, 360);
			}
			else bg.drawString("R"+instruct.substring(1,2)+
							   "<-"+instruct.substring(2,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("1"))
		{
			bg.drawString("Add", 480, 340);
			bg.drawString("R"+instruct.substring(1,2)+
						  "=R"+instruct.substring(2,3)+"+R"+
						  instruct.substring(3,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("2"))
		{
			bg.drawString("Subtract", 480, 340);
			bg.drawString("R"+instruct.substring(1,2)+
						  "=R"+instruct.substring(2,3)+"-R"+
						  instruct.substring(3,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("3"))
		{
			bg.drawString("Multiply", 480, 340);
			bg.drawString("R"+instruct.substring(1,2)+
						  "=R"+instruct.substring(2,3)+"*R"+
						  instruct.substring(3,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("C"))
		{
			bg.drawString("XOR", 480, 340);
			bg.drawString("r"+instruct.substring(1,2)+
						  "=r"+instruct.substring(2,3)+"^r"+
						  instruct.substring(3,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("D"))
		{
			bg.drawString("AND", 480, 340);
			bg.drawString("R"+instruct.substring(1,2)+
						  "=R"+instruct.substring(2,3)+"&R"+
						  instruct.substring(3,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("E"))
		{
			bg.drawString("Shift Right", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("R"+instruct.substring(1,2)+
							  "="+instruct.substring(1,2)+">>"+"R"+
							  instruct.substring(2,3)+"+R"+tempInst[3], 480, 360);
			}
			else bg.drawString("R"+instruct.substring(1,2)+
							   "="+instruct.substring(1,2)+">>"+
							   instruct.substring(2,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("F"))
		{
			bg.drawString("Shift Left", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("R"+instruct.substring(1,2)+
							  "="+instruct.substring(1,2)+"<<"+"R"+
							  instruct.substring(2,3)+"+R"+tempInst[3], 480, 360);
			}
			else bg.drawString("R"+instruct.substring(1,2)+
							   "="+instruct.substring(1,2)+
							   "<<"+instruct.substring(2,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("0"))
			bg.drawString("Halt", 480, 340);
		
		else if(instruct.substring(0,1).equalsIgnoreCase("4"))
			bg.drawString("Call to Output", 480, 340);
		
		else if(instruct.substring(0,1).equalsIgnoreCase("5"))
		{
			bg.drawString("Jump", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("pc<-"+"R"+tempInst[2]+"+R"+tempInst[3], 480, 360);
			}
			else bg.drawString("pc<-" + instruct.substring(2,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("6"))
		{
			bg.drawString("Jump if Positive", 480, 340);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("if(R"+instruct.substring(1,2)+">0)pc<-"+"R"+
							  tempInst[2]+"+R"+tempInst[3], 480, 360);
			}
			else bg.drawString("if(R"+instruct.substring(1,2)+">0) pc<-"+
							   instruct.substring(2,4), 480, 360);
		}
		
		else if(instruct.substring(0,1).equalsIgnoreCase("7"))
		{
			bg.drawString("Jump and Count", 480, 340);
			bg.drawString("R"+instruct.substring(1,2) + "<-R"+
						  instruct.substring(1,2)+"-1", 480, 360);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("if(R"+instruct.substring(1,2)+"!=0)pc<-"+"R"+
							  tempInst[2]+"+R"+tempInst[3], 480, 380);
			}
			else bg.drawString("if(R"+instruct.substring(1,2)+"!=0) pc<-"+
							   instruct.substring(2,4), 480, 380);
		}                                                                                                                                                           
		
		else if(instruct.substring(0,1).equalsIgnoreCase("8"))
		{
			bg.drawString("Jump and Link", 480, 340);
			bg.drawString("R"+instruct.substring(1,2)+"<-pc;", 480, 360);
			if(tempInst[1]>55)
			{
				int hold = Integer.parseInt(instruct.substring(1,2), 16);
				hold=hold-8;
				bg.drawString("pc<-"+"R"+tempInst[2]+"+R"+tempInst[3], 480, 380);
			}
			else bg.drawString("pc<-"+instruct.substring(2,4)+";", 480, 380);
		}
	}
	
	public void update(Graphics g)
	{
		paint(g);
	}
	public void paint(Graphics g)
	{
		
		Dimension d = getSize();
		Insets in = getInsets();
		int clientWidth = d.width-in.right-in.left;
		int clientHeight = d.height-in.bottom-in.top;
		
		buffer_image = createImage(clientWidth, clientHeight);
		bg = buffer_image.getGraphics();
		/*Draws rectangle for machine*/
		Color ID;       
		ID = new Color(43, 70, 94);
		bg.setColor(ID);
		bg.fillRect(20, 20, 500, 220);
		
		/*Sets font type and size for machine title*/
		Font arial = new Font("Arial", Font.PLAIN, 18);
		Font small = new Font("Arial", Font.BOLD, 12);
		Font newTemp = new Font("Arial", Font.BOLD, 18);
		Font courier = new Font("Courier", Font.BOLD, 16);
		Font bigDisplay = new Font("Arial", Font.BOLD, 36);
		Font regValFont = new Font("Arial", Font.BOLD, 24);
		
		lookFunction();
		bg.setFont(arial);
		bg.setColor(Color.white);
		bg.drawString("TOY machine v.6.0", 30, 40);
		
		bg.drawString("ADDR:", 25, 105);
		bg.drawString("DATA:", 25, 175);
		
		bg.setColor(Color.black);
		int k=0;
		
		/*********************************/
		/*Draws boxes for the registers  */
		/*********************************/
		for(int i=0; i<450; i=i+62)
		{
			bg.setFont(arial);
			bg.drawRect(20+i, 245, 62, 30);
			bg.drawString("R"+k, 25+i, 260);
			String temp =Integer.toHexString(R[k]).toUpperCase();
			bg.setFont(regValFont);
			bg.drawString(temp, 50+i, 273);
			k++;
		}
		
		bg.setColor(Color.gray);
		
		/*********************************/
		/*Draws switches for data inputs */
		/*********************************/
		int count=0;
		int spacer=0;
		for(int i=80, j=0; j<16; i=i+26, j++)
		{
			if(count%4==0) spacer=spacer+7;
			bg.setColor(Color.gray);
			bg.fillRect(i+spacer, 160, 17, 34);
			dataSwLoc[count] = new Point();
			dataSwLoc[count].x = i+spacer;
			dataSwLoc[count].y = 160;
			bg.setColor(Color.white);
			
			if(dataSwitch[count]==0)
				bg.fill3DRect(i+spacer, 160, 17, 17, true);
			else bg.fill3DRect(i+spacer, 177, 17, 17, true);        
			
			if(dataLights[count]==0)bg.setColor(Color.red);
			else bg.setColor(Color.green);
			bg.fillOval(i+spacer, 137, 17, 17);
			
			count++;
		}
		
		/********************************/
		/*Draws switches for mem inputs */
		/********************************/
		count=0;
		spacer=0;
		for(int i=80, j=0; j<8; i=i+26, j++)
		{
			if(count%4==0) spacer=spacer+7;
			bg.setColor(Color.gray);
			bg.fillRect(i+spacer, 90, 17, 34);
			memSwLoc[count] = new Point();
			memSwLoc[count].x = i+spacer;
			memSwLoc[count].y = 90;
			bg.setColor(Color.white);
			if(memSwitch[count]==0)
				bg.fill3DRect(i+spacer, 90, 17, 17, true);
			else bg.fill3DRect(i+spacer, 107, 17, 17, true);
			
			if(memLights[count]==0) bg.setColor(Color.red);
			else bg.setColor(Color.green);
			bg.fillOval(i+spacer, 67, 17, 17);
			
			count++;
		}   
		
		bg.setColor(Color.white);
		bg.drawLine(87, 205, 182, 205);
		bg.drawLine(dataSwLoc[4].x, 205, dataSwLoc[7].x+17, 205);
		bg.drawLine(dataSwLoc[8].x, 205, dataSwLoc[11].x+17, 205);
		bg.drawLine(dataSwLoc[12].x, 205, dataSwLoc[15].x+17, 205);
		bg.setFont(small);
		bg.drawString("Op Code", 115, 220);
		bg.drawString("Dest.", 230, 220);
		bg.drawString("Format 1: Reg A", 315, 220);
		bg.drawString("Format 1: Reg B", 420, 220);
		bg.drawString("Format 2: addr/const", 350, 235);
		
		/*********************************/
		/*Begin code for curdata and     */
		/*current memory display.        */
		/*********************************/
		bg.setColor(Color.black);
		Font Arial_Bold_15 = new Font("Arial", Font.BOLD, 25);
		bg.setFont(Arial_Bold_15);
		String zero = "0";
		String memString = Integer.toHexString(curMem);
		String dataString = Integer.toHexString(curData);
		while(memString.length()<2) memString = zero+memString;
		while(dataString.length()<4) dataString = zero+dataString;
		memString = memString.toUpperCase();
		dataString = dataString.toUpperCase();
		bg.drawString("Mem: "+memString, 15, 320);
		bg.drawString("Data: "+dataString, 15, 370);
		
		/*********************************/
		/*Begin code for memory and inst */
		/*display.                       */
		/*********************************/
		bg.setColor(Color.black);
		bg.drawRect(530, 10, 160, 275);
		
		bg.setFont(newTemp);
		bg.drawString("Memory", 570, 25);
		
		count=0;
		if(goPressed) getInstDescr(bg);
		bg.setFont(courier);
		for(int i=0; i<2; i++)
		{  
			for(int j=0+16*displayVal; j<16+16*displayVal; j++)
			{
				count = i*16+j;
				String argNumb = Integer.toHexString(count) + ":";
				String arg = Long.toHexString(mem[count]);
				if(mem[count]==0) arg="0000";
				arg = argNumb+arg;
				arg = arg.toUpperCase();
				
				if(goPressed && count==pc)
				{
					bg.setColor(Color.red);
					bg.drawString(arg, 533+84*i, 45+15*(j%16));
					bg.setColor(Color.black);
					bg.setFont(newTemp);
					bg.setFont(courier);
				}
				else bg.drawString(arg, 533+84*i, 45+15*(j%16));
			}
		}
		
		/*Shows current instruction*/
		bg.drawRect(315, 300, 375, 80); //draws large rect for instructions
		bg.setFont(newTemp);
		bg.drawString("Current Instruction", 420, 315);
		bg.drawRect(415, 300, 173, 20); //draws rect around box title
		
		String valShow = Integer.toHexString(mem[pc]).toUpperCase();
		String tempPC = Integer.toHexString(pc).toUpperCase();
		while(valShow.length()<4)valShow= zero+valShow;
		while(tempPC.length()<2) tempPC = zero+tempPC;
		bg.setFont(bigDisplay);
		if(goPressed)bg.drawString(tempPC+":"+valShow, 330, 355);
		
		bg.dispose();
		g.drawImage(buffer_image, 0,0, null);
		System.out.println(+pc);
		System.out.print("MemSwitch=");
		for(int l=0; l<8; l++) System.out.print(+memSwitch[l]);
		System.out.println();
	}
	
	public void stepToy()
	{
		int op, addr,   r0, r1, r2, inst;
		int ikeTemp;

		goPressed=true;
		inst=mem[pc];
		if(inst==0){showStatus("At Halt"); return;}
		pc++;
		op = (inst >>   12) &   0xF;
		addr = inst &   0xFF;
		r0 = (inst >>   8) & 0x7;
		r1 = (inst >>   4) & 0x7;
		r2 = inst   &   0x7;
		ikeTemp =   (inst & 0x0800);
		if(ikeTemp>0) 
			addr    =   (R[r1]+R[r2])&0x0FF;
		switch(op)
		{
		case 0: {break;}
		case 1: {R[r0] = R[r1]+R[r2];           break;}
		case 2: {R[r0] = R[r1]-R[r2];         break;}
		case 3: {R[r0] = R[r1]*R[r2];           break;}
		case 4: {System.out.println(+addr); break;}
		case 5: {pc =   addr;                           break;}
		case 6: {if(R[r0]>0) pc =addr;        break;}
		case 7: {if(--R[r0]>0)  pc = addr;  break;}
		case 8: {R[r0] = pc; pc =   addr;     break;}
		case 9: {R[r0] = mem[addr];         break;}
		case 10: {mem[addr] =   R[r0];        break;}
		case 11: {R[r0]=addr;               break;}
		case 12: {R[r0] =   R[r1]^R[r2];          break;}
		case 13: {R[r0] =   R[r1]&R[r2];          break;}
		case 14: {R[r0] =   R[r0]>>addr;          break;}
		case 15: {R[r0] =   R[r0]<<addr;          break;}
		}
		//setMemSwitchesToVals();  //Not changing switches for PC
	}
	
	public void goFunction()
	{
		int op, addr,   r0, r1, r2, inst;
		int ikeTemp;
		while(mem[pc]!=0)
		{
			goPressed=true;
			inst=mem[pc];
			if(inst==0){showStatus("At Halt"); return;}
			pc++;
			op = (inst >>   12) &   0xF;
			addr = inst &   0xFF;
			r0 = (inst >>   8) & 0x7;
			r1 = (inst >>   4) & 0x7;
			r2 = inst   &   0x7;
			ikeTemp =   inst & 0x0800;
			if(ikeTemp>0)
				addr    =   (R[r1]+R[r2])&0x0FF;
			switch(op)
			{
			case 0: {break;}
			case 1: {R[r0] = R[r1]+R[r2];           break;}
			case 2: {R[r0] = R[r1]-R[r2];         break;}
			case 3: {R[r0] = R[r1]*R[r2];           break;}
			case 4: {System.out.println(+addr); break;}     
			case 5: {pc =   addr;                           break;}
			case 6: {if(R[r0]>0) pc =addr;        break;}
			case 7: {if(--R[r0]>0)  pc = addr;  break;}
			case 8: {R[r0] = pc; pc =   addr;     break;}
			case 9: {R[r0] = mem[addr];         break;}
			case 10: {mem[addr] =   R[r0];        break;}
			case 11: {R[r0]=addr;               break;}
			case 12: {R[r0] =   R[r1]^R[r2];      break;}
			case 13: {R[r0] =   R[r1]&R[r2];      break;}
			case 14: {R[r0] =   R[r0]>>addr;      break;}
			case 15: {R[r0] =   R[r0]<<addr;      break;}
			}
			//setMemSwitchesToVals(); //Not changing switches for PC
		}
	}
	Graphics bg;
	Image buffer_image;
	
	static final int SWITCHWIDTH = 15;
	static final int SWITCHHEIGHT = 30;
}
class LoadDialog extends Frame implements ActionListener
{
	Button ok = new Button("OK");
	Button cancel = new Button("Cancel");
	List htmlProgs;
	String[] names = new String[20];
	ToySim parent;
	
	public void LoadDialog(ToySim par, String[] progs, int numb)
	{
		Canvas can = new AppLoadCan1();
		parent = par;
		Font f  =   new Font("SansSerif",   Font.BOLD, 16);
		this.setFont(f);
		setLayout(new BorderLayout());
		Panel p = new Panel();
		p.setLayout(new FlowLayout());
		htmlProgs = new List(6, false);
		add(can);
		p.add(htmlProgs);
		p.add(ok);
		p.add(cancel);
		for(int i=0; i<numb; i++)
		{
			htmlProgs.add(progs[i]);
		}
		add(p, "South");
		ok.addActionListener(this);
		cancel.addActionListener(this);
		can.setBounds(0, 0, 300, 100);
		p.setBounds(0, 100, 300, 200);
	}
	public void actionPerformed(ActionEvent evt)
	{
		String arg = evt.getActionCommand();
		if(arg.equals("OK"))
		{
			parent.finishLoad(htmlProgs.getSelectedItem());
			dispose();
		}
		else if(arg.equals("Cancel")) dispose();
		else System.out.println("maybe");
	}
}

class AppLoadCan1 extends Canvas
{
	public void paint(Graphics g)
	{
		Font f  =   new Font("SansSerif",Font.BOLD, 16);
		g.setFont(f);
		g.drawString("Select program to load:", 25, 25);
	}
}