let rec mem x l =
  match l with
  | [] -> false
  | hd::tl -> if x = hd then true else mem x tl

let rec rev l res =
  match l with
  | [] -> res
  | hd::tl -> rev tl (hd::res)

let reverse l = rev l []

(* Prove the theorem: 
for all x:int. for all l:int list. mem x (reverse l) == mem x l *)

(* 
lemma: forall x:int. forall l:int list. forall res: int list.
  mem x (rev l res) = mem x l || mem x res

some useful boolean properties:
for all b : bool, b || true == true.
for all b : bool, true || b == true.
for all b : bool, b || false == b.
for all b : bool, false || b == b.

Base Case: l = []
WTP: mem x (rev [] res) = mem x [] || mem x res

mem x (rev [] res)      (LHS)
= mem x (match [] with [] -> res ...) (eval rev)
= mem x (res)         (eval match)
= false || mem x res  (boolean property)
= match [] with [] -> false ... || mem x res    (reverse eval match)
= mem x [] || mem x res       (reverse eval mem)

Inductive Step: l = hd::tl
IH: forall l:int list. forall rest: int list.
  mem x (rev tl rest) = mem x tl || mem x rest

WTP: mem x (rev hd::tl res) = mem x hd::tl || mem x res

mem x (rev (hd::tl) res)
= mem x (match hd::tl with ... | hd::tl -> rev tl (hd::res))    (eval rev)
= mem x (rev tl hd::res)        (eval match)
since rest can be any int list, we can use our IH here where hd::res = rest
= mem x tl || mem x hd::res     (IH)
= mem x tl || if x = hd then true else mem x res    (eval mem)

CASE 1: x=hd
= mem x tl || true      (eval if)
= true                  (boolean property)
= true || mem x res    (boolean property)
= if x = hd then true else mem x tl || mem x res  (reverse eval)
= mem x (hd::tl) || mem x res       (reverse eval)

CASE 2: x != hd
= mem x tl || mem x res     (eval if)
= if x = hd then true else mem x tl || mem x res     (reverse eval if)
= mem x (hd::tl) || mem x res         (reverse eval mem)

QED!

So, now we prove the original theorem: 
  for all x:int. for all l:int list. mem x (reverse l) == mem x l

mem x (reverse l)   (LHS)
= mem x (rev l [])  (eval reverse)
= mem x l || mem x [] (lemma)
= mem x l || match [] with [] -> false ...  (eval mem)
= mem x l || false      (eval match)
= mem x l       (boolean property)

QED!
*)